"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InversifyBinding = void 0;
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
require("reflect-metadata");
const inversify_1 = require("inversify");
const devfile_module_1 = require("../devfile/devfile-module");
const fetch_module_1 = require("../fetch/fetch-module");
const github_module_1 = require("../github/github-module");
const plugin_registry_module_1 = require("../plugin-registry/plugin-registry-module");
/**
 * Manage all bindings for inversify
 */
class InversifyBinding {
    async initBindings(options) {
        this.container = new inversify_1.Container();
        this.container.load(devfile_module_1.devfileModule);
        this.container.load(fetch_module_1.fetchModule);
        this.container.load(github_module_1.githubModule);
        this.container.load(plugin_registry_module_1.pluginRegistryModule);
        this.container.bind(Symbol.for('AxiosInstance')).toConstantValue(options.axiosInstance);
        this.container.bind('string').toConstantValue(options.pluginRegistryUrl).whenTargetNamed('PLUGIN_REGISTRY_URL');
        this.container.bind('boolean').toConstantValue(options.insertTemplates).whenTargetNamed('INSERT_TEMPLATES');
        return this.container;
    }
}
exports.InversifyBinding = InversifyBinding;
//# sourceMappingURL=inversify-binding.js.map