"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
exports.__esModule = true;
exports.GithubUrl = void 0;
/**
 * Provides helper methods on top of github URL to get for example raw content of get relative links
 */
var GithubUrl = /** @class */ (function () {
    function GithubUrl(repoUser, repoName, branchName, subFolder) {
        this.repoUser = repoUser;
        this.repoName = repoName;
        this.branchName = branchName;
        this.subFolder = subFolder;
    }
    /**
     * Provides the raw link to the given path based on the current repository information
     */
    GithubUrl.prototype.getContentUrl = function (path) {
        return GithubUrl.RAW_LINK + "/" + this.repoUser + "/" + this.repoName + "/" + this.branchName + "/" + path;
    };
    GithubUrl.prototype.getUrl = function () {
        return "https://github.com/" + this.repoUser + "/" + this.repoName + "/tree/" + this.branchName + "/" + this.subFolder;
    };
    GithubUrl.prototype.getCloneUrl = function () {
        return "https://github.com/" + this.repoUser + "/" + this.repoName + ".git";
    };
    GithubUrl.prototype.getRepoName = function () {
        return this.repoName;
    };
    GithubUrl.prototype.getBranchName = function () {
        return this.branchName;
    };
    // raw link
    GithubUrl.RAW_LINK = 'https://raw.githubusercontent.com';
    return GithubUrl;
}());
exports.GithubUrl = GithubUrl;
//# sourceMappingURL=github-url.js.map