"use strict";
/**
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1.22.2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomObjectsApi = exports.CustomObjectsApiApiKeys = void 0;
const tslib_1 = require("tslib");
const request_1 = tslib_1.__importDefault(require("request"));
const models_1 = require("../model/models");
const models_2 = require("../model/models");
const apis_1 = require("./apis");
let defaultBasePath = 'http://localhost';
// ===============================================
// This file is autogenerated - Please do not edit
// ===============================================
var CustomObjectsApiApiKeys;
(function (CustomObjectsApiApiKeys) {
    CustomObjectsApiApiKeys[CustomObjectsApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(CustomObjectsApiApiKeys = exports.CustomObjectsApiApiKeys || (exports.CustomObjectsApiApiKeys = {}));
class CustomObjectsApi {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this._defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new models_1.VoidAuth(),
            'BearerToken': new models_2.ApiKeyAuth('header', 'authorization'),
        };
        this.interceptors = [];
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    set defaultHeaders(defaultHeaders) {
        this._defaultHeaders = defaultHeaders;
    }
    get defaultHeaders() {
        return this._defaultHeaders;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[CustomObjectsApiApiKeys[key]].apiKey = value;
    }
    addInterceptor(interceptor) {
        this.interceptors.push(interceptor);
    }
    /**
     * Creates a cluster scoped Custom object
     * @param group The custom resource\&#39;s group name
     * @param version The custom resource\&#39;s version
     * @param plural The custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param body The JSON schema of the Resource to create.
     * @param pretty If \&#39;true\&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).
     */
    async createClusterCustomObject(group, version, plural, body, pretty, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling createClusterCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling createClusterCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling createClusterCustomObject.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createClusterCustomObject.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = models_1.ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * Creates a namespace scoped Custom object
     * @param group The custom resource\&#39;s group name
     * @param version The custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural The custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param body The JSON schema of the Resource to create.
     * @param pretty If \&#39;true\&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.
     */
    async createNamespacedCustomObject(group, version, namespace, plural, body, pretty, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling createNamespacedCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling createNamespacedCustomObject.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling createNamespacedCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling createNamespacedCustomObject.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createNamespacedCustomObject.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = models_1.ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * Deletes the specified cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom object\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object\&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param body
     */
    async deleteClusterCustomObject(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling deleteClusterCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling deleteClusterCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling deleteClusterCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteClusterCustomObject.');
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = models_1.ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = models_1.ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = models_1.ObjectSerializer.serialize(propagationPolicy, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * Delete collection of cluster scoped custom objects
     * @param group The custom resource\&#39;s group name
     * @param version The custom resource\&#39;s version
     * @param plural The custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param pretty If \&#39;true\&#39;, then the output is pretty printed.
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object\&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param body
     */
    async deleteCollectionClusterCustomObject(group, version, plural, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling deleteCollectionClusterCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling deleteCollectionClusterCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling deleteCollectionClusterCustomObject.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = models_1.ObjectSerializer.serialize(pretty, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = models_1.ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = models_1.ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = models_1.ObjectSerializer.serialize(propagationPolicy, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * Delete collection of namespace scoped custom objects
     * @param group The custom resource\&#39;s group name
     * @param version The custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural The custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param pretty If \&#39;true\&#39;, then the output is pretty printed.
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object\&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param body
     */
    async deleteCollectionNamespacedCustomObject(group, version, namespace, plural, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling deleteCollectionNamespacedCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling deleteCollectionNamespacedCustomObject.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteCollectionNamespacedCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling deleteCollectionNamespacedCustomObject.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = models_1.ObjectSerializer.serialize(pretty, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = models_1.ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = models_1.ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = models_1.ObjectSerializer.serialize(propagationPolicy, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * Deletes the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object\&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param body
     */
    async deleteNamespacedCustomObject(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling deleteNamespacedCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling deleteNamespacedCustomObject.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteNamespacedCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling deleteNamespacedCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteNamespacedCustomObject.');
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = models_1.ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = models_1.ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = models_1.ObjectSerializer.serialize(propagationPolicy, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * Returns a cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom object\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     */
    async getClusterCustomObject(group, version, plural, name, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling getClusterCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling getClusterCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling getClusterCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling getClusterCustomObject.');
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * read scale of the specified custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     */
    async getClusterCustomObjectScale(group, version, plural, name, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}/scale'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling getClusterCustomObjectScale.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling getClusterCustomObjectScale.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling getClusterCustomObjectScale.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling getClusterCustomObjectScale.');
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * read status of the specified cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     */
    async getClusterCustomObjectStatus(group, version, plural, name, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}/status'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling getClusterCustomObjectStatus.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling getClusterCustomObjectStatus.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling getClusterCustomObjectStatus.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling getClusterCustomObjectStatus.');
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * Returns a namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     */
    async getNamespacedCustomObject(group, version, namespace, plural, name, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling getNamespacedCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling getNamespacedCustomObject.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling getNamespacedCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling getNamespacedCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling getNamespacedCustomObject.');
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * read scale of the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     */
    async getNamespacedCustomObjectScale(group, version, namespace, plural, name, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling getNamespacedCustomObjectScale.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling getNamespacedCustomObjectScale.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling getNamespacedCustomObjectScale.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling getNamespacedCustomObjectScale.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling getNamespacedCustomObjectScale.');
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * read status of the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     */
    async getNamespacedCustomObjectStatus(group, version, namespace, plural, name, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling getNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling getNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling getNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling getNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling getNamespacedCustomObjectStatus.');
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * list or watch cluster scoped custom objects
     * @param group The custom resource\&#39;s group name
     * @param version The custom resource\&#39;s version
     * @param plural The custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param pretty If \&#39;true\&#39;, then the output is pretty printed.
     * @param allowWatchBookmarks allowWatchBookmarks requests watch events with type \&quot;BOOKMARK\&quot;. Servers that do not implement bookmarks may ignore this flag and bookmarks are sent at the server\&#39;s discretion. Clients should not assume bookmarks are returned at any specific interval, nor may they assume the server will send any BOOKMARK event during a session. If this is not a watch, this field is ignored. If the feature gate WatchBookmarks is not enabled in apiserver, this field is ignored.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it\&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param resourceVersionMatch resourceVersionMatch determines how resourceVersion is applied to list calls. It is highly recommended that resourceVersionMatch be set for list calls where resourceVersion is set See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for details.  Defaults to unset
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
     */
    async listClusterCustomObject(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/json;stream=watch'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling listClusterCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling listClusterCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling listClusterCustomObject.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = models_1.ObjectSerializer.serialize(pretty, "string");
        }
        if (allowWatchBookmarks !== undefined) {
            localVarQueryParameters['allowWatchBookmarks'] = models_1.ObjectSerializer.serialize(allowWatchBookmarks, "boolean");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = models_1.ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = models_1.ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = models_1.ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = models_1.ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = models_1.ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (resourceVersionMatch !== undefined) {
            localVarQueryParameters['resourceVersionMatch'] = models_1.ObjectSerializer.serialize(resourceVersionMatch, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = models_1.ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = models_1.ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * list or watch namespace scoped custom objects
     * @param group The custom resource\&#39;s group name
     * @param version The custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural The custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param pretty If \&#39;true\&#39;, then the output is pretty printed.
     * @param allowWatchBookmarks allowWatchBookmarks requests watch events with type \&quot;BOOKMARK\&quot;. Servers that do not implement bookmarks may ignore this flag and bookmarks are sent at the server\&#39;s discretion. Clients should not assume bookmarks are returned at any specific interval, nor may they assume the server will send any BOOKMARK event during a session. If this is not a watch, this field is ignored. If the feature gate WatchBookmarks is not enabled in apiserver, this field is ignored.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it\&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param resourceVersionMatch resourceVersionMatch determines how resourceVersion is applied to list calls. It is highly recommended that resourceVersionMatch be set for list calls where resourceVersion is set See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for details.  Defaults to unset
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
     */
    async listNamespacedCustomObject(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/json;stream=watch'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling listNamespacedCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling listNamespacedCustomObject.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling listNamespacedCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling listNamespacedCustomObject.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = models_1.ObjectSerializer.serialize(pretty, "string");
        }
        if (allowWatchBookmarks !== undefined) {
            localVarQueryParameters['allowWatchBookmarks'] = models_1.ObjectSerializer.serialize(allowWatchBookmarks, "boolean");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = models_1.ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = models_1.ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = models_1.ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = models_1.ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = models_1.ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (resourceVersionMatch !== undefined) {
            localVarQueryParameters['resourceVersionMatch'] = models_1.ObjectSerializer.serialize(resourceVersionMatch, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = models_1.ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = models_1.ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * patch the specified cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom object\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body The JSON schema of the Resource to patch.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).
     * @param force Force is going to \&quot;force\&quot; Apply requests. It means user will re-acquire conflicting fields owned by other people. Force flag must be unset for non-apply patch requests.
     */
    async patchClusterCustomObject(group, version, plural, name, body, dryRun, fieldManager, force, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling patchClusterCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling patchClusterCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling patchClusterCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchClusterCustomObject.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchClusterCustomObject.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        if (force !== undefined) {
            localVarQueryParameters['force'] = models_1.ObjectSerializer.serialize(force, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * partially update scale of the specified cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).
     * @param force Force is going to \&quot;force\&quot; Apply requests. It means user will re-acquire conflicting fields owned by other people. Force flag must be unset for non-apply patch requests.
     */
    async patchClusterCustomObjectScale(group, version, plural, name, body, dryRun, fieldManager, force, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}/scale'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling patchClusterCustomObjectScale.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling patchClusterCustomObjectScale.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling patchClusterCustomObjectScale.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchClusterCustomObjectScale.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchClusterCustomObjectScale.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        if (force !== undefined) {
            localVarQueryParameters['force'] = models_1.ObjectSerializer.serialize(force, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * partially update status of the specified cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).
     * @param force Force is going to \&quot;force\&quot; Apply requests. It means user will re-acquire conflicting fields owned by other people. Force flag must be unset for non-apply patch requests.
     */
    async patchClusterCustomObjectStatus(group, version, plural, name, body, dryRun, fieldManager, force, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}/status'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling patchClusterCustomObjectStatus.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling patchClusterCustomObjectStatus.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling patchClusterCustomObjectStatus.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchClusterCustomObjectStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchClusterCustomObjectStatus.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        if (force !== undefined) {
            localVarQueryParameters['force'] = models_1.ObjectSerializer.serialize(force, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * patch the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body The JSON schema of the Resource to patch.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).
     * @param force Force is going to \&quot;force\&quot; Apply requests. It means user will re-acquire conflicting fields owned by other people. Force flag must be unset for non-apply patch requests.
     */
    async patchNamespacedCustomObject(group, version, namespace, plural, name, body, dryRun, fieldManager, force, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling patchNamespacedCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling patchNamespacedCustomObject.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling patchNamespacedCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedCustomObject.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedCustomObject.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        if (force !== undefined) {
            localVarQueryParameters['force'] = models_1.ObjectSerializer.serialize(force, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * partially update scale of the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).
     * @param force Force is going to \&quot;force\&quot; Apply requests. It means user will re-acquire conflicting fields owned by other people. Force flag must be unset for non-apply patch requests.
     */
    async patchNamespacedCustomObjectScale(group, version, namespace, plural, name, body, dryRun, fieldManager, force, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling patchNamespacedCustomObjectScale.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling patchNamespacedCustomObjectScale.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedCustomObjectScale.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling patchNamespacedCustomObjectScale.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedCustomObjectScale.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedCustomObjectScale.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        if (force !== undefined) {
            localVarQueryParameters['force'] = models_1.ObjectSerializer.serialize(force, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * partially update status of the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).
     * @param force Force is going to \&quot;force\&quot; Apply requests. It means user will re-acquire conflicting fields owned by other people. Force flag must be unset for non-apply patch requests.
     */
    async patchNamespacedCustomObjectStatus(group, version, namespace, plural, name, body, dryRun, fieldManager, force, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling patchNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling patchNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling patchNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedCustomObjectStatus.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        if (force !== undefined) {
            localVarQueryParameters['force'] = models_1.ObjectSerializer.serialize(force, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * replace the specified cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom object\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body The JSON schema of the Resource to replace.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.
     */
    async replaceClusterCustomObject(group, version, plural, name, body, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling replaceClusterCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling replaceClusterCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling replaceClusterCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceClusterCustomObject.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceClusterCustomObject.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * replace scale of the specified cluster scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.
     */
    async replaceClusterCustomObjectScale(group, version, plural, name, body, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}/scale'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling replaceClusterCustomObjectScale.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling replaceClusterCustomObjectScale.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling replaceClusterCustomObjectScale.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceClusterCustomObjectScale.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceClusterCustomObjectScale.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * replace status of the cluster scoped specified custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.
     */
    async replaceClusterCustomObjectStatus(group, version, plural, name, body, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/{plural}/{name}/status'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling replaceClusterCustomObjectStatus.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling replaceClusterCustomObjectStatus.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling replaceClusterCustomObjectStatus.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceClusterCustomObjectStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceClusterCustomObjectStatus.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * replace the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body The JSON schema of the Resource to replace.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.
     */
    async replaceNamespacedCustomObject(group, version, namespace, plural, name, body, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling replaceNamespacedCustomObject.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling replaceNamespacedCustomObject.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling replaceNamespacedCustomObject.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling replaceNamespacedCustomObject.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceNamespacedCustomObject.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceNamespacedCustomObject.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * replace scale of the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.
     */
    async replaceNamespacedCustomObjectScale(group, version, namespace, plural, name, body, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling replaceNamespacedCustomObjectScale.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling replaceNamespacedCustomObjectScale.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling replaceNamespacedCustomObjectScale.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling replaceNamespacedCustomObjectScale.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceNamespacedCustomObjectScale.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceNamespacedCustomObjectScale.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
    /**
     * replace status of the specified namespace scoped custom object
     * @param group the custom resource\&#39;s group
     * @param version the custom resource\&#39;s version
     * @param namespace The custom resource\&#39;s namespace
     * @param plural the custom resource\&#39;s plural name. For TPRs this would be lowercase plural kind.
     * @param name the custom object\&#39;s name
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param fieldManager fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.
     */
    async replaceNamespacedCustomObjectStatus(group, version, namespace, plural, name, body, dryRun, fieldManager, options = { headers: {} }) {
        const localVarPath = this.basePath + '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status'
            .replace('{' + 'group' + '}', encodeURIComponent(String(group)))
            .replace('{' + 'version' + '}', encodeURIComponent(String(version)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)))
            .replace('{' + 'plural' + '}', encodeURIComponent(String(plural)))
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this._defaultHeaders);
        const produces = ['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'];
        // give precedence to 'application/json'
        if (produces.indexOf('application/json') >= 0) {
            localVarHeaderParams.Accept = 'application/json';
        }
        else {
            localVarHeaderParams.Accept = produces.join(',');
        }
        let localVarFormParams = {};
        // verify required parameter 'group' is not null or undefined
        if (group === null || group === undefined) {
            throw new Error('Required parameter group was null or undefined when calling replaceNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'version' is not null or undefined
        if (version === null || version === undefined) {
            throw new Error('Required parameter version was null or undefined when calling replaceNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling replaceNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'plural' is not null or undefined
        if (plural === null || plural === undefined) {
            throw new Error('Required parameter plural was null or undefined when calling replaceNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceNamespacedCustomObjectStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceNamespacedCustomObjectStatus.');
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = models_1.ObjectSerializer.serialize(dryRun, "string");
        }
        if (fieldManager !== undefined) {
            localVarQueryParameters['fieldManager'] = models_1.ObjectSerializer.serialize(fieldManager, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: models_1.ObjectSerializer.serialize(body, "object")
        };
        let authenticationPromise = Promise.resolve();
        if (this.authentications.BearerToken.apiKey) {
            authenticationPromise = authenticationPromise.then(() => this.authentications.BearerToken.applyToRequest(localVarRequestOptions));
        }
        authenticationPromise = authenticationPromise.then(() => this.authentications.default.applyToRequest(localVarRequestOptions));
        let interceptorPromise = authenticationPromise;
        for (const interceptor of this.interceptors) {
            interceptorPromise = interceptorPromise.then(() => interceptor(localVarRequestOptions));
        }
        return interceptorPromise.then(() => {
            if (Object.keys(localVarFormParams).length) {
                if (localVarUseFormData) {
                    localVarRequestOptions.formData = localVarFormParams;
                }
                else {
                    localVarRequestOptions.form = localVarFormParams;
                }
            }
            return new Promise((resolve, reject) => {
                request_1.default(localVarRequestOptions, (error, response, body) => {
                    if (error) {
                        reject(error);
                    }
                    else {
                        if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                            body = models_1.ObjectSerializer.deserialize(body, "object");
                            resolve({ response: response, body: body });
                        }
                        else {
                            reject(new apis_1.HttpError(response, body, response.statusCode));
                        }
                    }
                });
            });
        });
    }
}
exports.CustomObjectsApi = CustomObjectsApi;
//# sourceMappingURL=customObjectsApi.js.map