/*
 * JBoss, Home of Professional Open Source
 * Copyright 2015, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.as.quickstarts.wsat.simple.jaxws;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

/**
 * This class was generated by the JAX-WS RI. JAX-WS RI 2.1.6 in JDK 6 Generated source version: 2.1
 *
 */
@WebServiceClient(name = "RestaurantServiceATService", targetNamespace = "http://www.jboss.org/jboss-jdf/jboss-as-quickstart/wsat/simple/Restaurant")
public class RestaurantServiceATService extends Service {

    private static final URL RESTAURANTSERVICEATSERVICE_WSDL_LOCATION;
    private static final Logger logger = Logger.getLogger(RestaurantServiceATService.class.getName());

    static {
        URL url = null;
        try {
            URL baseUrl;
            baseUrl = RestaurantServiceATService.class.getResource(".");
            url = new URL(baseUrl, "RestaurantServiceAT.wsdl");
        } catch (MalformedURLException e) {
            logger.warning("Failed to create URL for the wsdl Location: 'RestaurantServiceAT.wsdl', retrying as a local file");
            logger.warning(e.getMessage());
        }
        RESTAURANTSERVICEATSERVICE_WSDL_LOCATION = url;
    }

    public RestaurantServiceATService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public RestaurantServiceATService(URL wsdlLocation, QName serviceName, WebServiceFeature... features) {
        super(wsdlLocation, serviceName, features);
    }

    public RestaurantServiceATService() {
        super(RESTAURANTSERVICEATSERVICE_WSDL_LOCATION, new QName(
            "http://www.jboss.org/jboss-jdf/jboss-as-quickstart/wsat/simple/Restaurant", "RestaurantServiceATService"));
    }

    /**
     *
     * @return returns RestaurantServiceAT
     */
    @WebEndpoint(name = "RestaurantServiceAT")
    public RestaurantServiceAT getRestaurantServiceAT() {
        return super.getPort(new QName("http://www.jboss.org/jboss-jdf/jboss-as-quickstart/wsat/simple/Restaurant",
            "RestaurantServiceAT"), RestaurantServiceAT.class);
    }

    /**
     *
     * @param features A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy. Supported features not in the
     *        <code>features</code> parameter will have their default values.
     * @return returns RestaurantServiceAT
     */
    @WebEndpoint(name = "RestaurantServiceAT")
    public RestaurantServiceAT getRestaurantServiceAT(WebServiceFeature... features) {
        return super.getPort(new QName("http://www.jboss.org/jboss-jdf/jboss-as-quickstart/wsat/simple/Restaurant",
            "RestaurantServiceAT"), RestaurantServiceAT.class, features);
    }

}
