/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.Arrays;
import java.util.regex.Matcher;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.referencetype.ListedReferenceTypes;
import org.spdx.tag.BuildDocument;
import org.spdx.tag.InvalidSpdxTagFileException;

public class CompareHelper {
    static final int MAX_CHARACTERS_PER_CELL = 32000;

    private CompareHelper() {
    }

    public static String annotationToString(Annotation annotation) {
        if (annotation == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(annotation.getAnnotationDate());
        sb.append(" ");
        sb.append(annotation.getAnnotator());
        sb.append(": ");
        sb.append(annotation.getComment());
        sb.append("[");
        sb.append(annotation.getAnnotationType().getTag());
        sb.append("]");
        return sb.toString();
    }

    public static String checksumsToString(Checksum[] checksums) {
        if (checksums == null || checksums.length == 0) {
            return "";
        }
        Arrays.sort(checksums);
        StringBuilder sb = new StringBuilder(CompareHelper.checksumToString(checksums[0]));
        int i = 1;
        while (i < checksums.length) {
            sb.append("\n");
            String checksum = CompareHelper.checksumToString(checksums[i]);
            if (sb.length() + checksum.length() > 32000) {
                int numRemaing = checksums.length - i;
                sb.append('[');
                sb.append(numRemaing);
                sb.append(" more...]");
                break;
            }
            sb.append(checksum);
            ++i;
        }
        return sb.toString();
    }

    public static String checksumToString(Checksum checksum) {
        if (checksum == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder((String)Checksum.CHECKSUM_ALGORITHM_TO_TAG.get((Object)checksum.getAlgorithm()));
        sb.append(' ');
        sb.append(checksum.getValue());
        return sb.toString();
    }

    public static String licenseInfosToString(AnyLicenseInfo[] licenseInfoFromFiles) {
        if (licenseInfoFromFiles == null || licenseInfoFromFiles.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(licenseInfoFromFiles[0].toString());
        int i = 1;
        while (i < licenseInfoFromFiles.length) {
            sb.append(", ");
            sb.append(licenseInfoFromFiles[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public static String annotationsToString(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(CompareHelper.annotationToString(annotations[0]));
        int i = 1;
        while (i < annotations.length) {
            sb.append("\n");
            String annotation = CompareHelper.annotationToString(annotations[i]);
            if (sb.length() + annotation.length() > 32000) {
                int numRemaing = annotations.length - i;
                sb.append('[');
                sb.append(numRemaing);
                sb.append(" more...]");
                break;
            }
            sb.append(annotation);
            ++i;
        }
        return sb.toString();
    }

    public static String attributionsToString(String[] attributionText) {
        if (attributionText == null || attributionText.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(attributionText[0]);
        int i = 1;
        while (i < attributionText.length) {
            sb.append("\n");
            sb.append(attributionText[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String relationshipToString(Relationship relationship) {
        if (relationship == null) {
            return "";
        }
        if (relationship.getRelationshipType() == null) {
            return "Unknown relationship type";
        }
        StringBuilder sb = new StringBuilder(relationship.getRelationshipType().toTag());
        sb.append(":");
        if (relationship.getRelatedSpdxElement() == null) {
            sb.append("?NULL");
        } else {
            if (relationship.getRelatedSpdxElement().getName() != null) {
                sb.append('[');
                sb.append(relationship.getRelatedSpdxElement().getName());
                sb.append(']');
            }
            sb.append(relationship.getRelatedSpdxElement().getId());
        }
        if (relationship.getComment() != null && !relationship.getComment().isEmpty()) {
            sb.append('(');
            sb.append(relationship.getComment());
            sb.append(')');
        }
        return sb.toString();
    }

    public static String relationshipsToString(Relationship[] relationships) {
        if (relationships == null || relationships.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(CompareHelper.relationshipToString(relationships[0]));
        int i = 1;
        while (i < relationships.length) {
            sb.append("\n");
            String nextRelationship = CompareHelper.relationshipToString(relationships[i]);
            if (sb.length() + nextRelationship.length() > 32000) {
                int numRemaing = relationships.length - i;
                sb.append('[');
                sb.append(numRemaing);
                sb.append(" more...]");
                break;
            }
            sb.append(nextRelationship);
            ++i;
        }
        return sb.toString();
    }

    public static String formatSpdxElementList(SpdxElement[] elements) {
        StringBuilder sb;
        if (elements == null || elements.length == 0) {
            return "";
        }
        if (elements[0] == null || elements[0].getId() == null || elements[0].getId().isEmpty()) {
            sb = new StringBuilder("[UNKNOWNID]");
        } else {
            sb = new StringBuilder(elements[0].getId());
            if (elements[0].getName() != null) {
                sb.append('(');
                sb.append(elements[0].getName());
                sb.append(')');
            }
        }
        int i = 1;
        while (i < elements.length) {
            sb.append(", ");
            if (elements[i] == null || elements[i].getId() == null || elements[i].getId().isEmpty()) {
                sb.append("[UNKNOWNID]");
            } else {
                sb.append(elements[i].getId());
                if (elements[0].getName() != null) {
                    sb.append('(');
                    sb.append(elements[0].getName());
                    sb.append(')');
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String fileTypesToString(SpdxFile.FileType[] fileTypes) {
        if (fileTypes == null || fileTypes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(fileTypes[0].getTag());
        int i = 1;
        while (i < fileTypes.length) {
            sb.append(", ");
            String fileType = fileTypes[i].getTag();
            if (sb.length() + fileType.length() > 32000) {
                int numRemaing = fileTypes.length - i;
                sb.append('[');
                sb.append(numRemaing);
                sb.append(" more...]");
                break;
            }
            sb.append(fileType);
            ++i;
        }
        return sb.toString();
    }

    public static SpdxFile.FileType[] parseFileTypeString(String typeStr) throws InvalidSPDXAnalysisException {
        if (typeStr == null || typeStr.trim().isEmpty()) {
            return new SpdxFile.FileType[0];
        }
        String[] fileTypeStrs = typeStr.split(",");
        SpdxFile.FileType[] retval = new SpdxFile.FileType[fileTypeStrs.length];
        int i = 0;
        while (i < fileTypeStrs.length) {
            fileTypeStrs[i] = fileTypeStrs[i].trim();
            if (fileTypeStrs[i].endsWith(",")) {
                fileTypeStrs[i] = fileTypeStrs[i].substring(0, fileTypeStrs[i].length() - 1);
                fileTypeStrs[i] = fileTypeStrs[i].trim();
            }
            retval[i] = SpdxFile.FileType.fromTag(fileTypeStrs[i]);
            if (retval[i] == null) {
                throw new InvalidSPDXAnalysisException("Unrecognized file type " + fileTypeStrs[i]);
            }
            ++i;
        }
        return retval;
    }

    public static Checksum[] strToChecksums(String checksumsString) throws InvalidSPDXAnalysisException {
        if (checksumsString == null || checksumsString.trim().isEmpty()) {
            return new Checksum[0];
        }
        String[] parts = checksumsString.split("\n");
        Checksum[] retval = new Checksum[parts.length];
        int i = 0;
        while (i < parts.length) {
            try {
                retval[i] = CompareHelper.parseChecksum(parts[i].trim());
            }
            catch (InvalidSpdxTagFileException e) {
                throw new InvalidSPDXAnalysisException("Invalid checksum string: " + parts[i]);
            }
            ++i;
        }
        return retval;
    }

    public static Checksum parseChecksum(String value) throws InvalidSpdxTagFileException {
        Matcher matcher = BuildDocument.CHECKSUM_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid checksum: " + value);
        }
        Checksum.ChecksumAlgorithm algorithm = (Checksum.ChecksumAlgorithm)((Object)Checksum.CHECKSUM_TAG_TO_ALGORITHM.get((Object)matcher.group(1)));
        if (algorithm == null) {
            throw new InvalidSpdxTagFileException("Invalid checksum algorithm: " + value);
        }
        return new Checksum(algorithm, matcher.group(2));
    }

    public static String externalRefsToString(ExternalRef[] externalRefs, String docNamespace) throws InvalidSPDXAnalysisException {
        if (externalRefs == null || externalRefs.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(CompareHelper.externalRefToString(externalRefs[0], docNamespace));
        int i = 1;
        while (i < externalRefs.length) {
            sb.append("; ");
            sb.append(CompareHelper.externalRefToString(externalRefs[i], docNamespace));
            ++i;
        }
        return sb.toString();
    }

    public static String externalRefToString(ExternalRef externalRef, String docNamespace) throws InvalidSPDXAnalysisException {
        String category = null;
        category = externalRef.getReferenceCategory() == null ? "OTHER" : externalRef.getReferenceCategory().getTag();
        String referenceType = null;
        if (externalRef.getReferenceType() == null || externalRef.getReferenceType().getReferenceTypeUri() == null) {
            referenceType = "[MISSING]";
        } else {
            try {
                referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(externalRef.getReferenceType().getReferenceTypeUri());
            }
            catch (InvalidSPDXAnalysisException e) {
                referenceType = null;
            }
            if (referenceType == null) {
                referenceType = externalRef.getReferenceType().getReferenceTypeUri().toString();
                if (docNamespace != null && !docNamespace.isEmpty() && referenceType.startsWith(docNamespace)) {
                    referenceType = referenceType.substring(docNamespace.length());
                }
            }
        }
        String referenceLocator = externalRef.getReferenceLocator();
        if (referenceLocator == null) {
            referenceLocator = "[MISSING]";
        }
        String retval = String.valueOf(category) + " " + referenceType + " " + referenceLocator;
        if (externalRef.getComment() != null && !externalRef.getComment().isEmpty()) {
            retval = String.valueOf(retval) + "(" + externalRef.getComment() + ")";
        }
        return retval;
    }
}

