/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.SpdxFile;

public class FileArtifactOfSheet
extends AbstractFileCompareSheet {
    private static final int FILE_ARTIFACTOF_COL_WIDTH = 60;

    public FileArtifactOfSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        DoapProject[] projects = spdxFile.getArtifactOf();
        if (projects == null || projects.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < projects.length) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(projects[i].getName());
            if (projects[i].getHomePage() != null && !projects[i].getHomePage().isEmpty()) {
                sb.append("(");
                sb.append(projects[i].getHomePage());
                sb.append(")");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        DoapProject[] projectsA = fileA.getArtifactOf();
        DoapProject[] projectsB = fileB.getArtifactOf();
        if (projectsA == null) {
            return projectsB == null || projectsB.length == 0;
        }
        if (projectsB == null) {
            return projectsA.length == 0;
        }
        if (projectsA.length != projectsB.length) {
            return false;
        }
        int i = 0;
        while (i < projectsA.length) {
            boolean found = false;
            int j = 0;
            while (j < projectsB.length) {
                if (SpdxComparer.stringsEqual(projectsA[i].getName(), projectsB[j].getName()) && SpdxComparer.stringsEqual(projectsA[i].getHomePage(), projectsB[j].getHomePage()) && SpdxComparer.stringsEqual(projectsA[i].getProjectUri(), projectsB[j].getProjectUri())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

