/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.Arrays;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxFileComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileDependenciesSheet
extends AbstractFileCompareSheet {
    private static final int FILE_DEPENDENCIES_COL_WIDTH = 60;

    public FileDependenciesSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        String[] dependencyFileNamesA = SpdxFileComparer.filesToFileNames(fileA.getFileDependencies());
        String[] dependencyFileNamesB = SpdxFileComparer.filesToFileNames(fileB.getFileDependencies());
        return SpdxComparer.stringArraysEqual(dependencyFileNamesA, dependencyFileNamesB);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        Object[] dependencyFileNames = SpdxFileComparer.filesToFileNames(spdxFile.getFileDependencies());
        StringBuilder sb = new StringBuilder();
        if (dependencyFileNames != null && dependencyFileNames.length > 0) {
            Arrays.sort(dependencyFileNames);
            sb.append((String)dependencyFileNames[0]);
            int i = 1;
            while (i < dependencyFileNames.length) {
                sb.append(", ");
                sb.append((String)dependencyFileNames[i]);
                ++i;
            }
        }
        return sb.toString();
    }
}

