/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxFileDifference;
import org.spdx.compare.SpdxItemComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;

public class SpdxFileComparer
extends SpdxItemComparer {
    private boolean inProgress = false;
    private boolean differenceFound = false;
    private boolean artifactOfEquals = true;
    private boolean fileDependenciesEquals = true;
    private boolean contributorsEquals = true;
    private boolean noticeTextEquals = true;
    private Map<SpdxDocument, Map<SpdxDocument, DoapProject[]>> uniqueArtifactOfs = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, Checksum[]>> uniqueChecksums = Maps.newHashMap();
    private Comparator<DoapProject> doapComparer = new DoapComparator();
    private boolean checksumsEquals = true;
    private boolean typesEquals = true;

    public SpdxFileComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        super(extractedLicenseIdMap);
    }

    public void addDocumentFile(SpdxDocument spdxDocument, SpdxFile spdxFile) throws SpdxCompareException {
        this.checkInProgress();
        this.inProgress = true;
        Iterator iter = this.documentItem.entrySet().iterator();
        SpdxFile filesB = null;
        while (iter.hasNext() && filesB == null) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof SpdxFile)) continue;
            filesB = (SpdxFile)entry.getValue();
        }
        if (filesB != null) {
            this.compareNewArtifactOf(spdxDocument, spdxFile.getArtifactOf());
            this.compareNewFileChecksums(spdxDocument, spdxFile.getChecksums());
            if (!SpdxComparer.arraysEqual((Object[])spdxFile.getFileTypes(), (Object[])filesB.getFileTypes())) {
                this.typesEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringArraysEqual(spdxFile.getFileContributors(), filesB.getFileContributors())) {
                this.contributorsEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxFile.getNoticeText(), filesB.getNoticeText())) {
                this.noticeTextEquals = false;
                this.differenceFound = true;
            }
            if (!this.fileNamesEquals(spdxFile.getFileDependencies(), filesB.getFileDependencies())) {
                this.fileDependenciesEquals = false;
                this.differenceFound = true;
            }
        }
        super.addDocumentItem(spdxDocument, spdxFile);
        this.inProgress = false;
    }

    private void compareNewFileChecksums(SpdxDocument spdxDocument, Checksum[] checksums) throws SpdxCompareException {
        HashMap docUniqueChecksums = Maps.newHashMap();
        this.uniqueChecksums.put(spdxDocument, docUniqueChecksums);
        for (Map.Entry entry : this.documentItem.entrySet()) {
            if (!(entry.getValue() instanceof SpdxFile)) continue;
            Checksum[] compareChecksums = ((SpdxFile)entry.getValue()).getChecksums();
            Checksum[] uniqueChecksums = SpdxComparer.findUniqueChecksums(checksums, compareChecksums);
            if (uniqueChecksums.length > 0) {
                this.checksumsEquals = false;
                this.differenceFound = true;
            }
            docUniqueChecksums.put((SpdxDocument)entry.getKey(), uniqueChecksums);
            HashMap compareUniqueChecksums = this.uniqueChecksums.get(entry.getKey());
            if (compareUniqueChecksums == null) {
                compareUniqueChecksums = Maps.newHashMap();
                this.uniqueChecksums.put((SpdxDocument)entry.getKey(), compareUniqueChecksums);
            }
            if ((uniqueChecksums = SpdxComparer.findUniqueChecksums(compareChecksums, checksums)).length > 0) {
                this.checksumsEquals = false;
                this.differenceFound = true;
            }
            compareUniqueChecksums.put(spdxDocument, uniqueChecksums);
        }
    }

    private boolean fileNamesEquals(SpdxFile[] filesA, SpdxFile[] filesB) {
        String[] fileNamesA = SpdxFileComparer.filesToFileNames(filesA);
        String[] fileNamesB = SpdxFileComparer.filesToFileNames(filesB);
        return SpdxComparer.stringArraysEqual(fileNamesA, fileNamesB);
    }

    public static String[] filesToFileNames(SpdxFile[] files) {
        if (files == null) {
            return null;
        }
        String[] retval = new String[files.length];
        int i = 0;
        while (i < files.length) {
            retval[i] = files[i].getName();
            ++i;
        }
        return retval;
    }

    public SpdxFile getFile(SpdxDocument spdxDocument) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        SpdxItem item = this.getItem(spdxDocument);
        if (item instanceof SpdxFile) {
            return (SpdxFile)item;
        }
        return null;
    }

    public boolean isArtifactOfEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.artifactOfEquals;
    }

    public DoapProject[] getUniqueArtifactOf(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        Map<SpdxDocument, DoapProject[]> unique = this.uniqueArtifactOfs.get(docA);
        if (unique == null) {
            return new DoapProject[0];
        }
        DoapProject[] retval = unique.get(docB);
        if (retval == null) {
            return new DoapProject[0];
        }
        return retval;
    }

    public boolean isChecksumsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.checksumsEquals;
    }

    public Checksum[] getUniqueChecksums(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, Checksum[]> uniqueMap = this.uniqueChecksums.get(docA);
        if (uniqueMap == null) {
            return new Checksum[0];
        }
        Checksum[] retval = uniqueMap.get(docB);
        if (retval == null) {
            return new Checksum[0];
        }
        return retval;
    }

    public boolean isTypesEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.typesEquals;
    }

    private void compareNewArtifactOf(SpdxDocument spdxDocument, DoapProject[] artifactOfs) {
        HashMap uniqueDocArtifactOf = this.uniqueArtifactOfs.get(spdxDocument);
        if (uniqueDocArtifactOf == null) {
            uniqueDocArtifactOf = Maps.newHashMap();
            this.uniqueArtifactOfs.put(spdxDocument, uniqueDocArtifactOf);
        }
        for (Map.Entry entry : this.documentItem.entrySet()) {
            if (!(entry.getValue() instanceof SpdxFile)) continue;
            DoapProject[] compareArtifactOf = ((SpdxFile)entry.getValue()).getArtifactOf();
            HashMap uniqueCompareArtifactOf = this.uniqueArtifactOfs.get(entry.getKey());
            if (uniqueCompareArtifactOf == null) {
                uniqueCompareArtifactOf = Maps.newHashMap();
                this.uniqueArtifactOfs.put((SpdxDocument)entry.getKey(), uniqueCompareArtifactOf);
            }
            ArrayList alDocUnique = Lists.newArrayList();
            ArrayList alCompareUnique = Lists.newArrayList();
            this.compareArtifactOf(artifactOfs, compareArtifactOf, alDocUnique, alCompareUnique);
            if (alDocUnique.size() > 0 || alCompareUnique.size() > 0) {
                this.differenceFound = true;
                this.artifactOfEquals = false;
            }
            uniqueDocArtifactOf.put((SpdxDocument)entry.getKey(), alDocUnique.toArray(new DoapProject[alDocUnique.size()]));
            uniqueCompareArtifactOf.put(spdxDocument, alCompareUnique.toArray(new DoapProject[alCompareUnique.size()]));
        }
    }

    private void compareArtifactOf(DoapProject[] artifactOfA, DoapProject[] artifactOfB, List<DoapProject> alUniqueA, List<DoapProject> alUniqueB) {
        Arrays.sort(artifactOfA, this.doapComparer);
        Arrays.sort(artifactOfB, this.doapComparer);
        int aIndex = 0;
        int bIndex = 0;
        while (aIndex < artifactOfA.length || bIndex < artifactOfB.length) {
            if (aIndex >= artifactOfA.length) {
                alUniqueB.add(artifactOfB[bIndex]);
                ++bIndex;
                continue;
            }
            if (bIndex >= artifactOfB.length) {
                alUniqueA.add(artifactOfA[aIndex]);
                ++aIndex;
                continue;
            }
            int compare = this.doapComparer.compare(artifactOfA[aIndex], artifactOfB[bIndex]);
            if (compare == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compare > 0) {
                alUniqueB.add(artifactOfB[bIndex]);
                ++bIndex;
                continue;
            }
            alUniqueA.add(artifactOfA[aIndex]);
            ++aIndex;
        }
    }

    @Override
    protected void checkInProgress() throws SpdxCompareException {
        super.checkInProgress();
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
    }

    private void checkCompareMade() throws SpdxCompareException {
        if (this.documentItem.size() < 1) {
            throw new SpdxCompareException("Trying to obgain results of a file compare before a file compare has been performed");
        }
    }

    public boolean isFileDependenciesEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.fileDependenciesEquals;
    }

    public boolean isContributorsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.contributorsEquals;
    }

    public boolean isNoticeTextEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.noticeTextEquals;
    }

    @Override
    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.differenceFound || super.isDifferenceFound();
    }

    public SpdxFileDifference getFileDifference(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        try {
            SpdxItem itemA = (SpdxItem)this.documentItem.get(docA);
            if (itemA == null || !(itemA instanceof SpdxFile)) {
                throw new SpdxCompareException("No SPDX File associated with " + docA.getName());
            }
            SpdxFile fileA = (SpdxFile)itemA;
            SpdxItem itemB = (SpdxItem)this.documentItem.get(docB);
            if (itemB == null || !(itemB instanceof SpdxFile)) {
                throw new SpdxCompareException("No SPDX File associated with " + docB.getName());
            }
            SpdxFile fileB = (SpdxFile)itemB;
            AnyLicenseInfo[] uniqueLicenseInfoInFilesA = this.getUniqueSeenLicenses(docA, docB);
            AnyLicenseInfo[] uniqueLicenseInfoInFilesB = this.getUniqueSeenLicenses(docB, docA);
            boolean licenseInfoInFilesEquals = uniqueLicenseInfoInFilesA.length == 0 && uniqueLicenseInfoInFilesB.length == 0;
            DoapProject[] uniqueArtifactOfA = this.getUniqueArtifactOf(docA, docB);
            DoapProject[] uniqueArtifactOfB = this.getUniqueArtifactOf(docB, docA);
            boolean artifactOfEquals = uniqueArtifactOfA.length == 0 && uniqueArtifactOfB.length == 0;
            Checksum[] uniqueChecksumsA = this.getUniqueChecksums(docA, docB);
            Checksum[] uniqueChecksumsB = this.getUniqueChecksums(docB, docA);
            boolean checksumsEquals = uniqueChecksumsA.length == 0 && uniqueChecksumsB.length == 0;
            Relationship[] uniqueRelationshipA = this.getUniqueRelationship(docA, docB);
            Relationship[] uniqueRelationshipB = this.getUniqueRelationship(docB, docA);
            boolean relationshipsEquals = uniqueRelationshipA.length == 0 && uniqueRelationshipB.length == 0;
            Annotation[] uniqueAnnotationsA = this.getUniqueAnnotations(docA, docB);
            Annotation[] uniqueAnnotationsB = this.getUniqueAnnotations(docB, docA);
            boolean annotationsEquals = uniqueAnnotationsA.length == 0 && uniqueAnnotationsB.length == 0;
            return new SpdxFileDifference(fileA, fileB, fileA.getLicenseConcluded().equals(fileB.getLicenseConcluded()), licenseInfoInFilesEquals, uniqueLicenseInfoInFilesA, uniqueLicenseInfoInFilesB, artifactOfEquals, uniqueArtifactOfA, uniqueArtifactOfB, checksumsEquals, uniqueChecksumsA, uniqueChecksumsB, relationshipsEquals, uniqueRelationshipB, uniqueRelationshipB, annotationsEquals, uniqueAnnotationsA, uniqueAnnotationsB);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("Error reading SPDX file propoerties: " + e.getMessage(), e);
        }
    }

    private static class DoapComparator
    implements Comparator<DoapProject>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DoapComparator() {
        }

        @Override
        public int compare(DoapProject arg0, DoapProject arg1) {
            int retval = SpdxComparer.compareStrings(arg0.getName(), arg1.getName());
            if (retval == 0) {
                retval = SpdxComparer.compareStrings(arg0.getHomePage(), arg1.getHomePage());
            }
            if (retval == 0) {
                retval = SpdxComparer.compareStrings(arg0.getProjectUri(), arg1.getProjectUri());
            }
            return retval;
        }
    }
}

