/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxExternalRefDifference;
import org.spdx.compare.SpdxFileDifference;
import org.spdx.compare.SpdxItemComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;

public class SpdxPackageComparer
extends SpdxItemComparer {
    private boolean inProgress = false;
    private boolean differenceFound = false;
    private boolean packageVersionsEquals = true;
    private boolean packageFilenamesEquals = true;
    private boolean packageSuppliersEquals = true;
    private boolean packageDownloadLocationsEquals = true;
    private boolean packageVerificationCodesEquals = true;
    private boolean packageChecksumsEquals = true;
    private boolean packageSourceInfosEquals = true;
    private boolean declaredLicensesEquals = true;
    private boolean packageSummaryEquals = true;
    private boolean packageDescriptionsEquals = true;
    private boolean packageOriginatorsEqual = true;
    private boolean packageHomePagesEquals = true;
    private boolean packageFilesEquals = true;
    private boolean filesAnalyzedEquals = true;
    private boolean externalRefsEquals = true;
    private Map<SpdxDocument, Map<SpdxDocument, Checksum[]>> uniqueChecksums = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxFile[]>> uniqueFiles = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxFileDifference[]>> fileDifferences = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, ExternalRef[]>> uniqueExternalRefs = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxExternalRefDifference[]>> externalRefDifferences = Maps.newHashMap();
    private Comparator<? super ExternalRef> externalRefTypeNameComparator = new Comparator<ExternalRef>(){

        @Override
        public int compare(ExternalRef arg0, ExternalRef arg1) {
            block10: {
                if (arg0 == null) {
                    if (arg1 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                if (arg0.getReferenceType() != null) break block10;
                if (arg1.getReferenceType() != null) {
                    return -1;
                }
            }
            try {
                int retval = arg0.getReferenceType().compareTo(arg1.getReferenceType());
                if (retval != 0) {
                    return retval;
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
            if (arg0.getReferenceLocator() == null) {
                if (arg1.getReferenceLocator() == null) {
                    return 0;
                }
                return -1;
            }
            return arg0.getReferenceLocator().compareTo(arg1.getReferenceLocator());
        }
    };

    public SpdxPackageComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        super(extractedLicenseIdMap);
    }

    public void addDocumentPackage(SpdxDocument spdxDocument, SpdxPackage spdxPackage) throws SpdxCompareException {
        this.checkInProgress();
        if (this.name == null) {
            this.name = spdxPackage.getName();
        } else if (!this.name.equals(spdxPackage.getName())) {
            throw new SpdxCompareException("Names do not match for item being added to comparer: " + spdxPackage.getName() + ", expecting " + this.name);
        }
        this.inProgress = true;
        Iterator iter = this.documentItem.entrySet().iterator();
        SpdxPackage pkg2 = null;
        Map licenseXlationMap = null;
        while (iter.hasNext() && pkg2 == null) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof SpdxPackage)) continue;
            pkg2 = (SpdxPackage)entry.getValue();
            licenseXlationMap = (Map)((Map)this.extractedLicenseIdMap.get(spdxDocument)).get(entry.getKey());
        }
        if (pkg2 != null) {
            if (!SpdxComparer.stringsEqual(spdxPackage.getVersionInfo(), pkg2.getVersionInfo())) {
                this.packageVersionsEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getPackageFileName(), pkg2.getPackageFileName())) {
                this.packageFilenamesEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getSupplier(), pkg2.getSupplier())) {
                this.packageSuppliersEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getOriginator(), pkg2.getOriginator())) {
                this.packageOriginatorsEqual = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getDownloadLocation(), pkg2.getDownloadLocation())) {
                this.packageDownloadLocationsEquals = false;
                this.differenceFound = true;
            }
            try {
                if (!SpdxComparer.compareVerificationCodes(spdxPackage.getPackageVerificationCode(), pkg2.getPackageVerificationCode())) {
                    this.packageVerificationCodesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package verification codes: " + e.getMessage(), e);
            }
            try {
                this.compareNewPackageChecksums(spdxDocument, spdxPackage.getChecksums());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package checksums: " + e.getMessage(), e);
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getSourceInfo(), pkg2.getSourceInfo())) {
                this.packageSourceInfosEquals = false;
                this.differenceFound = true;
            }
            try {
                if (!LicenseCompareHelper.isLicenseEqual(spdxPackage.getLicenseDeclared(), pkg2.getLicenseDeclared(), licenseXlationMap)) {
                    this.declaredLicensesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting declared license: " + e.getMessage(), e);
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getSummary(), pkg2.getSummary())) {
                this.packageSummaryEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getDescription(), pkg2.getDescription())) {
                this.packageDescriptionsEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getHomepage(), pkg2.getHomepage())) {
                this.packageHomePagesEquals = false;
                this.differenceFound = true;
            }
            try {
                if (spdxPackage.isFilesAnalyzed() != pkg2.isFilesAnalyzed()) {
                    this.filesAnalyzedEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting filesAnalyzed: " + e.getMessage(), e);
            }
            try {
                this.compareNewPackageFiles(spdxDocument, spdxPackage.getFiles());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package files: " + e.getMessage(), e);
            }
            try {
                this.compareNewPackageExternalRefs(spdxDocument, spdxPackage.getExternalRefs());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package external refs: " + e.getMessage(), e);
            }
        }
        this.inProgress = false;
        super.addDocumentItem(spdxDocument, spdxPackage);
    }

    private void compareNewPackageExternalRefs(SpdxDocument spdxDocument, ExternalRef[] externalRefs) throws InvalidSPDXAnalysisException {
        HashMap docExternalRefDiffs;
        Arrays.sort(externalRefs);
        HashMap docUniqueExternalRefs = this.uniqueExternalRefs.get(spdxDocument);
        if (docUniqueExternalRefs == null) {
            docUniqueExternalRefs = Maps.newHashMap();
            this.uniqueExternalRefs.put(spdxDocument, docUniqueExternalRefs);
        }
        if ((docExternalRefDiffs = this.externalRefDifferences.get(spdxDocument)) == null) {
            docExternalRefDiffs = Maps.newHashMap();
            this.externalRefDifferences.put(spdxDocument, docExternalRefDiffs);
        }
        for (Map.Entry entry : this.documentItem.entrySet()) {
            if (!(entry.getValue() instanceof SpdxPackage)) continue;
            Object[] compareExternalRefs = ((SpdxPackage)entry.getValue()).getExternalRefs();
            Arrays.sort(compareExternalRefs);
            SpdxExternalRefDifference[] externalRefDifferences = this.findExternalRefDifferences(spdxDocument, (SpdxDocument)entry.getKey(), externalRefs, (ExternalRef[])compareExternalRefs);
            if (externalRefDifferences.length > 0) {
                this.externalRefsEquals = false;
                this.differenceFound = true;
            }
            docExternalRefDiffs.put((SpdxDocument)entry.getKey(), externalRefDifferences);
            HashMap compareExternalRefDiffs = this.externalRefDifferences.get(entry.getKey());
            if (compareExternalRefDiffs == null) {
                compareExternalRefDiffs = Maps.newHashMap();
                this.externalRefDifferences.put((SpdxDocument)entry.getKey(), compareExternalRefDiffs);
            }
            compareExternalRefDiffs.put(spdxDocument, externalRefDifferences);
            ExternalRef[] uniqueRefs = this.findUniqueExternalRefs(externalRefs, (ExternalRef[])compareExternalRefs);
            if (uniqueRefs.length > 0) {
                this.externalRefsEquals = false;
                this.differenceFound = true;
            }
            this.uniqueExternalRefs.put((SpdxDocument)entry.getKey(), docUniqueExternalRefs);
            HashMap compareUniqueRefs = this.uniqueExternalRefs.get(entry.getKey());
            if (compareUniqueRefs == null) {
                compareUniqueRefs = Maps.newHashMap();
                this.uniqueExternalRefs.put((SpdxDocument)entry.getKey(), compareUniqueRefs);
            }
            if ((uniqueRefs = this.findUniqueExternalRefs((ExternalRef[])compareExternalRefs, externalRefs)).length > 0) {
                this.externalRefsEquals = false;
                this.differenceFound = true;
            }
            compareUniqueRefs.put(spdxDocument, uniqueRefs);
        }
    }

    private ExternalRef[] findUniqueExternalRefs(ExternalRef[] externalRefsA, ExternalRef[] externalRefsB) throws InvalidSPDXAnalysisException {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList alRetval = Lists.newArrayList();
        while (aIndex < externalRefsA.length) {
            if (bIndex >= externalRefsB.length) {
                alRetval.add(externalRefsA[aIndex]);
                ++aIndex;
                continue;
            }
            int compareVal = this.externalRefTypeNameComparator.compare(externalRefsA[aIndex], externalRefsB[bIndex]);
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(externalRefsA[aIndex]);
            ++aIndex;
        }
        ExternalRef[] retval = alRetval.toArray(new ExternalRef[alRetval.size()]);
        return retval;
    }

    private SpdxExternalRefDifference[] findExternalRefDifferences(SpdxDocument spdxDocument, SpdxDocument key, ExternalRef[] externalRefsA, ExternalRef[] externalRefsB) throws InvalidSPDXAnalysisException {
        ArrayList retval = Lists.newArrayList();
        int aIndex = 0;
        int bIndex = 0;
        Arrays.sort(externalRefsA, this.externalRefTypeNameComparator);
        Arrays.sort(externalRefsB, this.externalRefTypeNameComparator);
        while (aIndex < externalRefsA.length && bIndex < externalRefsB.length) {
            int compare = this.externalRefTypeNameComparator.compare(externalRefsA[aIndex], externalRefsB[bIndex]);
            if (compare == 0) {
                if (!Objects.equal((Object)externalRefsA[aIndex].getComment(), (Object)externalRefsB[bIndex].getComment()) || !Objects.equal((Object)((Object)externalRefsA[aIndex].getReferenceCategory()), (Object)((Object)externalRefsB[bIndex].getReferenceCategory()))) {
                    retval.add(new SpdxExternalRefDifference(externalRefsA[aIndex], externalRefsB[bIndex]));
                }
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compare > 0) {
                ++bIndex;
                continue;
            }
            ++aIndex;
        }
        return retval.toArray(new SpdxExternalRefDifference[retval.size()]);
    }

    private void compareNewPackageFiles(SpdxDocument spdxDocument, SpdxFile[] files) throws SpdxCompareException, InvalidSPDXAnalysisException {
        HashMap docDifferentFiles;
        Arrays.sort(files);
        HashMap docUniqueFiles = this.uniqueFiles.get(spdxDocument);
        if (docUniqueFiles == null) {
            docUniqueFiles = Maps.newHashMap();
            this.uniqueFiles.put(spdxDocument, docUniqueFiles);
        }
        if ((docDifferentFiles = this.fileDifferences.get(spdxDocument)) == null) {
            docDifferentFiles = Maps.newHashMap();
            this.fileDifferences.put(spdxDocument, docDifferentFiles);
        }
        for (Map.Entry entry : this.documentItem.entrySet()) {
            if (!(entry.getValue() instanceof SpdxPackage)) continue;
            Object[] compareFiles = ((SpdxPackage)entry.getValue()).getFiles();
            Arrays.sort(compareFiles);
            SpdxFileDifference[] fileDifferences = SpdxComparer.findFileDifferences(spdxDocument, (SpdxDocument)entry.getKey(), files, (SpdxFile[])compareFiles, this.extractedLicenseIdMap);
            if (fileDifferences.length > 0) {
                this.packageFilesEquals = false;
                this.differenceFound = true;
            }
            docDifferentFiles.put((SpdxDocument)entry.getKey(), fileDifferences);
            HashMap compareDifferentFiles = this.fileDifferences.get(entry.getKey());
            if (compareDifferentFiles == null) {
                compareDifferentFiles = Maps.newHashMap();
                this.fileDifferences.put((SpdxDocument)entry.getKey(), compareDifferentFiles);
            }
            compareDifferentFiles.put(spdxDocument, fileDifferences);
            SpdxFile[] uniqueFiles = SpdxComparer.findUniqueFiles(files, (SpdxFile[])compareFiles);
            if (uniqueFiles.length > 0) {
                this.packageFilesEquals = false;
                this.differenceFound = true;
            }
            docUniqueFiles.put((SpdxDocument)entry.getKey(), uniqueFiles);
            HashMap compareUniqueFiles = this.uniqueFiles.get(entry.getKey());
            if (compareUniqueFiles == null) {
                compareUniqueFiles = Maps.newHashMap();
                this.uniqueFiles.put((SpdxDocument)entry.getKey(), compareUniqueFiles);
            }
            if ((uniqueFiles = SpdxComparer.findUniqueFiles((SpdxFile[])compareFiles, files)).length > 0) {
                this.packageFilesEquals = false;
                this.differenceFound = true;
            }
            compareUniqueFiles.put(spdxDocument, uniqueFiles);
        }
    }

    private void compareNewPackageChecksums(SpdxDocument spdxDocument, Checksum[] checksums) throws SpdxCompareException {
        try {
            HashMap docUniqueChecksums = Maps.newHashMap();
            this.uniqueChecksums.put(spdxDocument, docUniqueChecksums);
            for (Map.Entry entry : this.documentItem.entrySet()) {
                if (!(entry.getValue() instanceof SpdxPackage)) continue;
                Checksum[] compareChecksums = ((SpdxPackage)entry.getValue()).getChecksums();
                Checksum[] uniqueChecksums = SpdxComparer.findUniqueChecksums(checksums, compareChecksums);
                if (uniqueChecksums.length > 0) {
                    this.packageChecksumsEquals = false;
                    this.differenceFound = true;
                }
                docUniqueChecksums.put((SpdxDocument)entry.getKey(), uniqueChecksums);
                HashMap compareUniqueChecksums = this.uniqueChecksums.get(entry.getKey());
                if (compareUniqueChecksums == null) {
                    compareUniqueChecksums = Maps.newHashMap();
                    this.uniqueChecksums.put((SpdxDocument)entry.getKey(), compareUniqueChecksums);
                }
                if ((uniqueChecksums = SpdxComparer.findUniqueChecksums(compareChecksums, checksums)).length > 0) {
                    this.packageChecksumsEquals = false;
                    this.differenceFound = true;
                }
                compareUniqueChecksums.put(spdxDocument, uniqueChecksums);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("SPDX error getting package checksums: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        return this.differenceFound || super.isDifferenceFound();
    }

    @Override
    protected void checkInProgress() throws SpdxCompareException {
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
        super.checkInProgress();
    }

    public boolean isPackageVersionsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageVersionsEquals;
    }

    public boolean isPackageFilenamesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageFilenamesEquals;
    }

    public boolean isPackageSuppliersEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageSuppliersEquals;
    }

    public boolean isPackageDownloadLocationsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageDownloadLocationsEquals;
    }

    public boolean isPackageVerificationCodesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageVerificationCodesEquals;
    }

    public boolean isFilesAnalyzedEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.filesAnalyzedEquals;
    }

    public boolean isPackageChecksumsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageChecksumsEquals;
    }

    public boolean isPackageSourceInfosEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageSourceInfosEquals;
    }

    public boolean isDeclaredLicensesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.declaredLicensesEquals;
    }

    public boolean isPackageSummaryEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageSummaryEquals;
    }

    public boolean isPackageDescriptionsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageDescriptionsEquals;
    }

    public boolean isPackageOriginatorsEqual() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageOriginatorsEqual;
    }

    public boolean isPackageHomePagesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageHomePagesEquals;
    }

    public boolean isExternalRefsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.externalRefsEquals;
    }

    public SpdxPackage getDocPackage(SpdxDocument document) throws SpdxCompareException {
        SpdxItem retItem = (SpdxItem)this.documentItem.get(document);
        if (retItem != null && retItem instanceof SpdxPackage) {
            return (SpdxPackage)retItem;
        }
        return null;
    }

    public Checksum[] getUniqueChecksums(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, Checksum[]> uniqueMap = this.uniqueChecksums.get(docA);
        if (uniqueMap == null) {
            return new Checksum[0];
        }
        Checksum[] retval = uniqueMap.get(docB);
        if (retval == null) {
            return new Checksum[0];
        }
        return retval;
    }

    public ExternalRef[] getUniqueExternalRefs(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, ExternalRef[]> uniqueMap = this.uniqueExternalRefs.get(docA);
        if (uniqueMap == null) {
            return new ExternalRef[0];
        }
        ExternalRef[] retval = uniqueMap.get(docB);
        if (retval == null) {
            return new ExternalRef[0];
        }
        return retval;
    }

    public SpdxExternalRefDifference[] getExternalRefDifferences(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, SpdxExternalRefDifference[]> externalRefDiffMap = this.externalRefDifferences.get(docA);
        if (externalRefDiffMap == null) {
            return new SpdxExternalRefDifference[0];
        }
        SpdxExternalRefDifference[] retval = externalRefDiffMap.get(docB);
        if (retval == null) {
            return new SpdxExternalRefDifference[0];
        }
        return retval;
    }

    public boolean isPackageFilesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageFilesEquals;
    }

    public SpdxFileDifference[] getFileDifferences(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, SpdxFileDifference[]> uniqueMap = this.fileDifferences.get(docA);
        if (uniqueMap == null) {
            return new SpdxFileDifference[0];
        }
        SpdxFileDifference[] retval = uniqueMap.get(docB);
        if (retval == null) {
            return new SpdxFileDifference[0];
        }
        return retval;
    }

    public SpdxFile[] getUniqueFiles(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, SpdxFile[]> uniqueMap = this.uniqueFiles.get(docA);
        if (uniqueMap == null) {
            return new SpdxFile[0];
        }
        SpdxFile[] retval = uniqueMap.get(docB);
        if (retval == null) {
            return new SpdxFile[0];
        }
        return retval;
    }

    public String getPackageName() throws SpdxCompareException {
        this.checkInProgress();
        return this.name;
    }

    public int getNumPackages() throws SpdxCompareException {
        this.checkInProgress();
        return this.documentItem.size();
    }
}

