/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spdx.html.AbstractJsonFile;
import org.spdx.rdfparser.license.LicenseException;

public class LicenseExceptionJSONFile
extends AbstractJsonFile {
    private boolean deprecated;
    private LicenseException exception;

    public LicenseExceptionJSONFile() {
    }

    public LicenseExceptionJSONFile(LicenseException exception, boolean deprecated) {
        this.setException(exception, deprecated);
    }

    public void setException(LicenseException exception, boolean deprecated) {
        this.exception = exception;
        this.deprecated = deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    private Object isDeprecated() {
        return this.deprecated;
    }

    @Override
    protected JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"licenseExceptionId", (Object)this.exception.getLicenseExceptionId());
        jsonObject.put((Object)"name", (Object)this.exception.getName());
        String[] seeAlsos = this.exception.getSeeAlso();
        if (seeAlsos != null && seeAlsos.length > 0) {
            JSONArray seeAlsoArray = new JSONArray();
            String[] stringArray = seeAlsos;
            int n = seeAlsos.length;
            int n2 = 0;
            while (n2 < n) {
                String seeAlso = stringArray[n2];
                seeAlsoArray.add((Object)seeAlso);
                ++n2;
            }
            jsonObject.put((Object)"seeAlso", (Object)seeAlsoArray);
        }
        jsonObject.put((Object)"licenseComments", (Object)this.exception.getComment());
        jsonObject.put((Object)"licenseExceptionText", (Object)this.exception.getLicenseExceptionText().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
        jsonObject.put((Object)"example", (Object)this.exception.getExample());
        jsonObject.put((Object)"isDeprecatedLicenseId", this.isDeprecated());
        return jsonObject;
    }
}

