/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spdx.html.AbstractJsonFile;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseTOCJSONFile
extends AbstractJsonFile {
    public static final String JSON_REFERENCE_FIELD = "detailsUrl";
    List<ListedSpdxLicense> listedLicenses = Lists.newArrayList();
    private int currentRefNumber = 1;
    String version;
    String releaseDate;

    public LicenseTOCJSONFile(String version, String releaseDate) {
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public void addLicense(SpdxListedLicense license, String licHTMLReference, String licJSONReference, boolean deprecated) {
        this.listedLicenses.add(new ListedSpdxLicense(licHTMLReference, String.valueOf(this.currentRefNumber), license.getLicenseId(), license.isOsiApproved(), license.getFsfLibre(), license.getName(), license.getSeeAlso(), deprecated, this.relativeToAbsolute(licJSONReference)));
        ++this.currentRefNumber;
    }

    private String relativeToAbsolute(String relativeRef) {
        String retval = relativeRef.startsWith("./") ? relativeRef.substring(2) : relativeRef;
        retval = "http://spdx.org/licenses/" + retval;
        return retval;
    }

    @Override
    protected JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"licenseListVersion", (Object)this.version);
        jsonObject.put((Object)"releaseDate", (Object)this.releaseDate);
        JSONArray licensesList = new JSONArray();
        Collections.sort(this.listedLicenses, new Comparator<ListedSpdxLicense>(){

            @Override
            public int compare(ListedSpdxLicense o1, ListedSpdxLicense o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getLicenseId().compareTo(o2.getLicenseId());
            }
        });
        for (ListedSpdxLicense license : this.listedLicenses) {
            JSONObject licenseJSON = new JSONObject();
            licenseJSON.put((Object)"reference", (Object)license.getReference());
            licenseJSON.put((Object)"referenceNumber", (Object)license.getRefNumber());
            licenseJSON.put((Object)"licenseId", (Object)license.getLicenseId());
            licenseJSON.put((Object)"isOsiApproved", (Object)license.getOsiApproved());
            if (license.getFsfLibre() != null) {
                licenseJSON.put((Object)"isFsfLibre", (Object)license.getFsfLibre());
            }
            licenseJSON.put((Object)"name", (Object)license.getLicenseName());
            String[] seeAlsos = license.getSeeAlso();
            if (seeAlsos != null && seeAlsos.length > 0) {
                JSONArray seeAlsoArray = new JSONArray();
                String[] stringArray = seeAlsos;
                int n = seeAlsos.length;
                int n2 = 0;
                while (n2 < n) {
                    String seeAlso = stringArray[n2];
                    seeAlsoArray.add((Object)seeAlso);
                    ++n2;
                }
                licenseJSON.put((Object)"seeAlso", (Object)seeAlsoArray);
            }
            licenseJSON.put((Object)"isDeprecatedLicenseId", (Object)license.isDeprecated());
            licenseJSON.put((Object)JSON_REFERENCE_FIELD, (Object)license.getLicJSONReference());
            licensesList.add((Object)licenseJSON);
        }
        jsonObject.put((Object)"licenses", (Object)licensesList);
        return jsonObject;
    }

    private static class ListedSpdxLicense {
        private final String reference;
        private final String refNumber;
        private final String licenseId;
        private final boolean osiApproved;
        private final Boolean fsfLibre;
        private final String licenseName;
        private final String[] seeAlso;
        private boolean deprecated;
        private String licJSONReference;

        public ListedSpdxLicense(String reference, String refNumber, String licenseId, boolean osiApproved, Boolean fsfLibre, String licenseName, String[] seeAlso, boolean deprecated, String licJSONReference) {
            this.reference = reference;
            this.refNumber = refNumber;
            this.licenseId = licenseId;
            this.osiApproved = osiApproved;
            this.fsfLibre = fsfLibre;
            this.licenseName = licenseName;
            this.seeAlso = seeAlso;
            this.deprecated = deprecated;
            this.licJSONReference = licJSONReference;
        }

        public String getLicJSONReference() {
            return this.licJSONReference;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getReference() {
            return this.reference;
        }

        public String getRefNumber() {
            return this.refNumber;
        }

        public String getLicenseId() {
            return this.licenseId;
        }

        public boolean getOsiApproved() {
            return this.osiApproved;
        }

        public Boolean getFsfLibre() {
            return this.fsfLibre;
        }

        public String getLicenseName() {
            return this.licenseName;
        }

        public String[] getSeeAlso() {
            return this.seeAlso;
        }
    }
}

