/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spdx.html.CreatorInfoContext;
import org.spdx.html.ElementContext;
import org.spdx.html.ExtractedLicensingInfoContext;
import org.spdx.html.FileContext;
import org.spdx.html.RelationshipContext;
import org.spdx.html.ReviewerContext;
import org.spdx.html.SnippetContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;

public class MustacheMap {
    public static Map<String, Object> buildDocMustachMap(SpdxDocument doc, Map<String, String> spdxIdToUrl) throws InvalidSPDXAnalysisException {
        HashMap retval = Maps.newHashMap();
        retval.put("documentName", doc.getName());
        retval.put("documentNamespace", doc.getDocumentNamespace());
        retval.put("specVersion", doc.getSpecVersion());
        retval.put("dataLicense", MustacheMap.getDataLicenseName(doc));
        retval.put("creationInfo", new CreatorInfoContext(doc));
        retval.put("docComment", doc.getComment());
        Object[] sortedAnnotations = doc.getAnnotations();
        Arrays.sort(sortedAnnotations);
        List<Object> annotations = Arrays.asList(sortedAnnotations);
        retval.put("annotations", annotations);
        List<RelationshipContext> relationships = MustacheMap.getRelationshipContexts(doc.getRelationships(), spdxIdToUrl);
        retval.put("relationships", relationships);
        Object[] sortedDocRefs = doc.getExternalDocumentRefs();
        Arrays.sort(sortedDocRefs);
        List<Object> externalDocumentReferences = Arrays.asList(sortedDocRefs);
        retval.put("externalDocRelationships", externalDocumentReferences);
        retval.put("reviewed", MustacheMap.getReviewers(doc));
        SpdxItem[] describedItems = doc.getDocumentDescribes();
        Arrays.sort(describedItems, new Comparator<SpdxItem>(){

            @Override
            public int compare(SpdxItem o1, SpdxItem o2) {
                if ((o1 == null || o1.getId() == null) && o2 != null && o2.getId() != null) {
                    return 1;
                }
                if (o2 == null || o2.getId() == null) {
                    return -1;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        ArrayList describedPkgs = Lists.newArrayList();
        ArrayList describedFiles = Lists.newArrayList();
        int i = 0;
        while (i < describedItems.length) {
            if (describedItems[i] instanceof SpdxPackage) {
                describedPkgs.add(new ElementContext(describedItems[i], spdxIdToUrl));
            } else if (describedItems[i] instanceof SpdxFile) {
                describedFiles.add(new ElementContext(describedItems[i], spdxIdToUrl));
            }
            ++i;
        }
        retval.put("describesPackage", describedPkgs);
        retval.put("describesFile", describedFiles);
        retval.put("hasExtractedLicensingInfo", MustacheMap.getExtractedLicensingInfo(doc, spdxIdToUrl));
        return retval;
    }

    private static List<RelationshipContext> getRelationshipContexts(Relationship[] relationships, Map<String, String> spdxIdToUrl) {
        ArrayList retval = Lists.newArrayList();
        if (relationships != null) {
            Arrays.sort(relationships);
            Relationship[] relationshipArray = relationships;
            int n = relationships.length;
            int n2 = 0;
            while (n2 < n) {
                Relationship relationship = relationshipArray[n2];
                retval.add(new RelationshipContext(relationship, spdxIdToUrl));
                ++n2;
            }
        }
        return retval;
    }

    public static Map<String, Object> buildDocFileMustacheMap(SpdxDocument doc, SpdxFile[] files, Map<String, String> spdxIdToUrl, Map<String, List<SpdxSnippet>> fileIdToSnippets) throws InvalidSPDXAnalysisException {
        HashMap retval = Maps.newHashMap();
        retval.put("about", "SPDX Document " + doc.getName());
        SpdxItem[] describedItems = doc.getDocumentDescribes();
        Arrays.sort(describedItems, new Comparator<SpdxItem>(){

            @Override
            public int compare(SpdxItem o1, SpdxItem o2) {
                if ((o1 == null || o1.getId() == null) && o2 != null && o2.getId() != null) {
                    return 1;
                }
                if (o2 == null || o2.getId() == null) {
                    return -1;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        ArrayList describedFiles = Lists.newArrayList();
        int i = 0;
        while (i < describedItems.length) {
            if (describedItems[i] instanceof SpdxFile) {
                describedFiles.add(new FileContext((SpdxFile)describedItems[i], spdxIdToUrl, fileIdToSnippets));
            }
            ++i;
        }
        retval.put("hasFile", describedFiles);
        return retval;
    }

    private static List<ExtractedLicensingInfoContext> getExtractedLicensingInfo(SpdxDocument doc, Map<String, String> spdxIdToUrl) {
        ArrayList retval = Lists.newArrayList();
        try {
            ExtractedLicenseInfo[] extractedLicenseInfos = doc.getExtractedLicenseInfos();
            Arrays.sort(extractedLicenseInfos, new Comparator<ExtractedLicenseInfo>(){

                @Override
                public int compare(ExtractedLicenseInfo o1, ExtractedLicenseInfo o2) {
                    if ((o1 == null || o2.getLicenseId() == null) && o2 != null && o2.getLicenseId() != null) {
                        return 1;
                    }
                    if (o2 == null || o2.getLicenseId() == null) {
                        return -1;
                    }
                    return o1.getLicenseId().compareTo(o2.getLicenseId());
                }
            });
            int i = 0;
            while (i < extractedLicenseInfos.length) {
                retval.add(new ExtractedLicensingInfoContext(extractedLicenseInfos[i], spdxIdToUrl));
                ++i;
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add(new ExtractedLicensingInfoContext(e));
        }
        return retval;
    }

    private static List<ReviewerContext> getReviewers(SpdxDocument doc) {
        ArrayList retval = Lists.newArrayList();
        try {
            SPDXReview[] reviewers = doc.getReviewers();
            if (reviewers != null) {
                int i = 0;
                while (i < reviewers.length) {
                    retval.add(new ReviewerContext(reviewers[i]));
                    ++i;
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add(new ReviewerContext(e));
        }
        return retval;
    }

    private static String getDataLicenseName(SpdxDocument doc) throws InvalidSPDXAnalysisException {
        AnyLicenseInfo dataLicense = doc.getDataLicense();
        if (dataLicense != null) {
            if (dataLicense instanceof SimpleLicensingInfo) {
                return ((SimpleLicensingInfo)dataLicense).getName();
            }
            return dataLicense.toString();
        }
        return "NONE";
    }

    public static Map<String, Object> buildExtractedLicMustachMap(SpdxDocument doc, Map<String, String> spdxIdToUrl) {
        HashMap retval = Maps.newHashMap();
        retval.put("hasExtractedLicensingInfo", MustacheMap.getExtractedLicensingInfo(doc, spdxIdToUrl));
        return retval;
    }

    public static Map<String, Object> buildPkgFileMap(SpdxPackage pkg, Map<String, String> spdxIdToUrl, Map<String, List<SpdxSnippet>> fileIdToSnippets) throws InvalidSPDXAnalysisException {
        HashMap retval = Maps.newHashMap();
        retval.put("about", "SPDX Package " + pkg.getName());
        SpdxFile[] files = pkg.getFiles();
        Arrays.sort(files, new Comparator<SpdxFile>(){

            @Override
            public int compare(SpdxFile o1, SpdxFile o2) {
                if ((o1 == null || o1.getName() == null) && o2 != null && o2.getName() != null) {
                    return 1;
                }
                if (o2 == null || o2.getName() == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList alFiles = Lists.newArrayList();
        int i = 0;
        while (i < files.length) {
            if (files[i] != null) {
                alFiles.add(new FileContext(files[i], spdxIdToUrl, fileIdToSnippets));
            }
            ++i;
        }
        retval.put("hasFile", alFiles);
        return retval;
    }

    public static Map<String, Object> buildSnippetMustachMap(SpdxDocument doc, Map<String, String> spdxIdToUrl) {
        ArrayList snippetContexts = Lists.newArrayList();
        try {
            List<SpdxSnippet> snippets = doc.getDocumentContainer().findAllSnippets();
            for (SpdxSnippet snippet : snippets) {
                snippetContexts.add(new SnippetContext(snippet, spdxIdToUrl));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            snippetContexts.add(new SnippetContext(e));
        }
        HashMap retval = Maps.newHashMap();
        retval.put("snippets", snippetContexts);
        return retval;
    }
}

