/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.spdx.html.AnnotationContext;
import org.spdx.html.ElementContext;
import org.spdx.html.ExternalRefContext;
import org.spdx.html.RelationshipContext;
import org.spdx.html.VerificationCodeContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;

public class PackageContext {
    private SpdxPackage pkg = null;
    private Map<String, String> spdxIdToUrl;

    public PackageContext(SpdxPackage pkg, Map<String, String> spdxIdToUrl) throws InvalidSPDXAnalysisException {
        this.pkg = pkg;
        this.spdxIdToUrl = spdxIdToUrl;
    }

    public String name() {
        if (this.pkg != null) {
            return this.pkg.getName();
        }
        return null;
    }

    public String versionInfo() {
        if (this.pkg != null) {
            return this.pkg.getVersionInfo();
        }
        return null;
    }

    public String downloadLocation() {
        if (this.pkg != null) {
            return this.pkg.getDownloadLocation();
        }
        return null;
    }

    public String summary() {
        if (this.pkg != null) {
            return this.pkg.getSummary();
        }
        return null;
    }

    public List<String> attributionText() {
        if (this.pkg == null || this.pkg.getAttributionText() == null) {
            return null;
        }
        return Arrays.asList(this.pkg.getAttributionText());
    }

    public String sourceInfo() {
        if (this.pkg != null) {
            return this.pkg.getSourceInfo();
        }
        return null;
    }

    public String packageFileName() {
        if (this.pkg != null) {
            return this.pkg.getPackageFileName();
        }
        return null;
    }

    public String supplier() {
        if (this.pkg != null) {
            return this.pkg.getSupplier();
        }
        return null;
    }

    public String originator() {
        if (this.pkg != null) {
            return this.pkg.getOriginator();
        }
        return null;
    }

    public String description() {
        if (this.pkg != null) {
            return this.pkg.getDescription();
        }
        return null;
    }

    public VerificationCodeContext packageVerificationCode() {
        SpdxPackageVerificationCode verificationCode;
        block4: {
            if (this.pkg == null) {
                return null;
            }
            try {
                verificationCode = this.pkg.getPackageVerificationCode();
                if (verificationCode != null) break block4;
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                return new VerificationCodeContext(e);
            }
        }
        return new VerificationCodeContext(verificationCode);
    }

    public List<String> checksum() {
        if (this.pkg != null) {
            Checksum[] checksums;
            ArrayList retval;
            block5: {
                retval = Lists.newArrayList();
                checksums = this.pkg.getChecksums();
                if (checksums != null && checksums.length <= 0) break block5;
                return null;
            }
            try {
                int i = 0;
                while (i < checksums.length) {
                    retval.add(String.valueOf((String)Checksum.CHECKSUM_ALGORITHM_TO_TAG.get((Object)checksums[i].getAlgorithm())) + " " + checksums[i].getValue());
                    ++i;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Error getting SPDX Package checksum: " + e.getMessage());
            }
            Collections.sort(retval);
            return retval;
        }
        return null;
    }

    public String copyrightText() {
        if (this.pkg != null) {
            return this.pkg.getCopyrightText();
        }
        return null;
    }

    public String licenseDeclared() {
        if (this.pkg != null) {
            try {
                AnyLicenseInfo info = this.pkg.getLicenseDeclared();
                if (info != null) {
                    return info.toString();
                }
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package copyright: " + e.getMessage();
            }
        }
        return null;
    }

    public String licenseConcluded() {
        if (this.pkg != null) {
            AnyLicenseInfo info = this.pkg.getLicenseConcluded();
            if (info != null) {
                return info.toString();
            }
            return null;
        }
        return null;
    }

    public String licenseComments() {
        if (this.pkg != null) {
            return this.pkg.getLicenseComments();
        }
        return null;
    }

    public String homePage() {
        if (this.pkg != null) {
            return this.pkg.getHomepage();
        }
        return null;
    }

    public List<String> licenseInfoFromFiles() {
        ArrayList retval = Lists.newArrayList();
        if (this.pkg != null) {
            AnyLicenseInfo[] licenseInfos = null;
            licenseInfos = this.pkg.getLicenseInfoFromFiles();
            if (licenseInfos != null) {
                int i = 0;
                while (i < licenseInfos.length) {
                    retval.add(licenseInfos[i].toString());
                    ++i;
                }
            }
        }
        Collections.sort(retval);
        return retval;
    }

    public String spdxId() {
        if (this.pkg == null) {
            return null;
        }
        return this.pkg.getId();
    }

    public List<ElementContext> hasFile() {
        ArrayList retval = Lists.newArrayList();
        if (this.pkg != null) {
            try {
                SpdxFile[] files = this.pkg.getFiles();
                if (files != null) {
                    int i = 0;
                    while (i < files.length) {
                        retval.add(new ElementContext(files[i], this.spdxIdToUrl));
                        ++i;
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add(new ElementContext(e));
            }
        }
        Collections.sort(retval, new Comparator<ElementContext>(){

            @Override
            public int compare(ElementContext o1, ElementContext o2) {
                if ((o1 == null || o1.getId() == null) && o2 != null && o2.getId() != null) {
                    return 1;
                }
                if (o2 == null || o2.getId() == null) {
                    return -1;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        return retval;
    }

    public boolean isFilesAnalyzed() {
        if (this.pkg == null) {
            return true;
        }
        try {
            return this.pkg.isFilesAnalyzed();
        }
        catch (InvalidSPDXAnalysisException e) {
            return true;
        }
    }

    public List<RelationshipContext> packageRelationships() {
        ArrayList retval = Lists.newArrayList();
        Object[] relationships = this.pkg.getRelationships();
        if (relationships != null) {
            Arrays.sort(relationships);
            Object[] objectArray = relationships;
            int n = relationships.length;
            int n2 = 0;
            while (n2 < n) {
                Object relationship = objectArray[n2];
                retval.add(new RelationshipContext((Relationship)relationship, this.spdxIdToUrl));
                ++n2;
            }
        }
        return retval;
    }

    public List<AnnotationContext> packageAnnotations() {
        ArrayList retval = Lists.newArrayList();
        Object[] annotations = this.pkg.getAnnotations();
        if (annotations != null) {
            Arrays.sort(annotations);
            Object[] objectArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Object annotation = objectArray[n2];
                retval.add(new AnnotationContext((Annotation)annotation));
                ++n2;
            }
        }
        return retval;
    }

    public List<ExternalRefContext> externalRefs() {
        ArrayList retval = Lists.newArrayList();
        if (this.pkg != null) {
            try {
                Object[] externalRefs = this.pkg.getExternalRefs();
                if (externalRefs != null) {
                    Arrays.sort(externalRefs);
                    Object[] objectArray = externalRefs;
                    int n = externalRefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object externalRef = objectArray[n2];
                        retval.add(new ExternalRefContext((ExternalRef)externalRef));
                        ++n2;
                    }
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return retval;
    }
}

