/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxPackageVerificationCode;

public class VerificationCodeContext {
    SpdxPackageVerificationCode code = null;
    Exception error = null;

    public VerificationCodeContext(SpdxPackageVerificationCode verificationCode) {
        this.code = verificationCode;
    }

    public VerificationCodeContext(InvalidSPDXAnalysisException e) {
        this.error = e;
    }

    public String packageVerificationCodeValue() {
        if (this.code == null || this.code.getValue() == null) {
            if (this.error != null) {
                return "Error getting package verification code: " + this.error.getMessage();
            }
            return "NONE";
        }
        return this.code.getValue();
    }

    public List<String> packageVerificationCodeExcludedFile() {
        String[] skippedFiles;
        ArrayList retval = Lists.newArrayList();
        if (this.code != null && (skippedFiles = this.code.getExcludedFileNames()) != null) {
            int i = 0;
            while (i < skippedFiles.length) {
                retval.add(skippedFiles[i]);
                ++i;
            }
        }
        return retval;
    }
}

