/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.merge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.spdx.merge.SpdxLicenseMapper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;

public class SpdxFileInfoMerger {
    private SpdxDocument master = null;
    private SpdxLicenseMapper mapper = null;

    public SpdxFileInfoMerger(SpdxDocument master, SpdxLicenseMapper mapper) {
        this.master = master;
        this.mapper = mapper;
    }

    public SpdxFile[] mergeFileInfo(SpdxDocument[] subDocs) throws InvalidSPDXAnalysisException {
        List<SpdxFile> masterFileInfo = this.master.getDocumentContainer().findAllFiles();
        ArrayList retval = Lists.newArrayList(this.cloneFiles(masterFileInfo));
        int q = 0;
        while (q < subDocs.length) {
            SpdxFile[] subFileInfo = this.cloneList(subDocs[q].getDocumentContainer().findAllFiles());
            int k = 0;
            while (k < subFileInfo.length) {
                boolean foundNameMatch = false;
                boolean foundSha1Match = false;
                SpdxFile temp = null;
                int p = 0;
                while (p < retval.size()) {
                    temp = (SpdxFile)retval.get(p);
                    if (subFileInfo[k].getName().equalsIgnoreCase(((SpdxFile)retval.get(p)).getName())) {
                        foundNameMatch = true;
                    }
                    if (subFileInfo[k].getSha1().equals(((SpdxFile)retval.get(p)).getSha1())) {
                        foundSha1Match = true;
                        break;
                    }
                    ++p;
                }
                if (!foundNameMatch && !foundSha1Match) {
                    if (this.mapper.docInNonStdLicIdMap(subDocs[q])) {
                        this.mapper.replaceNonStdLicInFile(subDocs[q], subFileInfo[k]);
                        retval.add(subFileInfo[k]);
                    } else {
                        retval.add(subFileInfo[k]);
                    }
                } else {
                    boolean foundMasterDOAP = false;
                    boolean foundChildDOAP = false;
                    if (this.checkDoapProject(temp)) {
                        foundMasterDOAP = true;
                        break;
                    }
                    if (this.checkDoapProject(subFileInfo[k])) {
                        foundChildDOAP = true;
                        break;
                    }
                    if (foundMasterDOAP && foundChildDOAP) {
                        DoapProject[] masterArtifactOf = this.cloneDoapProject(temp.getArtifactOf());
                        DoapProject[] subArtifactOfA = this.cloneDoapProject(subFileInfo[k].getArtifactOf());
                        DoapProject[] mergedArtifactOf = this.mergeDOAPInfo(masterArtifactOf, subArtifactOfA);
                        temp.setArtifactOf(mergedArtifactOf);
                    }
                    if (!foundMasterDOAP && foundChildDOAP) {
                        DoapProject[] childArtifactOfB = this.cloneDoapProject(subFileInfo[k].getArtifactOf());
                        temp.setArtifactOf(childArtifactOfB);
                    }
                }
                ++k;
            }
            ++q;
        }
        SpdxFile[] fileMergeResult = new SpdxFile[retval.size()];
        retval.toArray(fileMergeResult);
        retval.clear();
        return fileMergeResult;
    }

    public boolean checkDoapProject(SpdxFile spdxFile) {
        boolean foundDoapProject = false;
        if (spdxFile.getArtifactOf() != null && spdxFile.getArtifactOf().length > 0) {
            foundDoapProject = true;
        }
        return foundDoapProject;
    }

    public DoapProject[] mergeDOAPInfo(DoapProject[] masterArtifactOf, DoapProject[] subArtifactOf) {
        ArrayList retval = Lists.newArrayList((Object[])masterArtifactOf);
        int l = 0;
        while (l < subArtifactOf.length) {
            boolean foundMatch = false;
            int u = 0;
            while (u < masterArtifactOf.length) {
                if (subArtifactOf[l].equals(masterArtifactOf[u])) {
                    foundMatch = true;
                    break;
                }
                ++u;
            }
            if (!foundMatch) {
                retval.add(subArtifactOf[l]);
            }
            ++l;
        }
        DoapProject[] mergedArtifactOf = new DoapProject[retval.size()];
        retval.toArray(mergedArtifactOf);
        retval.clear();
        return mergedArtifactOf;
    }

    public List<SpdxFile> cloneFiles(List<SpdxFile> filesArray) {
        ArrayList<SpdxFile> clonedFilesArray = new ArrayList<SpdxFile>();
        int h = 0;
        while (h < filesArray.size()) {
            clonedFilesArray.add(filesArray.get(h).clone());
            ++h;
        }
        return clonedFilesArray;
    }

    public SpdxFile[] cloneList(List<SpdxFile> filesList) {
        ArrayList clonedFilesList = Lists.newArrayList();
        int h = 0;
        while (h < filesList.size()) {
            clonedFilesList.add(filesList.get(h));
            ++h;
        }
        SpdxFile[] clonedFilesArray = new SpdxFile[clonedFilesList.size()];
        clonedFilesList.toArray(clonedFilesArray);
        return clonedFilesArray;
    }

    public DoapProject[] cloneDoapProject(DoapProject[] orgProjectArray) {
        DoapProject[] clonedProjectArray = new DoapProject[orgProjectArray.length];
        int j = 0;
        while (j < orgProjectArray.length) {
            clonedProjectArray[j] = orgProjectArray[j].clone();
            ++j;
        }
        return clonedProjectArray;
    }
}

