/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.merge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.merge.SpdxLicenseMapper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.SpdxDocument;

public class SpdxLicenseInfoMerger {
    private SpdxDocument output = null;
    private SpdxLicenseMapper mapper = null;

    public SpdxLicenseInfoMerger(SpdxDocument outputDoc, SpdxLicenseMapper mapper) {
        this.output = outputDoc;
        this.mapper = mapper;
    }

    public ExtractedLicenseInfo[] mergeNonStdLic(SpdxDocument[] subDocs) throws InvalidSPDXAnalysisException {
        Object[] masterNonStdLicInfo = this.output.getExtractedLicenseInfos();
        ArrayList retval = Lists.newArrayList((Object[])masterNonStdLicInfo);
        int i = 0;
        while (i < subDocs.length) {
            ExtractedLicenseInfo[] subNonStdLicInfo = this.cloneNonStdLic(subDocs[i].getExtractedLicenseInfos());
            ExtractedLicenseInfo foundLicense = null;
            int k = 0;
            while (k < subNonStdLicInfo.length) {
                boolean foundTextMatch = false;
                int p = 0;
                while (p < retval.size()) {
                    if (LicenseCompareHelper.isLicenseTextEquivalent(subNonStdLicInfo[k].getExtractedText(), ((ExtractedLicenseInfo)retval.get(p)).getExtractedText())) {
                        foundTextMatch = true;
                        foundLicense = (ExtractedLicenseInfo)retval.get(p);
                        break;
                    }
                    ++p;
                }
                if (foundTextMatch) {
                    this.mapper.mappingExistingNonStdLic(this.output, foundLicense, subDocs[i], subNonStdLicInfo[k]);
                }
                if (!foundTextMatch) {
                    retval.add(this.mapper.mappingNewNonStdLic(this.output, subDocs[i], subNonStdLicInfo[k]));
                }
                ++k;
            }
            ++i;
        }
        ExtractedLicenseInfo[] nonStdLicMergeResult = new ExtractedLicenseInfo[retval.size()];
        retval.toArray(nonStdLicMergeResult);
        retval.clear();
        return nonStdLicMergeResult;
    }

    public ExtractedLicenseInfo[] cloneNonStdLic(ExtractedLicenseInfo[] orgNonStdLicArray) {
        ExtractedLicenseInfo[] clonedNonStdLicArray = new ExtractedLicenseInfo[orgNonStdLicArray.length];
        int q = 0;
        while (q < orgNonStdLicArray.length) {
            clonedNonStdLicArray[q] = (ExtractedLicenseInfo)orgNonStdLicArray[q].clone();
            ++q;
        }
        return clonedNonStdLicArray;
    }
}

