/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.spdx.rdfparser.IFileChecksumGenerator;

public class JavaSha1ChecksumGenerator
implements IFileChecksumGenerator {
    static final String SHA1_ALGORITHM = "SHA-1";
    static final String PACKAGE_VERIFICATION_CHARSET = "UTF-8";
    private MessageDigest digest = MessageDigest.getInstance("SHA-1");

    @Override
    public String getFileChecksum(File file) throws IOException {
        this.digest.reset();
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buffer = new byte[2048];
            int numBytes = in.read(buffer);
            while (numBytes >= 0) {
                this.digest.update(buffer, 0, numBytes);
                numBytes = in.read(buffer);
            }
            byte[] digestBytes = this.digest.digest();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < digestBytes.length) {
                String hex = Integer.toHexString(0xFF & digestBytes[i]);
                if (hex.length() < 2) {
                    sb.append('0');
                }
                sb.append(hex);
                ++i;
            }
            String string = sb.toString();
            return string;
        }
    }
}

