/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.jena.iri.IRIFactory;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.SpdxFile;

public class SpdxVerificationHelper {
    static IRIFactory iriFactory = IRIFactory.iriImplementation();
    static final String[] VALID_CREATOR_PREFIXES = new String[]{"Person:", "Organization:", "Tool:"};
    static final String[] VALID_ORIGINATOR_SUPPLIER_PREFIXES = new String[]{"NOASSERTION", "Person:", "Organization:"};

    public static String verifyNonStdLicenseid(String licenseId) {
        if (SpdxRdfConstants.LICENSE_ID_PATTERN.matcher(licenseId).matches()) {
            return null;
        }
        return "Invalid license id '" + licenseId + "'.  Must start with 'LicenseRef-' " + "and made up of the characters from the set 'a'-'z', 'A'-'Z', '0'-'9', '+', '_', '.', and '-'.";
    }

    public static String verifyChecksumString(String checksum) {
        return SpdxVerificationHelper.verifyChecksumString(checksum, Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1);
    }

    public static String verifyChecksumString(String checksum, Checksum.ChecksumAlgorithm algorithm) {
        int i = 0;
        while (i < checksum.length()) {
            char c = checksum.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                return "Invalid checksum string character at position " + String.valueOf(i);
            }
            ++i;
        }
        if (Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1.equals((Object)algorithm) && checksum.length() != 40) {
            return "Invalid number of characters for checksum";
        }
        if (Checksum.ChecksumAlgorithm.checksumAlgorithm_sha256.equals((Object)algorithm) && checksum.length() != 64) {
            return "Invalid number of characters for checksum";
        }
        if (Checksum.ChecksumAlgorithm.checksumAlgorithm_md5.equals((Object)algorithm) && checksum.length() != 32) {
            return "Invalid number of characters for checksum";
        }
        return null;
    }

    public static String verifyFileType(String fileType) {
        if (SpdxFile.FileType.fromTag(fileType) == null) {
            return "Unrecognized file type";
        }
        return null;
    }

    public static String verifyCreator(String creator) {
        boolean ok = false;
        int i = 0;
        while (i < VALID_CREATOR_PREFIXES.length) {
            if (creator.startsWith(VALID_CREATOR_PREFIXES[i])) {
                ok = true;
                break;
            }
            ++i;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Creator does not start with one of ");
            sb.append(VALID_CREATOR_PREFIXES[0]);
            int i2 = 1;
            while (i2 < VALID_CREATOR_PREFIXES.length) {
                sb.append(", ");
                sb.append(VALID_CREATOR_PREFIXES[i2]);
                ++i2;
            }
            return sb.toString();
        }
        return null;
    }

    public static String verifyOriginator(String originator) {
        return SpdxVerificationHelper.verifyOriginatorOrSupplier(originator);
    }

    public static String verifySupplier(String supplier) {
        return SpdxVerificationHelper.verifyOriginatorOrSupplier(supplier);
    }

    private static String verifyOriginatorOrSupplier(String originatorOrSupplier) {
        boolean ok = false;
        int i = 0;
        while (i < VALID_ORIGINATOR_SUPPLIER_PREFIXES.length) {
            if (originatorOrSupplier.startsWith(VALID_ORIGINATOR_SUPPLIER_PREFIXES[i])) {
                ok = true;
                break;
            }
            ++i;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Value must start with one of ");
            sb.append(VALID_ORIGINATOR_SUPPLIER_PREFIXES[0]);
            int i2 = 1;
            while (i2 < VALID_ORIGINATOR_SUPPLIER_PREFIXES.length) {
                sb.append(", ");
                sb.append(VALID_ORIGINATOR_SUPPLIER_PREFIXES[i2]);
                ++i2;
            }
            return sb.toString();
        }
        return null;
    }

    public static String verifyDate(String creationDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            format.parse(creationDate);
        }
        catch (ParseException e) {
            return "Invalid date format: " + e.getMessage();
        }
        return null;
    }

    public static String verifyReviewer(String reviewer) {
        if (!(reviewer.startsWith("Person:") || reviewer.startsWith("Tool:") || reviewer.startsWith("Organization:"))) {
            return "Reviewer does not start with Person:, Organization:, or Tool:";
        }
        return null;
    }

    public static boolean isValidUri(String uri) {
        return !iriFactory.create(uri).hasViolation(false);
    }

    public static boolean equalsWithNull(Object s1, Object s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equivalentArray(Object[] s1, Object[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            boolean found = false;
            int j = 0;
            while (j < s2.length) {
                if (SpdxVerificationHelper.equalsWithNull(s1[i], s2[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String verifyAnnotator(String annotator) {
        if (!(annotator.startsWith("Person:") || annotator.startsWith("Tool:") || annotator.startsWith("Organization:"))) {
            return "Annotator does not start with Person:, Organization:, or Tool";
        }
        return null;
    }

    public static boolean isValidExternalDocRef(String externalDocumentId) {
        return SpdxRdfConstants.EXTERNAL_DOC_REF_PATTERN.matcher(externalDocumentId).matches();
    }
}

