/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.spdx.rdfparser.IFileChecksumGenerator;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.model.SpdxFile;

public class VerificationCodeGenerator {
    private IFileChecksumGenerator fileChecksumGenerator;

    public VerificationCodeGenerator(IFileChecksumGenerator fileChecksumGenerator) {
        this.fileChecksumGenerator = fileChecksumGenerator;
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(SpdxFile[] spdxFiles, String[] skippedFilePaths) throws NoSuchAlgorithmException {
        if (spdxFiles == null) {
            return null;
        }
        TreeSet skippedFilePathSet = Sets.newTreeSet();
        if (skippedFilePaths != null) {
            int i = 0;
            while (i < skippedFilePaths.length) {
                if (skippedFilePaths[i] != null) {
                    skippedFilePathSet.add(skippedFilePaths[i]);
                }
                ++i;
            }
        }
        ArrayList fileChecksums = Lists.newArrayList();
        int i = 0;
        while (i < spdxFiles.length) {
            if (spdxFiles[i] != null && spdxFiles[i].getName() != null && !skippedFilePathSet.contains(spdxFiles[i].getName())) {
                fileChecksums.add(spdxFiles[i].getSha1());
            }
            ++i;
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFilePaths);
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory, File[] skippedFiles) throws NoSuchAlgorithmException, IOException {
        TreeSet skippedFilesPath = Sets.newTreeSet();
        String rootOfDirectory = sourceDirectory.getAbsolutePath();
        int rootLen = rootOfDirectory.length() + 1;
        int i = 0;
        while (i < skippedFiles.length) {
            String skippedPath = VerificationCodeGenerator.normalizeFilePath(skippedFiles[i].getAbsolutePath().substring(rootLen));
            skippedFilesPath.add(skippedPath);
            ++i;
        }
        ArrayList fileChecksums = Lists.newArrayList();
        this.collectFileData(rootOfDirectory, sourceDirectory, fileChecksums, skippedFilesPath);
        String[] skippedFileNames = new String[skippedFilesPath.size()];
        Iterator iter = skippedFilesPath.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            skippedFileNames[i2++] = (String)iter.next();
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFileNames);
    }

    protected SpdxPackageVerificationCode generatePackageVerificationCode(List<String> fileChecksums, String[] skippedFilePaths) throws NoSuchAlgorithmException {
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance("SHA-1");
        int i = 0;
        while (i < fileChecksums.size()) {
            byte[] hashInput = fileChecksums.get(i).getBytes(Charset.forName("UTF-8"));
            verificationCodeDigest.update(hashInput);
            ++i;
        }
        String value = VerificationCodeGenerator.convertChecksumToString(verificationCodeDigest.digest());
        SpdxPackageVerificationCode retval = new SpdxPackageVerificationCode(value, skippedFilePaths);
        return retval;
    }

    private void collectFileData(String prefixForRelative, File sourceDirectory, List<String> fileNameAndChecksums, Set<String> skippedFiles) throws IOException {
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        File[] filesAndDirs = sourceDirectory.listFiles();
        if (filesAndDirs == null) {
            return;
        }
        int i = 0;
        while (i < filesAndDirs.length) {
            if (filesAndDirs[i].isDirectory()) {
                this.collectFileData(prefixForRelative, filesAndDirs[i], fileNameAndChecksums, skippedFiles);
            } else {
                String filePath = VerificationCodeGenerator.normalizeFilePath(filesAndDirs[i].getAbsolutePath().substring(prefixForRelative.length() + 1));
                if (!skippedFiles.contains(filePath)) {
                    String checksumValue = this.fileChecksumGenerator.getFileChecksum(filesAndDirs[i]).toLowerCase();
                    fileNameAndChecksums.add(checksumValue);
                }
            }
            ++i;
        }
    }

    public static String normalizeFilePath(String nonNormalizedFilePath) {
        String filePath = nonNormalizedFilePath.replace('\\', '/').trim();
        if (filePath.contains("../")) {
            String[] filePathParts = filePath.split("/");
            StringBuilder normalizedFilePath = new StringBuilder();
            int j = 0;
            while (j < filePathParts.length) {
                if (!(j + 1 < filePathParts.length && filePathParts[j + 1].equals("..") || filePathParts[j].equals(".."))) {
                    if (j > 0) {
                        normalizedFilePath.append('/');
                    }
                    normalizedFilePath.append(filePathParts[j]);
                }
                ++j;
            }
            filePath = normalizedFilePath.toString();
        }
        filePath = !(filePath = filePath.replace("./", "")).isEmpty() && filePath.charAt(0) == '/' ? "." + filePath : "./" + filePath;
        return filePath;
    }

    private static String convertChecksumToString(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < digest.length) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory) throws NoSuchAlgorithmException, IOException {
        return this.generatePackageVerificationCode(sourceDirectory, new File[0]);
    }
}

