/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseSet;
import org.spdx.rdfparser.model.IRdfModel;

public class DisjunctiveLicenseSet
extends LicenseSet {
    public DisjunctiveLicenseSet(IModelContainer modelContainer, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, licenseInfoNode);
    }

    public DisjunctiveLicenseSet(AnyLicenseInfo[] disjunctiveLicenses) {
        super(disjunctiveLicenses);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        boolean moreThanOne = false;
        Iterator iter = this.licenseInfos.iterator();
        while (iter.hasNext()) {
            if (moreThanOne) {
                sb.append(" OR ");
            }
            moreThanOne = true;
            sb.append(((AnyLicenseInfo)iter.next()).toString());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int retval = 41;
        AnyLicenseInfo[] allMembers = this.getFlattenedMembers();
        int i = 0;
        while (i < allMembers.length) {
            retval ^= allMembers[i].hashCode();
            ++i;
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        AnyLicenseInfo[] myInfos;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisjunctiveLicenseSet)) {
            return false;
        }
        DisjunctiveLicenseSet comp = (DisjunctiveLicenseSet)o;
        AnyLicenseInfo[] compInfos = comp.getFlattenedMembers();
        if (compInfos.length != (myInfos = this.getFlattenedMembers()).length) {
            return false;
        }
        int j = 0;
        while (j < myInfos.length) {
            AnyLicenseInfo li = myInfos[j];
            boolean found = false;
            int i = 0;
            while (i < compInfos.length) {
                if (li.equals(compInfos[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                return false;
            }
            ++j;
        }
        return true;
    }

    @Override
    public AnyLicenseInfo clone() {
        AnyLicenseInfo[] clonedSet = new AnyLicenseInfo[this.licenseInfos.size()];
        Iterator iter = this.licenseInfos.iterator();
        int i = 0;
        while (iter.hasNext()) {
            clonedSet[i++] = ((AnyLicenseInfo)iter.next()).clone();
        }
        return new DisjunctiveLicenseSet(clonedSet);
    }

    protected AnyLicenseInfo[] getFlattenedMembers() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                this.getPropertiesFromModel();
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.warn("Error getting properites from model, using stored values.", (Throwable)e);
            }
        }
        HashSet<AnyLicenseInfo> retval = new HashSet<AnyLicenseInfo>();
        for (AnyLicenseInfo li : this.licenseInfos) {
            if (li instanceof DisjunctiveLicenseSet) {
                AnyLicenseInfo[] members = ((DisjunctiveLicenseSet)li).getFlattenedMembers();
                int i = 0;
                while (i < members.length) {
                    retval.add(members[i]);
                    ++i;
                }
                continue;
            }
            retval.add(li);
        }
        return retval.toArray(new AnyLicenseInfo[retval.size()]);
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        AnyLicenseInfo[] myInfos;
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof DisjunctiveLicenseSet)) {
            return false;
        }
        DisjunctiveLicenseSet comp = (DisjunctiveLicenseSet)compare;
        AnyLicenseInfo[] compInfos = comp.getFlattenedMembers();
        if (compInfos.length != (myInfos = this.getFlattenedMembers()).length) {
            return false;
        }
        int j = 0;
        while (j < myInfos.length) {
            AnyLicenseInfo li = myInfos[j];
            boolean found = false;
            int i = 0;
            while (i < compInfos.length) {
                if (li.equivalent(compInfos[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                return false;
            }
            ++j;
        }
        return true;
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#DisjunctiveLicenseSet");
    }
}

