/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class LicenseJsonTOC {
    private String licenseListVersion;
    private LicenseJson[] licenses;
    private String releaseDate;

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public LicenseJson[] getLicenses() {
        return this.licenses;
    }

    public Map<String, String> getLicenseIds() {
        HashMap retval = Maps.newHashMap();
        if (this.licenses == null) {
            return retval;
        }
        LicenseJson[] licenseJsonArray = this.licenses;
        int n = this.licenses.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseJson license = licenseJsonArray[n2];
            retval.put(license.licenseId.toLowerCase(), license.licenseId);
            ++n2;
        }
        return retval;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public class LicenseJson {
        private String reference;
        private boolean isDeprecatedLicenseId;
        private String detailsUrl;
        private int referenceNumber;
        private String name;
        private String licenseId;
        private String[] seeAlso;
        private boolean isOsiApproved;

        public String getReference() {
            return this.reference;
        }

        public boolean isDeprecatedLicenseId() {
            return this.isDeprecatedLicenseId;
        }

        public String getDetailsUrl() {
            return this.detailsUrl;
        }

        public int getReferenceNumber() {
            return this.referenceNumber;
        }

        public String getName() {
            return this.name;
        }

        public String getLicenseId() {
            return this.licenseId;
        }

        public String[] getSeeAlso() {
            return this.seeAlso;
        }

        public boolean isOsiApproved() {
            return this.isOsiApproved;
        }
    }
}

