/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;

public class Annotation
extends RdfModelObject
implements Comparable<Annotation> {
    static final Logger logger = LoggerFactory.getLogger((String)RdfModelObject.class.getName());
    @Deprecated
    public static final Map<AnnotationType, String> ANNOTATION_TYPE_TO_TAG;
    @Deprecated
    public static final Map<String, AnnotationType> TAG_TO_ANNOTATION_TYPE;
    AnnotationType annotationType;
    String annotator;
    String comment;
    String annotationDate;

    static {
        ImmutableMap.Builder tagToAnnotationTypeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder annoationTypeToTagBuilder = ImmutableMap.builder();
        annoationTypeToTagBuilder.put((Object)AnnotationType.annotationType_other, (Object)"OTHER");
        tagToAnnotationTypeBuilder.put((Object)"OTHER", (Object)AnnotationType.annotationType_other);
        annoationTypeToTagBuilder.put((Object)AnnotationType.annotationType_review, (Object)"REVIEW");
        tagToAnnotationTypeBuilder.put((Object)"REVIEW", (Object)AnnotationType.annotationType_review);
        TAG_TO_ANNOTATION_TYPE = tagToAnnotationTypeBuilder.build();
        ANNOTATION_TYPE_TO_TAG = annoationTypeToTagBuilder.build();
    }

    public Annotation(String annotator, AnnotationType annotationType, String date, String comment) {
        this.annotator = annotator;
        this.annotationType = annotationType;
        this.annotationDate = date;
        this.comment = comment;
    }

    public Annotation(IModelContainer modelContainer, Node annotationNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, annotationNode);
        this.getPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.annotator = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "annotator");
        this.annotationDate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "annotationDate");
        this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        String annotationTypeUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "annotationType");
        if (annotationTypeUri != null) {
            String sAnnotationType = annotationTypeUri.substring("http://spdx.org/rdf/terms#".length());
            try {
                this.annotationType = AnnotationType.valueOf(sAnnotationType);
            }
            catch (Exception ex) {
                logger.error("Invalid annotation type found in the model: " + sAnnotationType);
                throw new InvalidSPDXAnalysisException("Invalid annotation type: " + sAnnotationType);
            }
        }
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#Annotation");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        if (this.annotationType != null) {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "annotationType", "http://spdx.org/rdf/terms#" + this.annotationType.toString());
        }
        if (this.annotator != null) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "annotator", this.annotator);
        }
        if (this.comment != null) {
            this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", this.comment);
        }
        if (this.annotationDate != null) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "annotationDate", this.annotationDate);
        }
    }

    @Override
    public List<String> verify() {
        ArrayList retval = Lists.newArrayList();
        if (this.annotationType == null) {
            retval.add("Missing annotationtype for Annotation");
        }
        if (this.annotator == null) {
            retval.add("Missing annotator for Annotation");
        } else {
            String v = SpdxVerificationHelper.verifyAnnotator(this.annotator);
            if (v != null && !v.isEmpty()) {
                retval.add(String.valueOf(v) + ":" + this.annotator);
            }
        }
        if (this.comment == null) {
            retval.add("Missing comment for Annotation");
        }
        if (this.annotationDate == null) {
            retval.add("Missing date for Annotation");
        } else {
            String dateVerify = SpdxVerificationHelper.verifyDate(this.annotationDate);
            if (dateVerify != null && !dateVerify.isEmpty()) {
                retval.add(dateVerify);
            }
        }
        return retval;
    }

    public AnnotationType getAnnotationType() {
        String annotationTypeUri;
        if (this.resource != null && this.refreshOnGet && (annotationTypeUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "annotationType")) != null) {
            String sAnnotationType = annotationTypeUri.substring("http://spdx.org/rdf/terms#".length());
            try {
                this.annotationType = AnnotationType.valueOf(sAnnotationType);
            }
            catch (Exception ex) {
                logger.error("Invalid annotation type found in the model - " + sAnnotationType);
            }
        }
        return this.annotationType;
    }

    public void setAnnotationType(AnnotationType annotationType) throws InvalidSPDXAnalysisException {
        this.annotationType = annotationType;
        if (annotationType != null) {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "annotationType", "http://spdx.org/rdf/terms#" + annotationType.toString());
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "annotationType");
        }
    }

    public String getAnnotator() {
        if (this.resource != null && this.refreshOnGet) {
            this.annotator = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "annotator");
        }
        return this.annotator;
    }

    public void setAnnotator(String annotator) {
        this.annotator = annotator;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "annotator", annotator);
    }

    public String getComment() {
        if (this.resource != null && this.refreshOnGet) {
            this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", comment);
    }

    public String getAnnotationDate() {
        if (this.resource != null && this.refreshOnGet) {
            this.annotationDate = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "annotationDate");
        }
        return this.annotationDate;
    }

    public void setAnnotationDate(String date) throws InvalidSPDXAnalysisException {
        this.annotationDate = date;
        if (date != null) {
            String dateVerify = SpdxVerificationHelper.verifyDate(date);
            if (dateVerify != null && !dateVerify.isEmpty()) {
                throw new InvalidSPDXAnalysisException("Invalid date format: " + dateVerify);
            }
            this.setPropertyValue("http://spdx.org/rdf/terms#", "annotationDate", date);
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "annotationDate");
        }
    }

    @Override
    public String getUri(IModelContainer modelContainer) {
        return null;
    }

    public Annotation clone() {
        return new Annotation(this.annotator, this.annotationType, this.annotationDate, this.comment);
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation comp = (Annotation)o;
        return Objects.equal((Object)this.getAnnotator(), (Object)comp.getAnnotator()) && Objects.equal((Object)((Object)this.getAnnotationType()), (Object)((Object)comp.getAnnotationType())) && Objects.equal((Object)this.getComment(), (Object)comp.getComment()) && Objects.equal((Object)this.getAnnotationDate(), (Object)comp.getAnnotationDate());
    }

    public String getAnnotationTypeTag() {
        return this.annotationType.getTag();
    }

    @Override
    public int compareTo(Annotation o) {
        if (o == null) {
            return 1;
        }
        if (o.getAnnotationDate() == null && this.annotationDate != null) {
            return 1;
        }
        if (this.annotationDate == null) {
            return -1;
        }
        int retval = this.annotationDate.compareTo(o.getAnnotationDate());
        if (retval != 0) {
            return retval;
        }
        if (o.getAnnotator() == null && this.annotator != null) {
            return 1;
        }
        if (this.annotator == null) {
            return -1;
        }
        retval = this.annotator.compareToIgnoreCase(o.getAnnotator());
        if (retval != 0) {
            return retval;
        }
        if (o.getAnnotationType() == null && this.annotationType != null) {
            return 1;
        }
        if (this.annotationType == null) {
            return -1;
        }
        return this.annotationType.compareTo(o.getAnnotationType());
    }

    public static enum AnnotationType {
        annotationType_other,
        annotationType_review;


        public String getTag() {
            return ANNOTATION_TYPE_TO_TAG.get((Object)this);
        }

        public static AnnotationType fromTag(String tag) {
            return TAG_TO_ANNOTATION_TYPE.get(tag);
        }
    }
}

