/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.pointer.ByteOffsetPointer;
import org.spdx.rdfparser.model.pointer.LineCharPointer;
import org.spdx.rdfparser.model.pointer.StartEndPointer;

public class SpdxSnippet
extends SpdxItem
implements Comparable<SpdxSnippet> {
    private SpdxFile snippetFromFile;
    private StartEndPointer byteRange;
    private StartEndPointer lineRange;

    public SpdxSnippet(String name, String comment, Annotation[] annotations, Relationship[] relationships, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfoInFile, String copyrightText, String licenseComment, SpdxFile snippetFromFile, StartEndPointer byteRange, StartEndPointer lineRange) {
        super(name, comment, annotations, relationships, licenseConcluded, licenseInfoInFile, copyrightText, licenseComment);
        this.snippetFromFile = snippetFromFile;
        this.byteRange = byteRange;
        this.lineRange = lineRange;
    }

    public SpdxSnippet(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getMyPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.getMyPropertiesFromModel();
    }

    private void getSnippetFromFileFromModel() throws InvalidSPDXAnalysisException {
        SpdxElement snippetFromElement = this.findElementPropertyValue("http://spdx.org/rdf/terms#", "snippetFromFile");
        if (snippetFromElement == null) {
            this.snippetFromFile = null;
        } else {
            if (!(snippetFromElement instanceof SpdxFile)) {
                logger.error("Model contains an SPDX element which is not of type SpdxFile for the snippetFromFile: " + snippetFromElement.getClass().toString());
                throw new InvalidSPDXAnalysisException("Incorect type for the SpdxFile associated with a snippet.");
            }
            this.snippetFromFile = (SpdxFile)snippetFromElement;
        }
    }

    void getMyPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.getSnippetFromFileFromModel();
        this.getRangesFromModel();
    }

    private void getRangesFromModel() throws InvalidSPDXAnalysisException {
        StartEndPointer[] allPointers = this.findStartEndPointerPropertyValues("http://spdx.org/rdf/terms#", "range");
        this.byteRange = null;
        this.lineRange = null;
        StartEndPointer[] startEndPointerArray = allPointers;
        int n = allPointers.length;
        int n2 = 0;
        while (n2 < n) {
            StartEndPointer sep = startEndPointerArray[n2];
            if (sep.getStartPointer() instanceof ByteOffsetPointer) {
                if (!(sep.getEndPointer() instanceof ByteOffsetPointer)) {
                    logger.error("Incompatable start and end pointer types - must both be offset or line types");
                    throw new InvalidSPDXAnalysisException("Incompatable start and end snippet specification - mixing byte and line ranges");
                }
                if (this.byteRange != null) {
                    logger.error("More than one byte offset snippet range specified");
                    throw new InvalidSPDXAnalysisException("More than one byte offset snippet range specified");
                }
                this.byteRange = sep;
            } else if (sep.getStartPointer() instanceof LineCharPointer) {
                if (!(sep.getEndPointer() instanceof LineCharPointer)) {
                    logger.error("Incompatable start and end pointer types - must both be offset or line types");
                    throw new InvalidSPDXAnalysisException("Incompatable start and end snippet specification - mixing byte and line ranges");
                }
                if (this.lineRange != null) {
                    logger.error("More than one byte offset snippet range specified");
                    throw new InvalidSPDXAnalysisException("More than one byte offset snippet range specified");
                }
                this.lineRange = sep;
            }
            ++n2;
        }
    }

    @Override
    public Resource findDuplicateResource(IModelContainer modelContainer, String uri) throws InvalidSPDXAnalysisException {
        if (this.snippetFromFile == null) {
            return null;
        }
        if (this.byteRange == null) {
            return null;
        }
        Resource snippetFromFileResource = SpdxFile.findFileResource(modelContainer, this.snippetFromFile);
        if (snippetFromFileResource == null) {
            return null;
        }
        Model model = modelContainer.getModel();
        Node snippetFromFileProperty = model.getProperty("http://spdx.org/rdf/terms#", "snippetFromFile").asNode();
        Triple fileMatch = Triple.createMatch(null, (Node)snippetFromFileProperty, (Node)snippetFromFileResource.asNode());
        ExtendedIterator fileMatchIter = model.getGraph().find(fileMatch);
        while (fileMatchIter.hasNext()) {
            Triple fileMatchTriple = (Triple)fileMatchIter.next();
            SpdxSnippet localSnippet = new SpdxSnippet(modelContainer, fileMatchTriple.getSubject());
            if (!this.byteRange.equivalent(localSnippet.getByteRange())) continue;
            return model.asRDFNode(fileMatchTriple.getSubject()).asResource();
        }
        return null;
    }

    @Override
    public String getLicenseInfoFromFilesPropertyName() {
        return "licenseInfoInSnippet";
    }

    public SpdxFile getSnippetFromFile() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.getSnippetFromFileFromModel();
        }
        return this.snippetFromFile;
    }

    public void setSnippetFromFile(SpdxFile snippetFromFile) throws InvalidSPDXAnalysisException {
        this.snippetFromFile = snippetFromFile;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "snippetFromFile", snippetFromFile);
        if (this.byteRange != null) {
            if (this.byteRange.getStartPointer() != null) {
                this.byteRange.getStartPointer().setReference(snippetFromFile);
            }
            if (this.byteRange.getEndPointer() != null) {
                this.byteRange.getEndPointer().setReference(snippetFromFile);
            }
        }
        if (this.lineRange != null) {
            if (this.lineRange.getStartPointer() != null) {
                this.lineRange.getStartPointer().setReference(snippetFromFile);
            }
            if (this.lineRange.getEndPointer() != null) {
                this.lineRange.getEndPointer().setReference(snippetFromFile);
            }
        }
    }

    public StartEndPointer getByteRange() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.getRangesFromModel();
        }
        return this.byteRange;
    }

    public void setByteRange(StartEndPointer byteRange) throws InvalidSPDXAnalysisException {
        if (!(byteRange.getStartPointer() instanceof ByteOffsetPointer)) {
            logger.error("Invalid start pointer type for byte offset range.  Must be ByteOffsetPointer");
            throw new InvalidSPDXAnalysisException("Invalid start pointer type for byte offset range.  Must be ByteOffsetPointer");
        }
        if (!(byteRange.getEndPointer() instanceof ByteOffsetPointer)) {
            logger.error("Invalid end pointer type for byte offset range.  Must be ByteOffsetPointer");
            throw new InvalidSPDXAnalysisException("Invalid end pointer type for byte offset range.  Must be ByteOffsetPointer");
        }
        this.byteRange = byteRange;
        this.setRangesInModel();
    }

    private void setRangesInModel() throws InvalidSPDXAnalysisException {
        ArrayList allRanges = Lists.newArrayList();
        if (this.byteRange != null) {
            allRanges.add(this.byteRange);
        }
        if (this.lineRange != null) {
            allRanges.add(this.lineRange);
        }
        this.setPropertyValue("http://spdx.org/rdf/terms#", "range", allRanges.toArray(new StartEndPointer[allRanges.size()]));
    }

    public StartEndPointer getLineRange() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.getRangesFromModel();
        }
        return this.lineRange;
    }

    public void setLineRange(StartEndPointer lineRange) throws InvalidSPDXAnalysisException {
        if (!(lineRange.getStartPointer() instanceof LineCharPointer)) {
            logger.error("Invalid start pointer type for line range.  Must be LineCharPointer");
            throw new InvalidSPDXAnalysisException("Invalid start pointer type for line range.  Must be LineCharPointer");
        }
        if (!(lineRange.getEndPointer() instanceof LineCharPointer)) {
            logger.error("Invalid end pointer type for line range.  Must be LineCharPointer");
            throw new InvalidSPDXAnalysisException("Invalid end pointer type for line range.  Must be LineCharPointer");
        }
        this.lineRange = lineRange;
        this.setRangesInModel();
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyValue("http://spdx.org/rdf/terms#", "snippetFromFile", this.snippetFromFile);
        this.setRangesInModel();
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#Snippet");
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        return this.equivalent(o, true);
    }

    @Override
    public boolean equivalent(IRdfModel o, boolean testRelationships) {
        StartEndPointer myByteRange;
        SpdxFile mySnippetFromFile;
        if (!super.equivalent(o, testRelationships)) {
            return false;
        }
        if (!(o instanceof SpdxSnippet)) {
            return false;
        }
        SpdxSnippet comp = (SpdxSnippet)o;
        SpdxFile compSnippetFromFile = null;
        try {
            compSnippetFromFile = comp.getSnippetFromFile();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting comparison snippet from file", (Throwable)e);
            return false;
        }
        StartEndPointer compByteRange = null;
        try {
            compByteRange = comp.getByteRange();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting comparison byte range", (Throwable)e);
            return false;
        }
        try {
            mySnippetFromFile = this.getSnippetFromFile();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting my snippet from file", (Throwable)e);
            return false;
        }
        try {
            myByteRange = this.getByteRange();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting my byte range", (Throwable)e);
            return false;
        }
        return this.equivalentConsideringNull(mySnippetFromFile, compSnippetFromFile) && this.equivalentConsideringNull(myByteRange, compByteRange);
    }

    @Override
    public SpdxSnippet clone(Map<String, SpdxElement> clonedElementIds) {
        if (clonedElementIds.containsKey(this.getId())) {
            return (SpdxSnippet)clonedElementIds.get(this.getId());
        }
        SpdxSnippet retval = null;
        retval = new SpdxSnippet(this.name, this.comment, this.cloneAnnotations(), null, this.cloneLicenseConcluded(), this.cloneLicenseInfosFromFiles(), this.copyrightText, this.licenseComments, this.cloneSnippetFromFile(clonedElementIds), this.cloneByteRange(), this.cloneLineRange());
        clonedElementIds.put(this.getId(), retval);
        if (retval != null) {
            try {
                retval.setRelationships(this.cloneRelationships(clonedElementIds));
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Unexected error setting relationships during clone", (Throwable)e);
            }
        }
        return retval;
    }

    private StartEndPointer cloneLineRange() {
        if (this.lineRange == null) {
            return null;
        }
        return this.lineRange.clone();
    }

    private SpdxFile cloneSnippetFromFile(Map<String, SpdxElement> clonedElementIds) {
        if (this.snippetFromFile == null) {
            return null;
        }
        return this.snippetFromFile.clone((Map)clonedElementIds);
    }

    private StartEndPointer cloneByteRange() {
        if (this.byteRange == null) {
            return null;
        }
        return this.byteRange.clone();
    }

    @Override
    public SpdxSnippet clone() {
        return this.clone((Map)Maps.newHashMap());
    }

    @Override
    public List<String> verify() {
        List<String> retval = super.verify();
        String snippetName = this.name;
        if (snippetName == null) {
            snippetName = "[Unnamed Snippet]";
        }
        if (this.snippetFromFile == null) {
            retval.add("Missing snippet from file in Snippet " + snippetName);
        } else {
            retval.addAll(this.snippetFromFile.verify());
        }
        if (this.byteRange == null) {
            retval.add("Missing snippet byte range from Snippet " + snippetName);
        } else {
            retval.addAll(this.byteRange.verify());
        }
        if (this.lineRange != null) {
            retval.addAll(this.lineRange.verify());
        }
        return retval;
    }

    @Override
    public int compareTo(SpdxSnippet o) {
        int retval;
        block9: {
            block8: {
                try {
                    if (o != null) break block8;
                    return 1;
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.error("Error getting compare for snippet", (Throwable)e);
                    return -1;
                }
            }
            retval = 0;
            if (this.name != null) {
                retval = this.name.compareTo(o.getName());
            }
            if (retval == 0 && this.snippetFromFile != null) {
                retval = this.snippetFromFile.compareTo(o.getSnippetFromFile());
            }
            if (retval != 0) break block9;
            if (this.byteRange != null) {
                return this.byteRange.compareTo(o.getByteRange());
            }
            if (o.getByteRange() == null) {
                return 0;
            }
            return 1;
        }
        return retval;
    }

    @Override
    public String toString() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder();
        if (this.snippetFromFile != null) {
            String fileName = this.snippetFromFile.getName();
            if (fileName != null && !fileName.isEmpty()) {
                sb.append(fileName);
            } else if (this.snippetFromFile.getId() != null && !this.snippetFromFile.getId().isEmpty()) {
                sb.append("FileID ");
                sb.append(this.snippetFromFile.getId());
            } else {
                sb.append("[Unnamed File]");
            }
            sb.append(": ");
        }
        if (this.byteRange != null) {
            sb.append(this.byteRange.toString());
        } else {
            sb.append("[No byte range set]");
        }
        return sb.toString();
    }
}

