/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheet;

public class NonStandardLicensesSheetV0d9d4
extends NonStandardLicensesSheet {
    static final int NUM_COLS = 2;
    static final int IDENTIFIER_COL = 0;
    static final int EXTRACTED_TEXT_COL = 1;
    static boolean[] REQUIRED = new boolean[]{true, true};
    static final String[] HEADER_TITLES = new String[]{"Identifier", "Extracted Text"};
    static final int[] COLUMN_WIDTHS = new int[]{15, 120};
    static final boolean[] LEFT_WRAP = new boolean[2];
    static final boolean[] CENTER_NOWRAP;

    static {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        CENTER_NOWRAP = blArray;
    }

    public NonStandardLicensesSheetV0d9d4(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName, version);
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for non-standard Licenses does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 2) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for non-standard Licenses worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying non-standard License work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 2) {
            Cell cell = row.getCell(i);
            if (cell == null && REQUIRED[i]) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            ++i;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    public void add(String identifier, String extractedText) {
        Row row = this.addRow();
        Cell idCell = row.createCell(0);
        idCell.setCellValue(identifier);
        Cell extractedTextCell = row.createCell(1);
        extractedTextCell.setCellValue(extractedText);
    }

    @Override
    public String getIdentifier(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell idCell = row.getCell(0);
        if (idCell == null) {
            return null;
        }
        return idCell.getStringCellValue();
    }

    @Override
    public String getExtractedText(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell extractedTextCell = row.getCell(1);
        if (extractedTextCell == null) {
            return null;
        }
        return extractedTextCell.getStringCellValue();
    }

    @Override
    public void add(String identifier, String extractedText, String licenseName, String[] crossRefUrls, String comment) {
        this.add(identifier, extractedText);
    }

    @Override
    public String getLicenseName(int rowNum) {
        return null;
    }

    @Override
    public String[] getCrossRefUrls(int rowNum) {
        return null;
    }

    @Override
    public String getComment(int rowNum) {
        return null;
    }
}

