/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.rdfparser.model.pointer.ByteOffsetPointer;
import org.spdx.rdfparser.model.pointer.LineCharPointer;
import org.spdx.rdfparser.model.pointer.SinglePointer;
import org.spdx.rdfparser.model.pointer.StartEndPointer;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class SnippetSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger(SnippetSheet.class);
    static final int ID_COL = 0;
    static final int NAME_COL = 1;
    static final int SNIPPET_FROM_FILE_ID_COL = 2;
    static final int BYTE_RANGE_COL = 3;
    static final int LINE_RANGE_COL = 4;
    static final int CONCLUDED_LICENSE_COL = 5;
    static final int LICENSE_INFO_IN_SNIPPET_COL = 6;
    static final int LICENSE_COMMENT_COL = 7;
    static final int COPYRIGHT_COL = 8;
    static final int COMMENT_COL = 9;
    static final int USER_DEFINED_COLS = 10;
    static final int NUM_COLS = 11;
    static final boolean[] REQUIRED;
    static final String[] HEADER_TITLES;
    static final int[] COLUMN_WIDTHS;
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;
    private static Pattern NUMBER_RANGE_PATTERN;
    Map<String, SpdxSnippet> snippetCache = Maps.newHashMap();

    static {
        boolean[] blArray = new boolean[11];
        blArray[0] = true;
        blArray[2] = true;
        blArray[3] = true;
        REQUIRED = blArray;
        HEADER_TITLES = new String[]{"ID", "Name", "From File ID", "Byte Range", "Line Range", "License Concluded", "License Info in Snippet", "License Comments", "Snippet Copyright Text", "Comment", "User Defined Columns..."};
        COLUMN_WIDTHS = new int[]{25, 25, 25, 40, 40, 60, 60, 60, 60, 60, 40};
        boolean[] blArray2 = new boolean[11];
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        LEFT_WRAP = blArray2;
        boolean[] blArray3 = new boolean[11];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        CENTER_NOWRAP = blArray3;
        NUMBER_RANGE_PATTERN = Pattern.compile("(\\d+):(\\d+)");
    }

    public SnippetSheet(Workbook workbook, String snippetSheetName) {
        super(workbook, snippetSheetName);
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for SPDX Snippets does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 10) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for SPDX Snippet worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.getFirstDataRow();
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Snippet work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 11) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (REQUIRED[i]) {
                    return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
                }
            } else {
                String range;
                if (i == 5) {
                    try {
                        LicenseInfoFactory.parseSPDXLicenseString(cell.getStringCellValue(), null);
                    }
                    catch (SpreadsheetException ex) {
                        return "Invalid asserted license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
                    }
                }
                if (!(i != 3 && i != 4 || (range = cell.getStringCellValue()) == null || range.isEmpty())) {
                    Matcher rangeMatcher = NUMBER_RANGE_PATTERN.matcher(cell.getStringCellValue());
                    if (!rangeMatcher.matches()) {
                        return "Invalid range for " + HEADER_TITLES[i] + ": " + cell.getStringCellValue();
                    }
                    int start = 0;
                    int end = 0;
                    try {
                        start = Integer.parseInt(rangeMatcher.group(1));
                        end = Integer.parseInt(rangeMatcher.group(2));
                        if (start >= end) {
                            return "Invalid range for " + HEADER_TITLES[i] + ": " + cell.getStringCellValue() + ".  End is not greater than or equal to the end.";
                        }
                    }
                    catch (Exception ex) {
                        return "Invalid range for " + HEADER_TITLES[i] + ": " + cell.getStringCellValue();
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    public void add(SpdxSnippet snippet) throws SpreadsheetException {
        AnyLicenseInfo[] licenseInfoFromSnippet;
        StartEndPointer lineRange;
        StartEndPointer byteRange;
        SpdxFile snippetFromFile;
        Row row = this.addRow();
        if (snippet.getId() != null && !snippet.getId().isEmpty()) {
            row.createCell(0).setCellValue(snippet.getId());
        }
        if (snippet.getName() != null && !snippet.getName().isEmpty()) {
            row.createCell(1).setCellValue(snippet.getName());
        }
        try {
            snippetFromFile = snippet.getSnippetFromFile();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting the snippetFromFile", (Throwable)e);
            throw new SpreadsheetException("Unable to get the Snippet from File from the Snippet: " + e.getMessage());
        }
        if (snippetFromFile != null && snippetFromFile.getId() != null) {
            row.createCell(2).setCellValue(snippetFromFile.getId());
        }
        try {
            byteRange = snippet.getByteRange();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting the byteRange", (Throwable)e);
            throw new SpreadsheetException("Unable to get the byte range from the Snippet: " + e.getMessage());
        }
        if (byteRange != null) {
            try {
                row.createCell(3).setCellValue(this.rangeToStr(byteRange));
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid byte range", (Throwable)e);
                throw new SpreadsheetException("Invalid byte range: " + e.getMessage());
            }
        }
        try {
            lineRange = snippet.getLineRange();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting the lineRange", (Throwable)e);
            throw new SpreadsheetException("Unable to get the line range from the Snippet: " + e.getMessage());
        }
        if (lineRange != null) {
            try {
                row.createCell(4).setCellValue(this.rangeToStr(lineRange));
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid line range", (Throwable)e);
                throw new SpreadsheetException("Invalid line range: " + e.getMessage());
            }
        }
        if (snippet.getLicenseConcluded() != null) {
            row.createCell(5).setCellValue(snippet.getLicenseConcluded().toString());
        }
        if ((licenseInfoFromSnippet = snippet.getLicenseInfoFromFiles()) != null && licenseInfoFromSnippet.length > 0) {
            row.createCell(6).setCellValue(PackageInfoSheet.licensesToString(licenseInfoFromSnippet));
        }
        if (snippet.getLicenseComments() != null) {
            row.createCell(7).setCellValue(snippet.getLicenseComments());
        }
        if (snippet.getCopyrightText() != null) {
            row.createCell(8).setCellValue(snippet.getCopyrightText());
        }
        if (snippet.getComment() != null) {
            row.createCell(9).setCellValue(snippet.getComment());
        }
        this.snippetCache.put(snippet.getId(), snippet);
    }

    private String rangeToStr(StartEndPointer rangePointer) throws InvalidSPDXAnalysisException {
        SinglePointer startPointer = rangePointer.getStartPointer();
        if (startPointer == null) {
            throw new InvalidSPDXAnalysisException("Missing start pointer");
        }
        SinglePointer endPointer = rangePointer.getEndPointer();
        if (endPointer == null) {
            throw new InvalidSPDXAnalysisException("Missing end pointer");
        }
        String start = null;
        if (startPointer instanceof ByteOffsetPointer) {
            start = String.valueOf(((ByteOffsetPointer)startPointer).getOffset());
        } else if (startPointer instanceof LineCharPointer) {
            start = String.valueOf(((LineCharPointer)startPointer).getLineNumber());
        } else {
            logger.error("Unknown pointer type for start pointer " + startPointer.toString());
            throw new InvalidSPDXAnalysisException("Unknown pointer type for start pointer");
        }
        String end = null;
        if (endPointer instanceof ByteOffsetPointer) {
            end = String.valueOf(((ByteOffsetPointer)endPointer).getOffset());
        } else if (endPointer instanceof LineCharPointer) {
            end = String.valueOf(((LineCharPointer)endPointer).getLineNumber());
        } else {
            logger.error("Unknown pointer type for start pointer " + startPointer.toString());
            throw new InvalidSPDXAnalysisException("Unknown pointer type for start pointer");
        }
        return String.valueOf(start) + ":" + end;
    }

    public SpdxSnippet getSnippet(int rowNum, SpdxDocumentContainer container) throws SpreadsheetException {
        String range;
        String range2;
        if (this.sheet == null) {
            return null;
        }
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String id = null;
        if (row.getCell(0) != null) {
            id = row.getCell(0).getStringCellValue();
        }
        if (this.snippetCache.containsKey(id)) {
            return this.snippetCache.get(id);
        }
        String name = null;
        if (row.getCell(1) != null) {
            name = row.getCell(1).getStringCellValue();
        }
        StartEndPointer byteRange = null;
        if (row.getCell(3) != null && (range2 = row.getCell(3).getStringCellValue()) != null && !range2.isEmpty()) {
            int start = 0;
            int end = 0;
            Matcher rangeMatcher = NUMBER_RANGE_PATTERN.matcher(range2);
            if (!rangeMatcher.matches()) {
                throw new SpreadsheetException("Invalid byte range: " + range2);
            }
            try {
                start = Integer.parseInt(rangeMatcher.group(1));
                end = Integer.parseInt(rangeMatcher.group(2));
            }
            catch (Exception ex) {
                throw new SpreadsheetException("Invalid byte range: " + range2);
            }
            ByteOffsetPointer startPointer = new ByteOffsetPointer(null, start);
            ByteOffsetPointer endPointer = new ByteOffsetPointer(null, end);
            byteRange = new StartEndPointer(startPointer, endPointer);
        }
        StartEndPointer lineRange = null;
        if (row.getCell(4) != null && (range = row.getCell(4).getStringCellValue()) != null && !range.isEmpty()) {
            int start = 0;
            int end = 0;
            Matcher rangeMatcher = NUMBER_RANGE_PATTERN.matcher(range);
            if (!rangeMatcher.matches()) {
                throw new SpreadsheetException("Invalid line range: " + range);
            }
            try {
                start = Integer.valueOf(rangeMatcher.group(1));
                end = Integer.valueOf(rangeMatcher.group(2));
            }
            catch (Exception ex) {
                throw new SpreadsheetException("Invalid line range: " + range);
            }
            LineCharPointer startPointer = new LineCharPointer(null, start);
            LineCharPointer endPointer = new LineCharPointer(null, end);
            lineRange = new StartEndPointer(startPointer, endPointer);
        }
        AnyLicenseInfo concludedLicense = null;
        Cell concludedLicenseCell = row.getCell(5);
        concludedLicense = concludedLicenseCell != null && !concludedLicenseCell.getStringCellValue().isEmpty() ? LicenseInfoFactory.parseSPDXLicenseString(concludedLicenseCell.getStringCellValue(), container) : null;
        AnyLicenseInfo[] seenLicenses = new AnyLicenseInfo[]{};
        Cell seenLicenseCell = row.getCell(6);
        if (seenLicenseCell != null && !seenLicenseCell.getStringCellValue().isEmpty()) {
            String[] licenseStrings = seenLicenseCell.getStringCellValue().split(",");
            seenLicenses = new AnyLicenseInfo[licenseStrings.length];
            int i = 0;
            while (i < licenseStrings.length) {
                seenLicenses[i] = LicenseInfoFactory.parseSPDXLicenseString(licenseStrings[i].trim(), container);
                ++i;
            }
        } else {
            seenLicenses = null;
        }
        String licenseComments = null;
        Cell licCommentCell = row.getCell(7);
        licenseComments = licCommentCell != null ? licCommentCell.getStringCellValue() : "";
        Cell copyrightCell = row.getCell(8);
        String copyright = copyrightCell != null ? copyrightCell.getStringCellValue() : "";
        String comment = null;
        Cell commentCell = row.getCell(9);
        if (commentCell != null) {
            comment = commentCell.getStringCellValue();
        }
        String snippetFromFileId = this.getSnippetFileId(rowNum);
        SpdxFile snippetFromFile = null;
        if (snippetFromFileId != null && !snippetFromFileId.isEmpty()) {
            try {
                SpdxElement fromFileElement = container.findElementById(snippetFromFileId);
                if (fromFileElement instanceof SpdxFile) {
                    snippetFromFile = (SpdxFile)fromFileElement;
                    if (byteRange != null) {
                        byteRange.getStartPointer().setReference(snippetFromFile);
                        byteRange.getEndPointer().setReference(snippetFromFile);
                    }
                    if (lineRange != null) {
                        lineRange.getStartPointer().setReference(snippetFromFile);
                        lineRange.getEndPointer().setReference(snippetFromFile);
                    }
                } else {
                    logger.warn("Element associated with the snippetFromFile is not of type SPDX File.  Null will be used");
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.warn("Error getting snipet from file by ID.  snippetFromFile will be set to null");
            }
        }
        SpdxSnippet retval = new SpdxSnippet(name, comment, new Annotation[0], new Relationship[0], concludedLicense, seenLicenses, copyright, licenseComments, snippetFromFile, byteRange, lineRange);
        try {
            retval.setId(id);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error setting ID for SpdxSnippet", (Throwable)e);
            throw new SpreadsheetException("Error setting ID for SpdxSnippet: " + e.getMessage());
        }
        this.snippetCache.put(id, retval);
        return retval;
    }

    public String getSnippetFileId(int rowNum) throws SpreadsheetException {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String id = null;
        if (row.getCell(2) != null) {
            id = row.getCell(2).getStringCellValue();
        }
        return id;
    }
}

