/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.rdfparser.model.pointer.ByteOffsetPointer;
import org.spdx.rdfparser.model.pointer.LineCharPointer;
import org.spdx.rdfparser.model.pointer.StartEndPointer;
import org.spdx.rdfparser.referencetype.ListedReferenceTypes;
import org.spdx.tools.RdfToTag;

public class CommonCode {
    public static void printDoc(SpdxDocument doc, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        SPDXReview[] reviewedBy;
        int i;
        int i2;
        String docNamespace;
        AnyLicenseInfo dataLicense;
        if (doc == null) {
            CommonCode.println(out, "Warning: No document to print");
            return;
        }
        String spdxVersion = "";
        if (doc.getSpecVersion() != null && doc.getCreationInfo().getCreated() != null) {
            spdxVersion = doc.getSpecVersion();
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SPDX_VERSION")) + spdxVersion);
        }
        if (!spdxVersion.equals("SPDX-0.8") && !spdxVersion.equals("SPDX-0.9") && (dataLicense = doc.getDataLicense()) != null) {
            if (dataLicense instanceof SimpleLicensingInfo) {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SPDX_DATA_LICENSE")) + ((SimpleLicensingInfo)dataLicense).getLicenseId());
            } else {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SPDX_DATA_LICENSE")) + dataLicense.toString());
            }
        }
        if ((docNamespace = doc.getDocumentNamespace()) != null && !docNamespace.isEmpty()) {
            out.println(String.valueOf(constants.getProperty("PROP_DOCUMENT_NAMESPACE")) + docNamespace);
        }
        CommonCode.printElementProperties(doc, out, constants, "PROP_DOCUMENT_NAME", "PROP_SPDX_COMMENT");
        CommonCode.println(out, "");
        ExternalDocumentRef[] externalRefs = doc.getExternalDocumentRefs();
        if (externalRefs != null && externalRefs.length > 0) {
            String externalDocRefHedr = constants.getProperty("EXTERNAL_DOC_REFS_HEADER");
            if (externalDocRefHedr != null && !externalDocRefHedr.isEmpty()) {
                CommonCode.println(out, externalDocRefHedr);
            }
            i2 = 0;
            while (i2 < externalRefs.length) {
                CommonCode.printExternalDocumentRef(externalRefs[i2], out, constants);
                ++i2;
            }
        }
        if (doc.getCreationInfo().getCreators() != null && doc.getCreationInfo().getCreators().length > 0) {
            CommonCode.println(out, constants.getProperty("CREATION_INFO_HEADER"));
            String[] creators = doc.getCreationInfo().getCreators();
            i2 = 0;
            while (i2 < creators.length) {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_CREATION_CREATOR")) + creators[i2]);
                ++i2;
            }
        }
        if (doc.getCreationInfo().getCreated() != null && !doc.getCreationInfo().getCreated().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_CREATION_CREATED")) + doc.getCreationInfo().getCreated());
        }
        if (doc.getCreationInfo().getComment() != null && !doc.getCreationInfo().getComment().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_CREATION_COMMENT")) + constants.getProperty("PROP_BEGIN_TEXT") + doc.getCreationInfo().getComment() + constants.getProperty("PROP_END_TEXT"));
        }
        if (doc.getCreationInfo().getLicenseListVersion() != null && !doc.getCreationInfo().getLicenseListVersion().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_LICENSE_LIST_VERSION")) + doc.getCreationInfo().getLicenseListVersion());
        }
        CommonCode.printElementAnnotationsRelationships(doc, out, constants, "PROP_DOCUMENT_NAME", "PROP_SPDX_COMMENT");
        CommonCode.println(out, "");
        List<SpdxPackage> allPackages = doc.getDocumentContainer().findAllPackages();
        List<SpdxFile> allFiles = doc.getDocumentContainer().findAllFiles();
        List<SpdxSnippet> allSnippets = doc.getDocumentContainer().findAllSnippets();
        SpdxItem[] items = doc.getDocumentDescribes();
        if (items.length > 0) {
            i = 0;
            while (i < items.length) {
                if (items[i] instanceof SpdxFile) {
                    CommonCode.printFile((SpdxFile)items[i], out, constants);
                    allFiles.remove(items[i]);
                } else if (items[i] instanceof SpdxSnippet) {
                    CommonCode.printSnippet((SpdxSnippet)items[i], out, constants);
                    allSnippets.remove(items[i]);
                }
                ++i;
            }
        }
        if (items.length > 0) {
            i = 0;
            while (i < items.length) {
                if (items[i] instanceof SpdxPackage) {
                    CommonCode.printPackage((SpdxPackage)items[i], out, constants, allFiles, doc.getDocumentNamespace());
                    allPackages.remove(items[i]);
                }
                ++i;
            }
        }
        for (SpdxPackage pkg : allPackages) {
            CommonCode.printPackage(pkg, out, constants, allFiles, doc.getDocumentNamespace());
        }
        for (SpdxFile file : allFiles) {
            CommonCode.printFile(file, out, constants);
        }
        Collections.sort(allSnippets);
        for (SpdxSnippet snippet : allSnippets) {
            CommonCode.printSnippet(snippet, out, constants);
        }
        CommonCode.println(out, "");
        if (doc.getExtractedLicenseInfos() != null && doc.getExtractedLicenseInfos().length > 0) {
            ExtractedLicenseInfo[] nonStandardLic = doc.getExtractedLicenseInfos();
            CommonCode.println(out, constants.getProperty("LICENSE_INFO_HEADER"));
            int i3 = 0;
            while (i3 < nonStandardLic.length) {
                CommonCode.printLicense(nonStandardLic[i3], out, constants);
                ++i3;
            }
        }
        if ((reviewedBy = doc.getReviewers()) != null && reviewedBy.length > 0) {
            CommonCode.println(out, constants.getProperty("REVIEW_INFO_HEADER"));
            int i4 = 0;
            while (i4 < reviewedBy.length) {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_REVIEW_REVIEWER")) + reviewedBy[i4].getReviewer());
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_REVIEW_DATE")) + reviewedBy[i4].getReviewDate());
                if (reviewedBy[i4].getComment() != null && !reviewedBy[i4].getComment().isEmpty()) {
                    CommonCode.println(out, String.valueOf(constants.getProperty("PROP_REVIEW_COMMENT")) + constants.getProperty("PROP_BEGIN_TEXT") + reviewedBy[i4].getComment() + constants.getProperty("PROP_END_TEXT"));
                }
                CommonCode.println(out, "");
                ++i4;
            }
        }
    }

    private static void printSnippet(SpdxSnippet spdxSnippet, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        CommonCode.println(out, constants.getProperty("SNIPPET_HEADER"));
        CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_SPDX_ID")) + spdxSnippet.getId());
        if (spdxSnippet.getSnippetFromFile() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_FROM_FILE_ID")) + spdxSnippet.getSnippetFromFile().getId());
        }
        if (spdxSnippet.getByteRange() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_BYTE_RANGE")) + CommonCode.formatPointerRange(spdxSnippet.getByteRange()));
        }
        if (spdxSnippet.getLineRange() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_LINE_RANGE")) + CommonCode.formatPointerRange(spdxSnippet.getLineRange()));
        }
        if (spdxSnippet.getLicenseConcluded() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_CONCLUDED_LICENSE")) + spdxSnippet.getLicenseConcluded());
        }
        if (spdxSnippet.getLicenseInfoFromFiles() != null) {
            AnyLicenseInfo[] anyLicenseInfoArray = spdxSnippet.getLicenseInfoFromFiles();
            int n = anyLicenseInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnyLicenseInfo seenLicense = anyLicenseInfoArray[n2];
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_SEEN_LICENSE")) + seenLicense);
                ++n2;
            }
        }
        if (spdxSnippet.getLicenseComments() != null && !spdxSnippet.getLicenseComments().trim().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_LIC_COMMENTS")) + spdxSnippet.getLicenseComments());
        }
        if (spdxSnippet.getCopyrightText() != null && !spdxSnippet.getCopyrightText().trim().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_COPYRIGHT")) + spdxSnippet.getCopyrightText());
        }
        if (spdxSnippet.getComment() != null && !spdxSnippet.getComment().trim().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_COMMENT")) + spdxSnippet.getComment());
        }
        if (spdxSnippet.getName() != null && !spdxSnippet.getName().trim().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SNIPPET_NAME")) + spdxSnippet.getName());
        }
        CommonCode.println(out, "");
    }

    private static String formatPointerRange(StartEndPointer pointer) throws InvalidSPDXAnalysisException {
        String start = "[MISSING]";
        String end = "[MISSING]";
        if (pointer.getStartPointer() != null) {
            if (pointer.getStartPointer() instanceof ByteOffsetPointer) {
                start = String.valueOf(((ByteOffsetPointer)pointer.getStartPointer()).getOffset());
            } else if (pointer.getStartPointer() instanceof LineCharPointer) {
                start = String.valueOf(((LineCharPointer)pointer.getStartPointer()).getLineNumber());
            }
        }
        if (pointer.getEndPointer() != null) {
            if (pointer.getEndPointer() instanceof ByteOffsetPointer) {
                end = String.valueOf(((ByteOffsetPointer)pointer.getEndPointer()).getOffset());
            } else if (pointer.getStartPointer() instanceof LineCharPointer) {
                end = String.valueOf(((LineCharPointer)pointer.getEndPointer()).getLineNumber());
            }
        }
        return String.valueOf(start) + ":" + end;
    }

    private static void printExternalDocumentRef(ExternalDocumentRef externalDocumentRef, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        String id;
        String uri = externalDocumentRef.getSpdxDocumentNamespace();
        if (uri == null || uri.isEmpty()) {
            uri = "[UNSPECIFIED]";
        }
        String sha1 = "[UNSPECIFIED]";
        Checksum checksum = externalDocumentRef.getChecksum();
        if (checksum != null && checksum.getValue() != null && !checksum.getValue().isEmpty()) {
            sha1 = checksum.getValue();
        }
        if ((id = externalDocumentRef.getExternalDocumentId()) == null || id.isEmpty()) {
            id = "[UNSPECIFIED]";
        }
        CommonCode.println(out, String.valueOf(constants.getProperty("PROP_EXTERNAL_DOC_URI")) + id + " " + uri + " SHA1: " + sha1);
    }

    private static void printElementProperties(SpdxElement element, PrintWriter out, Properties constants, String nameProperty, String commentProperty) {
        if (element.getName() != null && !element.getName().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty(nameProperty)) + element.getName());
        }
        if (element.getId() != null && !element.getId().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_ELEMENT_ID")) + element.getId());
        }
        if (element.getComment() != null && !element.getComment().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty(commentProperty)) + constants.getProperty("PROP_BEGIN_TEXT") + element.getComment() + constants.getProperty("PROP_END_TEXT"));
        }
    }

    private static void printElementAnnotationsRelationships(SpdxElement element, PrintWriter out, Properties constants, String nameProperty, String commentProperty) {
        Relationship[] relationships;
        Annotation[] annotations = element.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            CommonCode.println(out, constants.getProperty("ANNOTATION_HEADER"));
            int i = 0;
            while (i < annotations.length) {
                CommonCode.printAnnotation(annotations[i], element.getId(), out, constants);
                ++i;
            }
        }
        if ((relationships = element.getRelationships()) != null && relationships.length > 0) {
            CommonCode.println(out, constants.getProperty("RELATIONSHIP_HEADER"));
            int i = 0;
            while (i < relationships.length) {
                CommonCode.printRelationship(relationships[i], element.getId(), out, constants);
                ++i;
            }
        }
    }

    private static void printRelationship(Relationship relationship, String elementId, PrintWriter out, Properties constants) {
        out.println(String.valueOf(constants.getProperty("PROP_RELATIONSHIP")) + elementId + " " + relationship.getRelationshipType().toTag() + " " + relationship.getRelatedSpdxElement().getId());
    }

    private static void printAnnotation(Annotation annotation, String id, PrintWriter out, Properties constants) {
        out.println(String.valueOf(constants.getProperty("PROP_ANNOTATOR")) + annotation.getAnnotator());
        out.println(String.valueOf(constants.getProperty("PROP_ANNOTATION_DATE")) + annotation.getAnnotationDate());
        out.println(String.valueOf(constants.getProperty("PROP_ANNOTATION_COMMENT")) + constants.getProperty("PROP_BEGIN_TEXT") + annotation.getComment() + constants.getProperty("PROP_END_TEXT"));
        out.println(String.valueOf(constants.getProperty("PROP_ANNOTATION_TYPE")) + annotation.getAnnotationType().getTag());
        out.println(String.valueOf(constants.getProperty("PROP_ANNOTATION_ID")) + id);
    }

    private static void printLicense(ExtractedLicenseInfo license, PrintWriter out, Properties constants) {
        if (license.getLicenseId() != null && !license.getLicenseId().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_LICENSE_ID")) + license.getLicenseId());
        }
        if (license.getExtractedText() != null && !license.getExtractedText().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_EXTRACTED_TEXT")) + constants.getProperty("PROP_BEGIN_TEXT") + license.getExtractedText() + constants.getProperty("PROP_END_TEXT"));
        }
        if (license.getName() != null && !license.getName().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_LICENSE_NAME")) + license.getName());
        }
        if (license.getSeeAlso() != null && license.getSeeAlso().length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(license.getSeeAlso()[0]);
            int i = 1;
            while (i < license.getSeeAlso().length) {
                sb.append(", ");
                sb.append(license.getSeeAlso()[i]);
                ++i;
            }
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_SOURCE_URLS")) + sb.toString());
        }
        if (license.getSeeAlso() != null && license.getComment() != null && !license.getComment().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_LICENSE_COMMENT")) + constants.getProperty("PROP_BEGIN_TEXT") + license.getComment() + constants.getProperty("PROP_END_TEXT"));
        }
        CommonCode.println(out, "");
    }

    /*
     * WARNING - void declaration
     */
    private static void printPackage(SpdxPackage pkg, PrintWriter out, Properties constants, List<SpdxFile> remainingFilesToPrint, String documentNamespace) throws InvalidSPDXAnalysisException {
        ExternalRef[] externalRefs;
        String[] attributionText;
        Checksum[] checksums;
        int n2;
        Object[] objectArray;
        CommonCode.println(out, constants.getProperty("PACKAGE_INFO_HEADER"));
        CommonCode.printElementProperties(pkg, out, constants, "PROP_PACKAGE_DECLARED_NAME", "PROP_PACKAGE_COMMENT");
        if (pkg.getVersionInfo() != null && !pkg.getVersionInfo().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_VERSION_INFO")) + pkg.getVersionInfo());
        }
        if (pkg.getPackageFileName() != null && !pkg.getPackageFileName().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_FILE_NAME")) + pkg.getPackageFileName());
        }
        if (pkg.getSupplier() != null && !pkg.getSupplier().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_SUPPLIER")) + pkg.getSupplier());
        }
        if (pkg.getOriginator() != null && !pkg.getOriginator().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_ORIGINATOR")) + pkg.getOriginator());
        }
        if (pkg.getDownloadLocation() != null && !pkg.getDownloadLocation().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL")) + pkg.getDownloadLocation());
        }
        if (pkg.getPackageVerificationCode() != null && pkg.getPackageVerificationCode().getValue() != null && !pkg.getPackageVerificationCode().getValue().isEmpty()) {
            String code = String.valueOf(constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE")) + pkg.getPackageVerificationCode().getValue();
            String[] excludedFiles = pkg.getPackageVerificationCode().getExcludedFileNames();
            if (excludedFiles.length != 0) {
                void var9_15;
                StringBuilder excludedFilesBuilder = new StringBuilder("(");
                objectArray = excludedFiles;
                n2 = excludedFiles.length;
                boolean n = false;
                while (var9_15 < n2) {
                    String excludedFile = objectArray[var9_15];
                    if (excludedFilesBuilder.length() > 0) {
                        excludedFilesBuilder.append(", ");
                    }
                    excludedFilesBuilder.append(excludedFile);
                    ++var9_15;
                }
                excludedFilesBuilder.append(')');
                code = String.valueOf(code) + excludedFilesBuilder.toString();
            }
            CommonCode.println(out, code);
        }
        if ((checksums = pkg.getChecksums()) != null && checksums.length > 0) {
            int i = 0;
            while (i < checksums.length) {
                CommonCode.printChecksum(checksums[i], out, constants, "PROP_PACKAGE_CHECKSUM");
                ++i;
            }
        }
        if (pkg.getHomepage() != null && !pkg.getHomepage().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL")) + pkg.getHomepage());
        }
        if (pkg.getSourceInfo() != null && !pkg.getSourceInfo().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_SOURCE_INFO")) + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getSourceInfo() + constants.getProperty("PROP_END_TEXT"));
        }
        if (pkg.getLicenseConcluded() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE")) + pkg.getLicenseConcluded());
        }
        if (pkg.getLicenseInfoFromFiles() != null && pkg.getLicenseInfoFromFiles().length > 0) {
            AnyLicenseInfo[] licenses = pkg.getLicenseInfoFromFiles();
            CommonCode.println(out, constants.getProperty("LICENSE_FROM_FILES_INFO_HEADER"));
            int i = 0;
            while (i < licenses.length) {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES")) + licenses[i].toString());
                ++i;
            }
        }
        if (pkg.getLicenseDeclared() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE")) + pkg.getLicenseDeclared());
        }
        if (pkg.getLicenseComments() != null && !pkg.getLicenseComments().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT")) + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getLicenseComments() + constants.getProperty("PROP_END_TEXT"));
        }
        if (pkg.getCopyrightText() != null && !pkg.getCopyrightText().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT")) + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getCopyrightText() + constants.getProperty("PROP_END_TEXT"));
        }
        if (pkg.getSummary() != null && !pkg.getSummary().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_SHORT_DESC")) + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getSummary() + constants.getProperty("PROP_END_TEXT"));
        }
        if (pkg.getDescription() != null && !pkg.getDescription().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_DESCRIPTION")) + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getDescription() + constants.getProperty("PROP_END_TEXT"));
        }
        if ((attributionText = pkg.getAttributionText()) != null) {
            String[] stringArray = attributionText;
            int n = attributionText.length;
            int excludedFile = 0;
            while (excludedFile < n) {
                String att = stringArray[excludedFile];
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_ATTRIBUTION_TEXT")) + constants.getProperty("PROP_BEGIN_TEXT") + att + constants.getProperty("PROP_END_TEXT"));
                ++excludedFile;
            }
        }
        if ((externalRefs = pkg.getExternalRefs()) != null && externalRefs.length > 0) {
            void var9_18;
            objectArray = externalRefs;
            n2 = externalRefs.length;
            boolean bl = false;
            while (var9_18 < n2) {
                Object externalRef = objectArray[var9_18];
                CommonCode.printExternalRef(out, constants, (ExternalRef)externalRef, documentNamespace);
                ++var9_18;
            }
        }
        CommonCode.printElementAnnotationsRelationships(pkg, out, constants, "PROP_PACKAGE_DECLARED_NAME", "PROP_PACKAGE_COMMENT");
        if (!pkg.isFilesAnalyzed()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PACKAGE_FILES_ANALYZED")) + "false");
        }
        if (pkg.getFiles() != null && pkg.getFiles().length > 0) {
            List<Object> sortedFileList = Lists.newArrayList();
            sortedFileList = Arrays.asList(pkg.getFiles());
            Collections.sort(sortedFileList);
            CommonCode.println(out, "");
            CommonCode.println(out, constants.getProperty("FILE_INFO_HEADER"));
            for (SpdxFile spdxFile : sortedFileList) {
                CommonCode.printFile(spdxFile, out, constants);
                remainingFilesToPrint.remove(spdxFile);
                CommonCode.println(out, "");
            }
        } else {
            CommonCode.println(out, "");
        }
    }

    private static void printExternalRef(PrintWriter out, Properties constants, ExternalRef externalRef, String docNamespace) throws InvalidSPDXAnalysisException {
        String category = null;
        category = externalRef.getReferenceCategory() == null ? "OTHER" : externalRef.getReferenceCategory().getTag();
        String referenceType = null;
        if (externalRef.getReferenceType() == null || externalRef.getReferenceType().getReferenceTypeUri() == null) {
            referenceType = "[MISSING]";
        } else {
            try {
                referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(externalRef.getReferenceType().getReferenceTypeUri());
            }
            catch (InvalidSPDXAnalysisException e) {
                referenceType = null;
            }
            if (referenceType == null && (referenceType = externalRef.getReferenceType().getReferenceTypeUri().toString()).startsWith(String.valueOf(docNamespace) + "#")) {
                referenceType = referenceType.substring(docNamespace.length() + 1);
            }
        }
        String referenceLocator = externalRef.getReferenceLocator();
        if (referenceLocator == null) {
            referenceLocator = "[MISSING]";
        }
        CommonCode.println(out, String.valueOf(constants.getProperty("PROP_EXTERNAL_REFERENCE")) + category + " " + referenceType + " " + referenceLocator);
        if (externalRef.getComment() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_EXTERNAL_REFERENCE_COMMENT")) + externalRef.getComment());
        }
    }

    private static void printChecksum(Checksum checksum, PrintWriter out, Properties constants, String checksumProperty) {
        out.println(String.valueOf(constants.getProperty(checksumProperty)) + (String)Checksum.CHECKSUM_ALGORITHM_TO_TAG.get((Object)checksum.getAlgorithm()) + " " + checksum.getValue());
    }

    private static void printFile(SpdxFile file, PrintWriter out, Properties constants) {
        SpdxFile[] fileDependencies;
        int n;
        String[] attributionText;
        int i;
        Checksum[] checksums;
        CommonCode.printElementProperties(file, out, constants, "PROP_FILE_NAME", "PROP_FILE_COMMENT");
        SpdxFile.FileType[] fileTypes = file.getFileTypes();
        if (fileTypes != null && fileTypes.length > 0) {
            int i2 = 0;
            while (i2 < fileTypes.length) {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_TYPE")) + SpdxFile.FILE_TYPE_TO_TAG.get((Object)fileTypes[i2]));
                ++i2;
            }
        }
        if ((checksums = file.getChecksums()) != null) {
            i = 0;
            while (i < checksums.length) {
                CommonCode.printChecksum(checksums[i], out, constants, "PROP_FILE_CHECKSUM");
                ++i;
            }
        }
        if (file.getLicenseConcluded() != null) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_LICENSE")) + file.getLicenseConcluded().toString());
        }
        if (file.getLicenseInfoFromFiles() != null && file.getLicenseInfoFromFiles().length > 0) {
            i = 0;
            while (i < file.getLicenseInfoFromFiles().length) {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_SEEN_LICENSE")) + file.getLicenseInfoFromFiles()[i].toString());
                ++i;
            }
        }
        if (file.getLicenseComments() != null && !file.getLicenseComments().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_LIC_COMMENTS")) + file.getLicenseComments());
        }
        if (file.getCopyrightText() != null && !file.getCopyrightText().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_COPYRIGHT")) + constants.getProperty("PROP_BEGIN_TEXT") + file.getCopyrightText() + constants.getProperty("PROP_END_TEXT"));
        }
        if (file.getArtifactOf() != null && file.getArtifactOf().length > 0) {
            i = 0;
            while (i < file.getArtifactOf().length) {
                CommonCode.printProject(file.getArtifactOf()[i], out, constants);
                ++i;
            }
        }
        if (file.getNoticeText() != null && !file.getNoticeText().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_NOTICE_TEXT")) + constants.getProperty("PROP_BEGIN_TEXT") + file.getNoticeText() + constants.getProperty("PROP_END_TEXT"));
        }
        if ((attributionText = file.getAttributionText()) != null) {
            String[] stringArray = attributionText;
            n = attributionText.length;
            int n2 = 0;
            while (n2 < n) {
                String att = stringArray[n2];
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_ATTRIBUTION_TEXT")) + constants.getProperty("PROP_BEGIN_TEXT") + att + constants.getProperty("PROP_END_TEXT"));
                ++n2;
            }
        }
        if (file.getFileContributors() != null && file.getFileContributors().length > 0) {
            int i3 = 0;
            while (i3 < file.getFileContributors().length) {
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_CONTRIBUTOR")) + file.getFileContributors()[i3]);
                ++i3;
            }
        }
        if ((fileDependencies = file.getFileDependencies()) != null && fileDependencies.length > 0) {
            SpdxFile[] spdxFileArray = fileDependencies;
            int n3 = fileDependencies.length;
            n = 0;
            while (n < n3) {
                SpdxFile fileDepdency = spdxFileArray[n];
                CommonCode.println(out, String.valueOf(constants.getProperty("PROP_FILE_DEPENDENCY")) + fileDepdency.getName());
                ++n;
            }
        }
        CommonCode.printElementAnnotationsRelationships(file, out, constants, "PROP_FILE_NAME", "PROP_FILE_COMMENT");
    }

    private static void printProject(DoapProject doapProject, PrintWriter out, Properties constants) {
        if (doapProject.getName() != null && !doapProject.getName().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PROJECT_NAME")) + doapProject.getName());
        }
        if (doapProject.getHomePage() != null && !doapProject.getHomePage().isEmpty()) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PROJECT_HOMEPAGE")) + doapProject.getHomePage());
        }
        if (doapProject.getProjectUri() != null && !doapProject.getProjectUri().isEmpty() && !doapProject.getProjectUri().equals("UNKNOWN")) {
            CommonCode.println(out, String.valueOf(constants.getProperty("PROP_PROJECT_URI")) + doapProject.getProjectUri());
        }
    }

    private static void println(PrintWriter out, String output) {
        if (out != null) {
            out.println(output);
        } else {
            System.out.println(output);
        }
    }

    public static Properties getTextFromProperties(String path) throws IOException {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = RdfToTag.class.getClassLoader().getResourceAsStream(path);
            prop.load(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return prop;
    }
}

