/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.spdx.html.MustacheMap;
import org.spdx.html.PackageContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.tools.OnlineToolException;

public class RdfToHtml {
    static final String SPDX_DOCUMENT_HTML_TEMPLATE = "SpdxDocHTMLTemplate.html";
    static final String SPDX_PACKAGE_HTML_TEMPLATE = "PackageHTMLTemplate.html";
    static final String SPDX_FILE_HTML_TEMPLATE = "FilesHTMLTemplate.html";
    static final String SPDX_SNIPPET_HTML_TEMPLATE = "SnippetHTMLTemplate.html";
    static final String SPDX_LICENSE_HTML_TEMPLATE = "LicensesHTMLTemplate.html";
    private static final String TEMPLATE_CLASS_PATH = "resources/htmlTemplate";
    private static volatile Path templateRootPath = null;
    static final String DOC_HTML_FILE_POSTFIX = "-document.html";
    static final String LICENSE_HTML_FILE_POSTFIX = "-extractedlicenses.html";
    static final String PACKAGE_HTML_FILE_POSTFIX = "-package.html";
    static final String PACKAGE_FILE_HTML_FILE_POSTFIX = "-packagefiles.html";
    static final String DOCUMENT_FILE_HTML_FILE_POSTFIX = "-documentfiles.html";
    static final String SNIPPET_FILE_NAME = "snippets.html";
    private static final Escaper HTML_LINEBREAK_ESCAPER = Escapers.builder().addEscape('\"', "&quot;").addEscape('\'', "&#39;").addEscape('&', "&amp;").addEscape('<', "&lt;").addEscape('>', "&gt;").addEscape('\n', "<br />").build();
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    static final int ERROR = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void initialize() {
        if (templateRootPath != null) {
            return;
        }
        if (Files.isDirectory(Paths.get("resources", "htmlTemplate"), new LinkOption[0])) {
            templateRootPath = Paths.get("resources", "htmlTemplate");
            return;
        }
        try {
            templateRootPath = Files.createTempDirectory("spdx-tools-html-template", new FileAttribute[0]);
            templateRootPath.toFile().deleteOnExit();
            String[] stringArray = new String[]{SPDX_DOCUMENT_HTML_TEMPLATE, SPDX_PACKAGE_HTML_TEMPLATE, SPDX_FILE_HTML_TEMPLATE, SPDX_SNIPPET_HTML_TEMPLATE, SPDX_LICENSE_HTML_TEMPLATE};
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                block19: {
                    if (n2 >= n) {
                        return;
                    }
                    String file = stringArray[n2];
                    Path outputPath = templateRootPath.resolve(file);
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try {
                        InputStream is = RdfToHtml.class.getClassLoader().getResourceAsStream("resources/htmlTemplate/" + file);
                        try {
                            try (OutputStream os = Files.newOutputStream(outputPath, StandardOpenOption.CREATE_NEW);){
                                IOUtils.copy((InputStream)is, (OutputStream)os);
                            }
                            if (is == null) break block19;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (is == null) throw throwable;
                            is.close();
                            throw throwable;
                        }
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to extract HTML template files", e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            RdfToHtml.usage();
            System.exit(1);
        }
        if (args.length > 2) {
            System.out.println("Warning: Extra arguments will be ignored");
            RdfToHtml.usage();
        }
        try {
            RdfToHtml.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public static List<String> onlineFunction(String[] args) throws OnlineToolException {
        File spdxFile;
        if (templateRootPath == null) {
            RdfToHtml.initialize();
        }
        if (!(spdxFile = new File(args[0])).exists()) {
            throw new OnlineToolException("SPDX file " + args[0] + " does not exists.");
        }
        if (!spdxFile.canRead()) {
            throw new OnlineToolException("Can not read SPDX File " + args[0] + ".  Check permissions on the file.");
        }
        File outputDirectory = new File(args[1]);
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new OnlineToolException("Unable to create output directory");
        }
        SpdxDocument doc = null;
        try {
            doc = SPDXDocumentFactory.createSpdxDocument(args[0]);
        }
        catch (IOException e2) {
            throw new OnlineToolException("IO Error creating the SPDX document");
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new OnlineToolException("Invalid SPDX Document: " + e2.getMessage());
        }
        catch (Exception e) {
            throw new OnlineToolException("Error creating SPDX Document: " + e.getMessage(), e);
        }
        List<Object> verify = new ArrayList();
        verify = doc.verify();
        if (verify != null && verify.size() > 0) {
            System.out.println("Warning: The following verifications failed for the resultant SPDX RDF file:");
            int i = 0;
            while (i < verify.size()) {
                System.out.println("\t" + (String)verify.get(i));
                ++i;
            }
        }
        String documentName = doc.getName();
        ArrayList filesToCreate = Lists.newArrayList();
        String docHtmlFilePath = String.valueOf(outputDirectory.getPath()) + File.separator + documentName + DOC_HTML_FILE_POSTFIX;
        File docHtmlFile = new File(docHtmlFilePath);
        filesToCreate.add(docHtmlFile);
        String snippetHtmlFilePath = String.valueOf(outputDirectory.getPath()) + File.separator + SNIPPET_FILE_NAME;
        File snippetHtmlFile = new File(snippetHtmlFilePath);
        filesToCreate.add(snippetHtmlFile);
        String licenseHtmlFilePath = String.valueOf(outputDirectory.getPath()) + File.separator + documentName + LICENSE_HTML_FILE_POSTFIX;
        File licenseHtmlFile = new File(licenseHtmlFilePath);
        filesToCreate.add(licenseHtmlFile);
        String docFilesHtmlFilePath = String.valueOf(outputDirectory.getPath()) + File.separator + documentName + DOCUMENT_FILE_HTML_FILE_POSTFIX;
        File docFilesHtmlFile = new File(docFilesHtmlFilePath);
        filesToCreate.add(docFilesHtmlFile);
        List<SpdxPackage> pkgs = null;
        try {
            pkgs = doc.getDocumentContainer().findAllPackages();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new OnlineToolException("Error getting packages from the SPDX document: " + e1.getMessage());
        }
        Iterator<SpdxPackage> iter = pkgs.iterator();
        while (iter.hasNext()) {
            String packageName = iter.next().getName();
            String packageHtmlFilePath = String.valueOf(outputDirectory.getPath()) + File.separator + packageName + PACKAGE_HTML_FILE_POSTFIX;
            File packageHtmlFile = new File(packageHtmlFilePath);
            filesToCreate.add(packageHtmlFile);
            String packageFilesHtmlFilePath = String.valueOf(outputDirectory.getPath()) + File.separator + packageName + PACKAGE_FILE_HTML_FILE_POSTFIX;
            File packageFilesHtmlFile = new File(packageFilesHtmlFilePath);
            filesToCreate.add(packageFilesHtmlFile);
        }
        for (File file : filesToCreate) {
            if (!file.exists()) continue;
            throw new OnlineToolException("File " + file.getName() + " already exists.");
        }
        Writer writer = null;
        try {
            try {
                RdfToHtml.rdfToHtml(doc, docHtmlFile, licenseHtmlFile, snippetHtmlFile, docFilesHtmlFile);
            }
            catch (IOException e) {
                throw new OnlineToolException("IO Error opening SPDX Document");
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new OnlineToolException("Invalid SPDX Document: " + e.getMessage());
            }
            catch (MustacheException e) {
                throw new OnlineToolException("Unexpected error reading the HTML template: " + e.getMessage());
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new OnlineToolException("Warning: error closing HTML file: " + e.getMessage());
                }
                writer = null;
            }
        }
        return verify;
    }

    private static void usage() {
        System.out.println("Usage: RdfToHtml rdfxmlfile.rdf htmlfile.html\nwhere rdfxmlfile.rdf is a valid SPDX RDF XML file and htmlfile.html is\nthe output html file.");
    }

    public static void rdfToHtml(SpdxDocument doc, File templateDir, File docHtmlFile, File licenseHtmlFile, File snippetHtmlFile, File docFilesHtmlFile) throws MustacheException, IOException, InvalidSPDXAnalysisException {
        String dirPath = docHtmlFile.getParent();
        DefaultMustacheFactory lineBreakEscapingBuilder = new DefaultMustacheFactory(templateDir){

            public void encode(String value, Writer writer) {
                try {
                    String escapedValue = HTML_LINEBREAK_ESCAPER.escape(value);
                    writer.append(escapedValue);
                }
                catch (IOException ioe) {
                    throw new MustacheException("Failed to encode value: " + value);
                }
            }
        };
        Map<String, String> spdxIdToUrl = RdfToHtml.buildIdMap(doc, dirPath);
        HashMap fileIdToSnippets = Maps.newHashMap();
        List<SpdxSnippet> snippets = doc.getDocumentContainer().findAllSnippets();
        for (SpdxSnippet snippet : snippets) {
            if (snippet.getId() == null || snippet.getSnippetFromFile() == null || snippet.getSnippetFromFile().getId() == null) continue;
            List fileSnippets = (List)fileIdToSnippets.get(snippet.getId());
            if (fileSnippets == null) {
                fileSnippets = Lists.newArrayList();
                fileIdToSnippets.put(snippet.getSnippetFromFile().getId(), fileSnippets);
            }
            fileSnippets.add(snippet);
        }
        List<SpdxPackage> allPackages = doc.getDocumentContainer().findAllPackages();
        for (SpdxPackage pkg : allPackages) {
            String packageName = pkg.getName();
            String packageHtmlFilePath = String.valueOf(dirPath) + File.separator + packageName + PACKAGE_HTML_FILE_POSTFIX;
            File packageHtmlFile = new File(packageHtmlFilePath);
            String packageFilesHtmlFilePath = String.valueOf(dirPath) + File.separator + packageName + PACKAGE_FILE_HTML_FILE_POSTFIX;
            File packageFilesHtmlFile = new File(packageFilesHtmlFilePath);
            PackageContext pkgContext = new PackageContext(pkg, spdxIdToUrl);
            Map<String, Object> pkgFileMap = MustacheMap.buildPkgFileMap(pkg, spdxIdToUrl, fileIdToSnippets);
            Mustache mustache = lineBreakEscapingBuilder.compile(SPDX_PACKAGE_HTML_TEMPLATE);
            try (OutputStreamWriter packageHtmlFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(packageHtmlFile), "UTF-8");){
                mustache.execute((Writer)packageHtmlFileWriter, (Object)pkgContext);
            }
            mustache = lineBreakEscapingBuilder.compile(SPDX_FILE_HTML_TEMPLATE);
            try (OutputStreamWriter filesHtmlFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(packageFilesHtmlFile), "UTF-8");){
                mustache.execute((Writer)filesHtmlFileWriter, pkgFileMap);
            }
        }
        SpdxItem[] describedItems = doc.getDocumentDescribes();
        int numFiles = 0;
        int i = 0;
        while (i < describedItems.length) {
            if (describedItems[i] instanceof SpdxFile) {
                ++numFiles;
            }
            ++i;
        }
        if (numFiles > 0) {
            SpdxFile[] files = new SpdxFile[numFiles];
            int fi = 0;
            int i2 = 0;
            while (i2 < describedItems.length) {
                if (describedItems[i2] instanceof SpdxFile) {
                    files[fi++] = (SpdxFile)describedItems[i2];
                }
                ++i2;
            }
            Map<String, Object> docFileMap = MustacheMap.buildDocFileMustacheMap(doc, files, spdxIdToUrl, fileIdToSnippets);
            Mustache mustache = lineBreakEscapingBuilder.compile(SPDX_FILE_HTML_TEMPLATE);
            try (OutputStreamWriter docFilesHtmlFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(docFilesHtmlFile), "UTF-8");){
                mustache.execute((Writer)docFilesHtmlFileWriter, docFileMap);
            }
        }
        Map<String, Object> extracteLicMustacheMap = MustacheMap.buildExtractedLicMustachMap(doc, spdxIdToUrl);
        Mustache mustache = lineBreakEscapingBuilder.compile(SPDX_LICENSE_HTML_TEMPLATE);
        try (OutputStreamWriter licenseHtmlFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(licenseHtmlFile), "UTF-8");){
            mustache.execute((Writer)licenseHtmlFileWriter, extracteLicMustacheMap);
        }
        Map<String, Object> snippetMustacheMap = MustacheMap.buildSnippetMustachMap(doc, spdxIdToUrl);
        mustache = lineBreakEscapingBuilder.compile(SPDX_SNIPPET_HTML_TEMPLATE);
        try (OutputStreamWriter snippetHtmlFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(snippetHtmlFile), "UTF-8");){
            mustache.execute((Writer)snippetHtmlFileWriter, snippetMustacheMap);
        }
        Map<String, Object> docMustacheMap = MustacheMap.buildDocMustachMap(doc, spdxIdToUrl);
        mustache = lineBreakEscapingBuilder.compile(SPDX_DOCUMENT_HTML_TEMPLATE);
        try (OutputStreamWriter docHtmlFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(docHtmlFile), "UTF-8");){
            mustache.execute((Writer)docHtmlFileWriter, docMustacheMap);
        }
    }

    private static Map<String, String> buildIdMap(SpdxDocument doc, String dirPath) throws InvalidSPDXAnalysisException {
        HashMap retval = Maps.newHashMap();
        String extractedLicenseFileName = String.valueOf(doc.getName()) + LICENSE_HTML_FILE_POSTFIX;
        ExtractedLicenseInfo[] extractedLicenses = doc.getDocumentContainer().getExtractedLicenseInfos();
        int i = 0;
        while (i < extractedLicenses.length) {
            String id = extractedLicenses[i].getLicenseId();
            retval.put(id, RdfToHtml.convertToUrl(extractedLicenseFileName, id));
            ++i;
        }
        List<SpdxPackage> allPkgs = doc.getDocumentContainer().findAllPackages();
        for (SpdxPackage pkg : allPkgs) {
            String pkgFileName = String.valueOf(pkg.getName()) + PACKAGE_HTML_FILE_POSTFIX;
            String pkgFilesFileName = String.valueOf(pkg.getName()) + PACKAGE_FILE_HTML_FILE_POSTFIX;
            String pkgId = pkg.getId();
            if (pkgId != null) {
                retval.put(pkgId, RdfToHtml.convertToUrl(pkgFileName, pkgId));
            }
            SpdxFile[] pkgFiles = pkg.getFiles();
            int i2 = 0;
            while (i2 < pkgFiles.length) {
                String fileId = pkgFiles[i2].getId();
                if (fileId != null) {
                    retval.put(fileId, RdfToHtml.convertToUrl(pkgFilesFileName, fileId));
                }
                ++i2;
            }
        }
        List<SpdxSnippet> snippets = doc.getDocumentContainer().findAllSnippets();
        for (SpdxSnippet snippet : snippets) {
            String snippetId = snippet.getId();
            if (snippetId == null) continue;
            retval.put(snippetId, SNIPPET_FILE_NAME);
        }
        String docFilesName = String.valueOf(doc.getName()) + DOCUMENT_FILE_HTML_FILE_POSTFIX;
        SpdxItem[] describedItems = doc.getDocumentDescribes();
        int i3 = 0;
        while (i3 < describedItems.length) {
            String fileId;
            if (describedItems[i3] instanceof SpdxFile && (fileId = describedItems[i3].getId()) != null) {
                retval.put(fileId, RdfToHtml.convertToUrl(docFilesName, fileId));
            }
            ++i3;
        }
        return retval;
    }

    private static String convertToUrl(String fileName, String id) {
        String retval = "./" + fileName + "#" + id;
        return retval;
    }

    public static void rdfToHtml(SpdxDocument doc, File docHtmlFile, File licenseHtmlFile, File snippetHtmlFile, File docFilesHtmlFile) throws MustacheException, IOException, InvalidSPDXAnalysisException {
        RdfToHtml.rdfToHtml(doc, templateRootPath.toFile(), docHtmlFile, licenseHtmlFile, snippetHtmlFile, docFilesHtmlFile);
    }
}

