/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.tag.CommonCode;
import org.spdx.tools.OnlineToolException;

public class RdfToTag {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    static final Logger logger = LoggerFactory.getLogger((String)RdfToTag.class.getName());

    public static void main(String[] args) {
        if (args.length < 2) {
            RdfToTag.usage();
            return;
        }
        if (args.length > 2) {
            System.out.printf("Warning: Extra arguments will be ignored%n", new Object[0]);
            RdfToTag.usage();
        }
        try {
            RdfToTag.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            RdfToTag.usage();
            return;
        }
    }

    public static List<String> onlineFunction(String[] args) throws OnlineToolException {
        File spdxRdfFile = new File(args[0]);
        if (!spdxRdfFile.exists()) {
            throw new OnlineToolException("RDF file " + args[0] + " does not exists.");
        }
        File spdxTagFile = new File(args[1]);
        if (spdxTagFile.exists()) {
            throw new OnlineToolException("Error: File " + args[1] + " already exists - please specify a new file.");
        }
        try {
            if (!spdxTagFile.createNewFile()) {
                throw new OnlineToolException("Could not create the new SPDX Tag file " + args[1]);
            }
        }
        catch (IOException e1) {
            throw new OnlineToolException("Could not create the new SPDX Tag file " + args[1] + "due to error " + e1.getMessage());
        }
        PrintWriter out = null;
        List<Object> verify = new LinkedList();
        try {
            try {
                out = new PrintWriter(spdxTagFile, "UTF-8");
            }
            catch (IOException e1) {
                throw new OnlineToolException("Could not write to the new SPDX Tag file " + args[1] + "due to error " + e1.getMessage());
            }
            SpdxDocument doc = null;
            try {
                doc = SPDXDocumentFactory.createSpdxDocument(args[0]);
            }
            catch (InvalidSPDXAnalysisException ex) {
                throw new OnlineToolException("Error creating SPDX Document: " + ex.getMessage());
            }
            catch (IOException e) {
                throw new OnlineToolException("Unable to open file :" + args[0] + ", " + e.getMessage());
            }
            catch (Exception e) {
                throw new OnlineToolException("Error creating SPDX Document: " + e.getMessage(), e);
            }
            try {
                verify = doc.verify();
                if (verify.size() > 0) {
                    System.out.println("This SPDX Document is not valid due to:");
                    int i = 0;
                    while (i < verify.size()) {
                        System.out.println("\t" + (String)verify.get(i));
                        ++i;
                    }
                }
                Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
                CommonCode.printDoc(doc, out, constants);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new OnlineToolException("Error transalting SPDX Document to tag-value format: " + e.getMessage());
            }
            catch (Exception e) {
                throw new OnlineToolException("Unexpected error displaying SPDX Document: " + e.getMessage());
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        return verify;
    }

    private static void usage() {
        System.out.println("Usage: RdfToTag rdfxmlfile.rdf spdxfile.spdx\nwhere rdfxmlfile.rdf is a valid SPDX RDF XML file and spdxfile.spdx is\nthe output SPDX tag-value file.");
    }
}

