/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.AnnotationsSheet;
import org.spdx.spdxspreadsheet.DocumentInfoSheet;
import org.spdx.spdxspreadsheet.ExternalRefsSheet;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.RelationshipsSheet;
import org.spdx.spdxspreadsheet.ReviewersSheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SnippetSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tools.OnlineToolException;

public class SpreadsheetToRDF {
    static final Logger logger = LoggerFactory.getLogger((String)SpreadsheetToRDF.class.getName());
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    private static final ThreadLocal<DateFormat> format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
    };

    public static void main(String[] args) {
        if (args.length < 2) {
            SpreadsheetToRDF.usage();
            return;
        }
        if (args.length > 2) {
            SpreadsheetToRDF.usage();
            return;
        }
        try {
            SpreadsheetToRDF.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            SpreadsheetToRDF.usage();
            return;
        }
    }

    public static List<String> onlineFunction(String[] args) throws OnlineToolException {
        FileOutputStream out;
        File spdxSpreadsheetFile = new File(args[0]);
        if (!spdxSpreadsheetFile.exists()) {
            throw new OnlineToolException("Spreadsheet file does not exists.");
        }
        File spdxRdfFile = new File(args[1]);
        if (spdxRdfFile.exists()) {
            throw new OnlineToolException("Error: File " + args[1] + " already exists - please specify a new file.");
        }
        try {
            if (!spdxRdfFile.createNewFile()) {
                throw new OnlineToolException("Could not create the new SPDX RDF file " + args[1]);
            }
        }
        catch (IOException e1) {
            throw new OnlineToolException("Could not create the new SPDX RDF file " + args[1] + "due to error " + e1.getMessage());
        }
        try {
            out = new FileOutputStream(spdxRdfFile);
        }
        catch (FileNotFoundException e1) {
            throw new OnlineToolException("Could not write to the new SPDX RDF file " + args[1] + "due to error " + e1.getMessage());
        }
        AbstractSpreadsheet ss = null;
        List<Object> verify = new ArrayList();
        try {
            try {
                ss = new SPDXSpreadsheet(spdxSpreadsheetFile, false, true);
                SpdxDocument analysis = SpreadsheetToRDF.copySpreadsheetToSPDXAnalysis((SPDXSpreadsheet)ss);
                verify = analysis.verify();
                if (verify.size() > 0) {
                    System.out.println("Warning: The following verification errors were found in the resultant SPDX Document:");
                    int i = 0;
                    while (i < verify.size()) {
                        System.out.println("\t" + (String)verify.get(i));
                        ++i;
                    }
                }
                analysis.getDocumentContainer().getModel().write((OutputStream)out, "RDF/XML-ABBREV");
            }
            catch (SpreadsheetException e) {
                throw new OnlineToolException("Error creating or writing to spreadsheet: " + e.getMessage());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new OnlineToolException("Error translating the RDF file: " + e.getMessage());
            }
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (SpreadsheetException e) {
                    throw new OnlineToolException("Error closing spreadsheet: " + e.getMessage());
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new OnlineToolException("Error closing RDF file: " + e.getMessage());
                }
            }
        }
        return verify;
    }

    public static SpdxDocument copySpreadsheetToSPDXAnalysis(SPDXSpreadsheet ss) throws SpreadsheetException, InvalidSPDXAnalysisException {
        String pkgUrl = String.valueOf(ss.getOriginsSheet().getNamespace()) + "#" + "SPDXRef-DOCUMENT";
        if (!SpdxVerificationHelper.isValidUri(pkgUrl)) {
            logger.warn("Missing or invalid document namespace.  Using download location URL for the document namespace");
            SpdxPackage[] pkgs = ss.getPackageInfoSheet().getPackages(null);
            if (pkgs.length > 0) {
                pkgUrl = pkgs[0].getDownloadLocation();
            }
        }
        if (!SpdxVerificationHelper.isValidUri(pkgUrl)) {
            logger.warn("Missing or invalid download location.  Using temporary namespace http://spdx.org/tempspdxuri");
            pkgUrl = "http://spdx.org/tempspdxuri";
        }
        SpdxDocumentContainer container = new SpdxDocumentContainer(pkgUrl);
        SpdxDocument analysis = container.getSpdxDocument();
        SpreadsheetToRDF.copyOrigins(ss.getOriginsSheet(), analysis);
        SpreadsheetToRDF.copyNonStdLicenses(ss.getNonStandardLicensesSheet(), analysis);
        Map<String, SpdxPackage> pkgIdToPackage = SpreadsheetToRDF.copyPackageInfo(ss.getPackageInfoSheet(), ss.getExternalRefsSheet(), analysis);
        Map<String, SpdxFile> fileIdToFile = SpreadsheetToRDF.copyPerFileInfo(ss.getPerFileSheet(), analysis, pkgIdToPackage);
        SpreadsheetToRDF.copyPerSnippetInfo(ss.getSnippetSheet(), analysis, fileIdToFile);
        SpreadsheetToRDF.copyAnnotationInfo(ss.getAnnotationsSheet(), analysis);
        SpreadsheetToRDF.copyRelationshipInfo(ss.getRelationshipsSheet(), analysis);
        SpreadsheetToRDF.copyReviewerInfo(ss.getReviewersSheet(), analysis);
        return analysis;
    }

    private static void copyPerSnippetInfo(SnippetSheet snippetSheet, SpdxDocument analysis, Map<String, SpdxFile> fileIdToFile) throws InvalidSPDXAnalysisException, SpreadsheetException {
        int i = snippetSheet.getFirstDataRow();
        SpdxSnippet snippet = snippetSheet.getSnippet(i, analysis.getDocumentContainer());
        while (snippet != null) {
            analysis.getDocumentContainer().addElement(snippet);
            snippet = snippetSheet.getSnippet(++i, analysis.getDocumentContainer());
        }
    }

    private static void copyRelationshipInfo(RelationshipsSheet relationshipsSheet, SpdxDocument analysis) throws SpreadsheetException, InvalidSPDXAnalysisException {
        int i = relationshipsSheet.getFirstDataRow();
        Relationship relationship = relationshipsSheet.getRelationship(i, analysis.getDocumentContainer());
        String id = relationshipsSheet.getElmementId(i);
        while (relationship != null && id != null) {
            SpdxElement element = analysis.getDocumentContainer().findElementById(id);
            element.addRelationship(relationship);
            relationship = relationshipsSheet.getRelationship(++i, analysis.getDocumentContainer());
            id = relationshipsSheet.getElmementId(i);
        }
    }

    private static void copyAnnotationInfo(AnnotationsSheet annotationsSheet, SpdxDocument analysis) throws InvalidSPDXAnalysisException, SpreadsheetException {
        int i = annotationsSheet.getFirstDataRow();
        Annotation annotation = annotationsSheet.getAnnotation(i);
        String id = annotationsSheet.getElmementId(i);
        while (annotation != null && id != null) {
            SpdxElement element = analysis.getDocumentContainer().findElementById(id);
            element.addAnnotation(annotation);
            annotation = annotationsSheet.getAnnotation(++i);
            id = annotationsSheet.getElmementId(i);
        }
    }

    private static void copyReviewerInfo(ReviewersSheet reviewersSheet, SpdxDocument analysis) throws InvalidSPDXAnalysisException {
        int numReviewers = reviewersSheet.getNumDataRows();
        int firstRow = reviewersSheet.getFirstDataRow();
        SPDXReview[] reviewers = new SPDXReview[numReviewers];
        int i = 0;
        while (i < reviewers.length) {
            reviewers[i] = new SPDXReview(reviewersSheet.getReviewer(firstRow + i), format.get().format(reviewersSheet.getReviewerTimestamp(firstRow + i)), reviewersSheet.getReviewerComment(firstRow + i));
            ++i;
        }
        analysis.setReviewers(reviewers);
    }

    private static Map<String, SpdxFile> copyPerFileInfo(PerFileSheet perFileSheet, SpdxDocument analysis, Map<String, SpdxPackage> pkgIdToPackage) throws SpreadsheetException, InvalidSPDXAnalysisException {
        int firstRow = perFileSheet.getFirstDataRow();
        int numFiles = perFileSheet.getNumDataRows();
        HashMap retval = Maps.newHashMap();
        int i = 0;
        while (i < numFiles) {
            SpdxFile file = perFileSheet.getFileInfo(firstRow + i, analysis.getDocumentContainer());
            retval.put(file.getId(), file);
            String[] pkgIds = perFileSheet.getPackageIds(firstRow + i);
            boolean fileAdded = false;
            int j = 0;
            while (j < pkgIds.length) {
                SpdxPackage pkg = pkgIdToPackage.get(pkgIds[j]);
                if (pkg != null) {
                    pkg.addFile(file);
                    fileAdded = true;
                } else {
                    logger.warn("Can not add file " + file.getName() + " to package " + pkgIds[j]);
                }
                ++j;
            }
            if (!fileAdded) {
                analysis.getDocumentContainer().addElement(file);
            }
            ++i;
        }
        return retval;
    }

    private static void copyNonStdLicenses(NonStandardLicensesSheet nonStandardLicensesSheet, SpdxDocument analysis) throws InvalidSPDXAnalysisException {
        int numNonStdLicenses = nonStandardLicensesSheet.getNumDataRows();
        int firstRow = nonStandardLicensesSheet.getFirstDataRow();
        ExtractedLicenseInfo[] nonStdLicenses = new ExtractedLicenseInfo[numNonStdLicenses];
        int i = 0;
        while (i < nonStdLicenses.length) {
            nonStdLicenses[i] = new ExtractedLicenseInfo(nonStandardLicensesSheet.getIdentifier(firstRow + i), nonStandardLicensesSheet.getExtractedText(firstRow + i), nonStandardLicensesSheet.getLicenseName(firstRow + i), nonStandardLicensesSheet.getCrossRefUrls(firstRow + i), nonStandardLicensesSheet.getComment(firstRow + i));
            ++i;
        }
        analysis.setExtractedLicenseInfos(nonStdLicenses);
    }

    private static Map<String, SpdxPackage> copyPackageInfo(PackageInfoSheet packageInfoSheet, ExternalRefsSheet externalRefsSheet, SpdxDocument analysis) throws SpreadsheetException, InvalidSPDXAnalysisException {
        SpdxPackage[] packages = packageInfoSheet.getPackages(analysis.getDocumentContainer());
        HashMap pkgIdToPackage = Maps.newHashMap();
        int i = 0;
        while (i < packages.length) {
            packages[i].setExternalRefs(externalRefsSheet.getExternalRefsForPkgid(packages[i].getId(), analysis.getDocumentContainer()));
            pkgIdToPackage.put(packages[i].getId(), packages[i]);
            analysis.getDocumentContainer().addElement(packages[i]);
            ++i;
        }
        return pkgIdToPackage;
    }

    private static void copyOrigins(DocumentInfoSheet originsSheet, SpdxDocument analysis) throws InvalidSPDXAnalysisException, SpreadsheetException {
        ExternalDocumentRef[] externalRefs;
        String docName;
        Date createdDate = originsSheet.getCreated();
        String created = format.get().format(createdDate);
        String[] createdBys = originsSheet.getCreatedBy();
        String creatorComment = originsSheet.getAuthorComments();
        String licenseListVersion = originsSheet.getLicenseListVersion();
        SPDXCreatorInformation creator = new SPDXCreatorInformation(createdBys, created, creatorComment, licenseListVersion);
        String specVersion = originsSheet.getSPDXVersion();
        analysis.setSpecVersion(specVersion);
        String dataLicenseId = originsSheet.getDataLicense();
        if (dataLicenseId == null || dataLicenseId.isEmpty() || dataLicenseId.equals("This field is not yet supported by SPDX")) {
            dataLicenseId = specVersion.equals("SPDX-1.0") ? "PDDL-1.0" : "CC0-1.0";
        }
        SpdxListedLicense dataLicense = null;
        try {
            dataLicense = (SpdxListedLicense)LicenseInfoFactory.parseSPDXLicenseString(dataLicenseId, analysis.getDocumentContainer());
        }
        catch (Exception ex) {
            logger.warn("Unable to parse the provided standard license ID.  Using CC0-1.0");
            try {
                dataLicense = (SpdxListedLicense)LicenseInfoFactory.parseSPDXLicenseString("CC0-1.0", analysis.getDocumentContainer());
            }
            catch (InvalidLicenseStringException e) {
                throw new InvalidSPDXAnalysisException("Unable to get document license");
            }
        }
        analysis.setDataLicense(dataLicense);
        analysis.setCreationInfo(creator);
        String docComment = originsSheet.getDocumentComment();
        if (docComment != null && !(docComment = docComment.trim()).isEmpty()) {
            analysis.setComment(docComment);
        }
        if ((docName = originsSheet.getDocumentName()) != null) {
            analysis.setName(docName);
        }
        if ((externalRefs = originsSheet.getExternalDocumentRefs()) != null) {
            analysis.setExternalDocumentRefs(externalRefs);
        }
    }

    private static void usage() {
        System.out.println("Usage: SpreadsheetToRDF spreadsheetfile.xls rdfxmlfile.rdf \nwhere spreadsheetfile.xls is a valid SPDX Spreadsheet and\nrdfxmlfile.rdf is the output SPDX RDF analysis file.");
    }
}

