/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tag.CommonCode;
import org.spdx.tools.OnlineToolException;
import org.spdx.tools.SpreadsheetToRDF;

public class SpreadsheetToTag {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    static DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static void main(String[] args) {
        if (args.length < 2) {
            SpreadsheetToTag.usage();
            return;
        }
        if (args.length > 2) {
            SpreadsheetToTag.usage();
            return;
        }
        try {
            SpreadsheetToTag.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            SpreadsheetToTag.usage();
            return;
        }
    }

    public static List<String> onlineFunction(String[] args) throws OnlineToolException {
        File spdxSpreadsheetFile = new File(args[0]);
        if (!spdxSpreadsheetFile.exists()) {
            throw new OnlineToolException("Spreadsheet file " + args[0] + " does not exists.");
        }
        File spdxTagFile = new File(args[1]);
        if (spdxTagFile.exists()) {
            throw new OnlineToolException("Error: File " + args[1] + " already exists - please specify a new file.");
        }
        try {
            if (!spdxTagFile.createNewFile()) {
                throw new OnlineToolException("Could not create the new SPDX Tag file " + args[1]);
            }
        }
        catch (IOException e1) {
            throw new OnlineToolException("Could not create the new SPDX Tag file " + args[1] + "due to error " + e1.getMessage());
        }
        PrintWriter out = null;
        List<Object> verify = new ArrayList();
        try {
            try {
                out = new PrintWriter(spdxTagFile, "UTF-8");
            }
            catch (IOException e1) {
                throw new OnlineToolException("Could not write to the new SPDX Tag file " + args[1] + "due to error " + e1.getMessage());
            }
            AbstractSpreadsheet ss = null;
            try {
                try {
                    ss = new SPDXSpreadsheet(spdxSpreadsheetFile, false, true);
                    SpdxDocument analysis = SpreadsheetToRDF.copySpreadsheetToSPDXAnalysis((SPDXSpreadsheet)ss);
                    verify = analysis.verify();
                    if (verify.size() > 0) {
                        System.out.println("Warning: The following verification errors were found in the resultant SPDX Document:");
                        int i = 0;
                        while (i < verify.size()) {
                            System.out.println("\t" + (String)verify.get(i));
                            ++i;
                        }
                    }
                    Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
                    CommonCode.printDoc(analysis, out, constants);
                }
                catch (SpreadsheetException e) {
                    throw new OnlineToolException("Error creating or writing to spreadsheet: " + e.getMessage());
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new OnlineToolException("Error translating the Tag file: " + e.getMessage());
                }
                catch (Exception e) {
                    throw new OnlineToolException("Unexpected error converting SPDX Document: " + e.getMessage());
                }
            }
            finally {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (SpreadsheetException e) {
                        throw new OnlineToolException("Error closing spreadsheet: " + e.getMessage());
                    }
                }
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        return verify;
    }

    private static void usage() {
        System.out.println("Usage: SpreadsheetToTag spreadsheetfile.xls spdxfile.spdx \nwhere spreadsheetfile.xls is a valid SPDX Spreadsheet and\nspdxfile.spdx is the output SPDX tag-value file.");
    }
}

