/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.tag.BuildDocument;
import org.spdx.tag.CommonCode;
import org.spdx.tag.HandBuiltParser;
import org.spdx.tag.InvalidFileFormatException;
import org.spdx.tag.InvalidSpdxTagFileException;
import org.spdx.tag.NoCommentInputStream;
import org.spdx.tools.OnlineToolException;

public class TagToRDF {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 3;
    static final String OUTPUT_XML_ABBREV = "RDF/XML-ABBREV";
    static final String OUTPUT_XML = "RDF/XML";
    static final String OUTPUT_N_TRIPLET = "N-TRIPLET";
    static final String OUTPUT_TURTLE = "TURTLE";
    static final String DEFAULT_OUTPUT_FORMAT = "RDF/XML-ABBREV";
    static final Set<String> AVAILABLE_OUTPUT_TYPES = Sets.newHashSet();

    static {
        AVAILABLE_OUTPUT_TYPES.add(OUTPUT_N_TRIPLET);
        AVAILABLE_OUTPUT_TYPES.add(OUTPUT_TURTLE);
        AVAILABLE_OUTPUT_TYPES.add("RDF/XML-ABBREV");
        AVAILABLE_OUTPUT_TYPES.add(OUTPUT_XML);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            TagToRDF.usage();
            return;
        }
        if (args.length > 3) {
            TagToRDF.usage();
            return;
        }
        String outputFormat = "RDF/XML-ABBREV";
        if (args.length > 2 && !AVAILABLE_OUTPUT_TYPES.contains(outputFormat = args[2])) {
            System.out.println("Invalid output format type.");
            TagToRDF.usage();
            return;
        }
        try {
            TagToRDF.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            TagToRDF.usage();
            return;
        }
    }

    public static List<String> onlineFunction(String[] args) throws OnlineToolException {
        FileOutputStream out;
        File spdxRDFFile;
        FileInputStream spdxTagStream;
        String outputFormat;
        block33: {
            outputFormat = "RDF/XML-ABBREV";
            if (args.length > 2) {
                outputFormat = args[2];
            }
            try {
                spdxTagStream = new FileInputStream(args[0]);
            }
            catch (FileNotFoundException ex) {
                throw new OnlineToolException("Tag-Value file " + args[0] + " does not exists.");
            }
            spdxRDFFile = new File(args[1]);
            if (spdxRDFFile.exists()) {
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    throw new OnlineToolException("Warning: Unable to close input file on error.");
                }
                throw new OnlineToolException("Error: File " + args[1] + " already exists - please specify a new file.");
            }
            try {
                if (spdxRDFFile.createNewFile()) break block33;
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    throw new OnlineToolException("Warning: Unable to close input file on error.");
                }
                throw new OnlineToolException("Could not create the new SPDX RDF file " + args[1]);
            }
            catch (IOException e1) {
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    throw new OnlineToolException("Warning: Unable to close input file on error.");
                }
                throw new OnlineToolException("Could not create the new SPDX Tag-Value file " + args[1] + "due to error " + e1.getMessage());
            }
        }
        try {
            out = new FileOutputStream(spdxRDFFile);
        }
        catch (FileNotFoundException e1) {
            try {
                spdxTagStream.close();
            }
            catch (IOException e) {
                throw new OnlineToolException("Warning: Unable to close input file on error.");
            }
            throw new OnlineToolException("Could not write to the new SPDX RDF file " + args[1] + "due to error " + e1.getMessage());
        }
        ArrayList<String> warnings = new ArrayList<String>();
        try {
            try {
                TagToRDF.convertTagFileToRdf(spdxTagStream, out, outputFormat, warnings);
                if (!warnings.isEmpty()) {
                    System.out.println("The following warnings and or verification errors were found:");
                    for (String warning : warnings) {
                        System.out.println("\t" + warning);
                    }
                }
            }
            catch (Exception e) {
                throw new OnlineToolException("Error creating SPDX Analysis: " + e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new OnlineToolException("Error closing RDF file: " + e.getMessage());
                }
            }
            if (spdxTagStream != null) {
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    throw new OnlineToolException("Error closing Tag/Value file: " + e.getMessage());
                }
            }
        }
        return warnings;
    }

    public static void convertTagFileToRdf(InputStream spdxTagFile, OutputStream out, String outputFormat, List<String> warnings) throws RecognitionException, TokenStreamException, Exception {
        TagToRDF.convertTagFileToRdf(spdxTagFile, outputFormat, warnings).getModel().write(out, outputFormat);
    }

    public static SpdxDocumentContainer convertTagFileToRdf(InputStream spdxTagFile, String outputFormat, List<String> warnings) throws RecognitionException, TokenStreamException, InvalidSpdxTagFileException, InvalidFileFormatException, Exception {
        Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
        NoCommentInputStream nci = new NoCommentInputStream(spdxTagFile);
        try {
            HandBuiltParser parser = new HandBuiltParser(nci);
            SpdxDocumentContainer[] result = new SpdxDocumentContainer[1];
            parser.setBehavior(new BuildDocument(result, constants, warnings));
            parser.data();
            if (result[0] == null) {
                throw new RuntimeException("Unexpected error parsing SPDX tag document - the result is null.");
            }
            return result[0];
        }
        catch (RecognitionException e) {
            throw new InvalidSpdxTagFileException(e.getMessage());
        }
        catch (InvalidFileFormatException e) {
            throw new InvalidFileFormatException(e.getMessage());
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private static void usage() {
        System.out.println("Usage: TagToRDF spdxfile.spdx rdfxmlfile.rdf [outputFormat]\nwhere spdxfile.spdx is a valid SPDX tag-value file, \nrdfxmlfile.rdf is the output SPDX RDF analysis file and \n[outputFormat] is an optional format for the XML document.\n[outputFormat] must be one of RDF/XML-ABBREV (default), RDF/XML, N-TRIPLET, or TURTLE.");
    }
}

