/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import antlr.RecognitionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tag.BuildDocument;
import org.spdx.tag.CommonCode;
import org.spdx.tag.HandBuiltParser;
import org.spdx.tag.InvalidFileFormatException;
import org.spdx.tag.NoCommentInputStream;
import org.spdx.tools.OnlineToolException;
import org.spdx.tools.RdfToSpreadsheet;

public class TagToSpreadsheet {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;

    public static void main(String[] args) {
        if (args.length < 2) {
            TagToSpreadsheet.usage();
            return;
        }
        if (args.length > 2) {
            TagToSpreadsheet.usage();
            return;
        }
        try {
            TagToSpreadsheet.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            TagToSpreadsheet.usage();
            return;
        }
    }

    public static List<String> onlineFunction(String[] args) throws OnlineToolException {
        FileInputStream spdxTagFile;
        try {
            spdxTagFile = new FileInputStream(args[0]);
        }
        catch (FileNotFoundException ex) {
            throw new OnlineToolException("Tag-Value file " + args[0] + " does not exists.");
        }
        File spdxSpreadsheetFile = new File(args[1]);
        if (spdxSpreadsheetFile.exists()) {
            try {
                spdxTagFile.close();
            }
            catch (IOException e) {
                throw new OnlineToolException("Warning: Unable to close output SPDX tag file on error: " + e.getMessage());
            }
            throw new OnlineToolException("Spreadsheet file already exists - please specify a new file name.");
        }
        SpdxDocumentContainer[] result = new SpdxDocumentContainer[1];
        ArrayList<String> warnings = new ArrayList<String>();
        try {
            Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
            NoCommentInputStream nci = new NoCommentInputStream(spdxTagFile);
            HandBuiltParser parser = new HandBuiltParser(nci);
            parser.setBehavior(new BuildDocument(result, constants, warnings));
            parser.data();
            if (result[0] == null) {
                throw new OnlineToolException("Unexpected error parsing SPDX tag document - the result is null.");
            }
            if (!warnings.isEmpty()) {
                System.out.println("The following warnings and or verification errors were found:");
                for (String warning : warnings) {
                    System.out.println("\t" + warning);
                }
            }
        }
        catch (RecognitionException e) {
            throw new OnlineToolException(e.getMessage());
        }
        catch (InvalidFileFormatException e) {
            throw new OnlineToolException(e.getMessage());
        }
        catch (Exception e) {
            throw new OnlineToolException("Error creating SPDX Analysis: " + e);
        }
        AbstractSpreadsheet ss = null;
        try {
            try {
                ss = new SPDXSpreadsheet(spdxSpreadsheetFile, true, false);
                RdfToSpreadsheet.copyRdfXmlToSpreadsheet(result[0].getSpdxDocument(), (SPDXSpreadsheet)ss);
            }
            catch (SpreadsheetException e) {
                throw new OnlineToolException("Error opening or writing to spreadsheet: " + e.getMessage());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new OnlineToolException("Error translating the Tag file: " + e.getMessage());
            }
            catch (Exception ex) {
                throw new OnlineToolException("Unexpected error translating the tag-value to spreadsheet: " + ex.getMessage());
            }
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (SpreadsheetException e) {
                    throw new OnlineToolException("Error closing spreadsheet: " + e.getMessage());
                }
            }
        }
        return warnings;
    }

    private static void usage() {
        System.out.println("Usage: TagToSpreadsheet spdxfile.spdx spreadsheetfile.xls \nwhere spdxfile.spdx is a valid SPDX tag-value file and spreadsheetfile.xls is \nthe output SPDX spreadsheeet file.");
    }
}

