/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.parsson.JsonMessages;
import org.eclipse.parsson.JsonNumberImpl;
import org.eclipse.parsson.JsonStringImpl;
import org.eclipse.parsson.JsonWriterImpl;
import org.eclipse.parsson.MapUtil;
import org.eclipse.parsson.api.BufferPool;

class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    protected Map<String, JsonValue> valueMap;
    private final BufferPool bufferPool;
    private final boolean rejectDuplicateKeys;

    JsonObjectBuilderImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.rejectDuplicateKeys = false;
    }

    JsonObjectBuilderImpl(BufferPool bufferPool, boolean rejectDuplicateKeys) {
        this.bufferPool = bufferPool;
        this.rejectDuplicateKeys = rejectDuplicateKeys;
    }

    JsonObjectBuilderImpl(JsonObject object, BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.valueMap = new LinkedHashMap<String, JsonValue>();
        this.valueMap.putAll((Map<String, JsonValue>)object);
        this.rejectDuplicateKeys = false;
    }

    JsonObjectBuilderImpl(JsonObject object, BufferPool bufferPool, boolean rejectDuplicateKeys) {
        this.bufferPool = bufferPool;
        this.valueMap = new LinkedHashMap<String, JsonValue>();
        this.valueMap.putAll((Map<String, JsonValue>)object);
        this.rejectDuplicateKeys = rejectDuplicateKeys;
    }

    JsonObjectBuilderImpl(Map<String, Object> map, BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.valueMap = new LinkedHashMap<String, JsonValue>();
        this.populate(map);
        this.rejectDuplicateKeys = false;
    }

    JsonObjectBuilderImpl(Map<String, Object> map, BufferPool bufferPool, boolean rejectDuplicateKeys) {
        this.bufferPool = bufferPool;
        this.valueMap = new LinkedHashMap<String, JsonValue>();
        this.populate(map);
        this.rejectDuplicateKeys = rejectDuplicateKeys;
    }

    public JsonObjectBuilder add(String name, JsonValue value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, String value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, (JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, BigInteger value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, (JsonValue)JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, (JsonValue)JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    public JsonObjectBuilder add(String name, int value) {
        this.validateName(name);
        this.putValueMap(name, (JsonValue)JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    public JsonObjectBuilder add(String name, long value) {
        this.validateName(name);
        this.putValueMap(name, (JsonValue)JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    public JsonObjectBuilder add(String name, double value) {
        this.validateName(name);
        this.putValueMap(name, (JsonValue)JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    public JsonObjectBuilder add(String name, boolean value) {
        this.validateName(name);
        this.putValueMap(name, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonObjectBuilder addNull(String name) {
        this.validateName(name);
        this.putValueMap(name, JsonValue.NULL);
        return this;
    }

    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        this.validateName(name);
        if (builder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_OBJECT_BUILDER_NULL());
        }
        this.putValueMap(name, (JsonValue)builder.build());
        return this;
    }

    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        this.validateName(name);
        if (builder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_ARRAY_BUILDER_NULL());
        }
        this.putValueMap(name, (JsonValue)builder.build());
        return this;
    }

    public JsonObjectBuilder addAll(JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_OBJECT_BUILDER_NULL());
        }
        if (this.valueMap == null) {
            this.valueMap = new LinkedHashMap<String, JsonValue>();
        }
        this.valueMap.putAll((Map<String, JsonValue>)builder.build());
        return this;
    }

    public JsonObjectBuilder remove(String name) {
        this.validateName(name);
        this.valueMap.remove(name);
        return this;
    }

    public JsonObject build() {
        Map<String, JsonValue> snapshot = this.valueMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.valueMap);
        this.valueMap = null;
        return new JsonObjectImpl(snapshot, this.bufferPool);
    }

    private void populate(Map<String, Object> map) {
        Set<String> fields = map.keySet();
        for (String field : fields) {
            Object value = map.get(field);
            if (value != null && value instanceof Optional) {
                ((Optional)value).ifPresent(v -> this.valueMap.put(field, MapUtil.handle(v, this.bufferPool)));
                continue;
            }
            this.valueMap.put(field, MapUtil.handle(value, this.bufferPool));
        }
    }

    private void putValueMap(String name, JsonValue value) {
        if (this.valueMap == null) {
            this.valueMap = new LinkedHashMap<String, JsonValue>();
        }
        JsonValue previousValue = this.valueMap.put(name, value);
        if (this.rejectDuplicateKeys && previousValue != null) {
            throw new IllegalStateException(JsonMessages.DUPLICATE_KEY(name));
        }
    }

    private void validateName(String name) {
        if (name == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_NAME_NULL());
        }
    }

    private void validateValue(Object value) {
        if (value == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_VALUE_NULL());
        }
    }

    private static final class JsonObjectImpl
    extends AbstractMap<String, JsonValue>
    implements JsonObject {
        private final Map<String, JsonValue> valueMap;
        private final BufferPool bufferPool;
        private int hashCode;

        JsonObjectImpl(Map<String, JsonValue> valueMap, BufferPool bufferPool) {
            this.valueMap = valueMap;
            this.bufferPool = bufferPool;
        }

        public JsonArray getJsonArray(String name) {
            return (JsonArray)this.get(name);
        }

        public JsonObject getJsonObject(String name) {
            return (JsonObject)this.get(name);
        }

        public JsonNumber getJsonNumber(String name) {
            return (JsonNumber)this.get(name);
        }

        public JsonString getJsonString(String name) {
            return (JsonString)this.get(name);
        }

        public String getString(String name) {
            return this.getJsonString(name).getString();
        }

        public String getString(String name, String defaultValue) {
            JsonValue value = this.get(name);
            if (value instanceof JsonString) {
                return ((JsonString)value).getString();
            }
            return defaultValue;
        }

        public int getInt(String name) {
            return this.getJsonNumber(name).intValue();
        }

        public int getInt(String name, int defaultValue) {
            JsonValue value = this.get(name);
            if (value instanceof JsonNumber) {
                return ((JsonNumber)value).intValue();
            }
            return defaultValue;
        }

        public boolean getBoolean(String name) {
            JsonValue value = this.get(name);
            if (value == null) {
                throw new NullPointerException();
            }
            if (value == JsonValue.TRUE) {
                return true;
            }
            if (value == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            JsonValue value = this.get(name);
            if (value == JsonValue.TRUE) {
                return true;
            }
            if (value == JsonValue.FALSE) {
                return false;
            }
            return defaultValue;
        }

        public boolean isNull(String name) {
            return this.get(name).equals(JsonValue.NULL);
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.OBJECT;
        }

        @Override
        public Set<Map.Entry<String, JsonValue>> entrySet() {
            return this.valueMap.entrySet();
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = super.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            try (JsonWriterImpl jw = new JsonWriterImpl(sw, this.bufferPool);){
                jw.write((JsonStructure)this);
            }
            return sw.toString();
        }

        public JsonObject asJsonObject() {
            return this;
        }

        @Override
        public int size() {
            return this.valueMap.size();
        }

        @Override
        public JsonValue get(Object key) {
            return this.valueMap.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.valueMap.containsKey(key);
        }
    }
}

