/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Dynamic;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.lang.Nullable;

public interface ElasticsearchPersistentEntity<T>
extends PersistentEntity<T, ElasticsearchPersistentProperty> {
    public IndexCoordinates getIndexCoordinates();

    public short getShards();

    public short getReplicas();

    public boolean isUseServerConfiguration();

    @Nullable
    public String getRefreshInterval();

    @Nullable
    public String getIndexStoreType();

    public ElasticsearchPersistentProperty getVersionProperty();

    @Nullable
    public String settingPath();

    @Nullable
    public Document.VersionType getVersionType();

    public boolean isCreateIndexAndMapping();

    @Nullable
    public ElasticsearchPersistentProperty getPersistentPropertyWithFieldName(String var1);

    public boolean hasSeqNoPrimaryTermProperty();

    public boolean hasJoinFieldProperty();

    @Nullable
    public ElasticsearchPersistentProperty getSeqNoPrimaryTermProperty();

    @Nullable
    public ElasticsearchPersistentProperty getJoinFieldProperty();

    default public ElasticsearchPersistentProperty getRequiredSeqNoPrimaryTermProperty() {
        ElasticsearchPersistentProperty property = this.getSeqNoPrimaryTermProperty();
        if (property != null) {
            return property;
        }
        throw new IllegalStateException(String.format("Required SeqNoPrimaryTerm property not found for %s!", this.getType()));
    }

    @Nullable
    public ElasticsearchPersistentProperty getIndexedIndexNameProperty();

    public Settings getDefaultSettings();

    @Nullable
    public String resolveRouting(T var1);

    public FieldNamingStrategy getFieldNamingStrategy();

    public boolean writeTypeHints();

    public Dynamic dynamic();

    public boolean storeIdInSource();

    public boolean storeVersionInSource();
}

