/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Comment;
import org.jooq.CommentOnFinalStep;
import org.jooq.CommentOnIsStep;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function4;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;

final class CommentOnImpl
extends AbstractDDLQuery
implements QOM.CommentOn,
CommentOnIsStep,
CommentOnFinalStep {
    final Table<?> table;
    final boolean isView;
    final Field<?> field;
    Comment comment;
    private static final Set<SQLDialect> SUPPORTS_COMMENT_ON_VIEW = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, Field<?> field) {
        this(configuration, table, isView, field, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView) {
        this(configuration, table, isView, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, Field<?> field, Comment comment) {
        super(configuration);
        this.table = table;
        this.isView = isView;
        this.field = field;
        this.comment = comment;
    }

    @Override
    public final CommentOnImpl is(String comment) {
        return this.is(DSL.comment(comment));
    }

    @Override
    public final CommentOnImpl is(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.table != null) {
                    this.acceptMySQL(ctx);
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptMySQL(Context<?> ctx) {
        ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_COMMENT).sql(" = ").visit(this.comment);
    }

    private final void acceptDefault(Context<?> ctx) {
        ctx.visit(Keywords.K_COMMENT).sql(' ').visit(Keywords.K_ON).sql(' ');
        if (this.table != null) {
            ctx.visit(this.isView && SUPPORTS_COMMENT_ON_VIEW.contains((Object)ctx.dialect()) ? Keywords.K_VIEW : Keywords.K_TABLE).sql(' ').visit(this.table);
        } else if (this.field != null) {
            ctx.visit(Keywords.K_COLUMN).sql(' ').visit(this.field);
        } else {
            throw new IllegalStateException();
        }
        ctx.sql(' ').visit(Keywords.K_IS).sql(' ').visit(this.comment);
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }

    @Override
    public final boolean $isView() {
        return this.isView;
    }

    @Override
    public final Field<?> $field() {
        return this.field;
    }

    @Override
    public final Comment $comment() {
        return this.comment;
    }

    @Override
    public final QOM.CommentOn $table(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$isView(), this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $isView(boolean newValue) {
        return this.$constructor().apply(this.$table(), newValue, this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $field(Field<?> newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), newValue, this.$comment());
    }

    @Override
    public final QOM.CommentOn $comment(Comment newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), this.$field(), newValue);
    }

    public final Function4<? super Table<?>, ? super Boolean, ? super Field<?>, ? super Comment, ? extends QOM.CommentOn> $constructor() {
        return (a1, a2, a3, a4) -> new CommentOnImpl(this.configuration(), (Table<?>)a1, (boolean)a2, (Field<?>)a3, (Comment)a4);
    }
}

