/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheResolver;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={HazelcastCacheManager.class})
@ConditionalOnBean(value={HazelcastCacheManager.class})
@ConditionalOnMissingBean(value={SyncCacheResolver.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="hazelcast-spring", matchIfMissing=true)
public class HazelcastSpringBucket4jCacheConfiguration {
    private HazelcastCacheManager hazelcastCacheManager;

    public HazelcastSpringBucket4jCacheConfiguration(HazelcastCacheManager hazelcastCacheManager) {
        this.hazelcastCacheManager = hazelcastCacheManager;
    }

    @Bean
    public AsyncCacheResolver hazelcastCacheResolver() {
        return new HazelcastCacheResolver(this.hazelcastCacheManager.getHazelcastInstance(), false);
    }
}

