/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.ignite;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ignite.IgniteCacheResolver;
import org.apache.ignite.Ignite;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={Ignite.class})
@ConditionalOnBean(value={Ignite.class})
@ConditionalOnMissingBean(value={AsyncCacheResolver.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="ignite", matchIfMissing=true)
public class IgniteBucket4jCacheConfiguration {
    private Ignite ignite;

    public IgniteBucket4jCacheConfiguration(Ignite ignite) {
        this.ignite = ignite;
    }

    @Bean
    public AsyncCacheResolver hazelcastCacheResolver() {
        return new IgniteCacheResolver(this.ignite);
    }
}

