/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.List;
import java.util.UUID;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public final class AnonymousConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<AnonymousConfigurer<H>, H> {
    private String key;
    private AuthenticationProvider authenticationProvider;
    private AnonymousAuthenticationFilter authenticationFilter;
    private Object principal = "anonymousUser";
    private List<GrantedAuthority> authorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"});

    public AnonymousConfigurer<H> key(String key) {
        this.key = key;
        return this;
    }

    public AnonymousConfigurer<H> principal(Object principal) {
        this.principal = principal;
        return this;
    }

    public AnonymousConfigurer<H> authorities(List<GrantedAuthority> authorities) {
        this.authorities = authorities;
        return this;
    }

    public AnonymousConfigurer<H> authorities(String ... authorities) {
        return this.authorities(AuthorityUtils.createAuthorityList((String[])authorities));
    }

    public AnonymousConfigurer<H> authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
        return this;
    }

    public AnonymousConfigurer<H> authenticationFilter(AnonymousAuthenticationFilter authenticationFilter) {
        this.authenticationFilter = authenticationFilter;
        return this;
    }

    @Override
    public void init(H http) {
        if (this.authenticationProvider == null) {
            this.authenticationProvider = new AnonymousAuthenticationProvider(this.getKey());
        }
        if (this.authenticationFilter == null) {
            this.authenticationFilter = new AnonymousAuthenticationFilter(this.getKey(), this.principal, this.authorities);
            this.authenticationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        }
        this.authenticationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        this.authenticationProvider = this.postProcess(this.authenticationProvider);
        http.authenticationProvider(this.authenticationProvider);
    }

    @Override
    public void configure(H http) {
        this.authenticationFilter.afterPropertiesSet();
        http.addFilter((Filter)this.authenticationFilter);
    }

    private String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }
}

