/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.SqlAstTranslatorWithMerge;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;

public class SQLServerSqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithMerge<T> {
    private static final String UNION_ALL = " union all ";
    private Predicate lateralPredicate;

    public SQLServerSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        this.appendSql(' ');
        if (tableGroupJoin.getJoinedGroup().isLateral()) {
            if (tableGroupJoin.getJoinType() == SqlAstJoinType.LEFT) {
                this.appendSql("outer apply ");
            } else {
                this.appendSql("cross apply ");
            }
        } else {
            this.appendSql(tableGroupJoin.getJoinType().getText());
            this.appendSql("join ");
        }
        Predicate predicate = tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            if (tableGroupJoin.getJoinedGroup().isLateral()) {
                Predicate lateralPredicate = this.lateralPredicate;
                this.lateralPredicate = predicate;
                this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
                this.lateralPredicate = lateralPredicate;
            } else {
                this.renderTableGroup(tableGroupJoin.getJoinedGroup(), predicate, tableGroupJoinCollector);
            }
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    @Override
    protected boolean renderPrimaryTableReference(TableGroup tableGroup, LockMode lockMode) {
        if (this.shouldInlineCte(tableGroup)) {
            this.inlineCteTableGroup(tableGroup, lockMode);
            return false;
        }
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        if (tableReference instanceof NamedTableReference) {
            return this.renderNamedTableReference((NamedTableReference)tableReference, lockMode);
        }
        tableReference.accept(this);
        return false;
    }

    @Override
    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        String tableExpression = tableReference.getTableExpression();
        if (tableReference instanceof UnionTableReference && lockMode != LockMode.NONE && tableExpression.charAt(0) == '(') {
            String identificationVariable;
            int unionIndex;
            int searchIndex = 0;
            while ((unionIndex = tableExpression.indexOf(UNION_ALL, searchIndex)) != -1) {
                this.append(tableExpression, searchIndex, unionIndex);
                this.renderLockHint(lockMode);
                this.appendSql(UNION_ALL);
                searchIndex = unionIndex + UNION_ALL.length();
            }
            this.append(tableExpression, searchIndex, tableExpression.length() - 2);
            this.renderLockHint(lockMode);
            this.appendSql(" )");
            this.registerAffectedTable(tableReference);
            Clause currentClause = this.getClauseStack().getCurrent();
            if (this.rendersTableReferenceAlias(currentClause) && (identificationVariable = tableReference.getIdentificationVariable()) != null) {
                this.appendSql(' ');
                this.appendSql(identificationVariable);
            }
        } else {
            super.renderNamedTableReference(tableReference, lockMode);
            this.renderLockHint(lockMode);
        }
        return true;
    }

    private void renderLockHint(LockMode lockMode) {
        int effectiveLockTimeout = this.getEffectiveLockTimeout(lockMode);
        block0 : switch (lockMode) {
            case PESSIMISTIC_WRITE: 
            case WRITE: {
                switch (effectiveLockTimeout) {
                    case -2: {
                        this.appendSql(" with (updlock,rowlock,readpast)");
                        break block0;
                    }
                    case 0: {
                        this.appendSql(" with (updlock,holdlock,rowlock,nowait)");
                        break block0;
                    }
                }
                this.appendSql(" with (updlock,holdlock,rowlock)");
                break;
            }
            case PESSIMISTIC_READ: {
                switch (effectiveLockTimeout) {
                    case -2: {
                        this.appendSql(" with (updlock,rowlock,readpast)");
                        break block0;
                    }
                    case 0: {
                        this.appendSql(" with (holdlock,rowlock,nowait)");
                        break block0;
                    }
                }
                this.appendSql(" with (holdlock,rowlock)");
                break;
            }
            case UPGRADE_SKIPLOCKED: {
                if (effectiveLockTimeout == 0) {
                    this.appendSql(" with (updlock,rowlock,readpast,nowait)");
                    break;
                }
                this.appendSql(" with (updlock,rowlock,readpast)");
                break;
            }
            case UPGRADE_NOWAIT: {
                this.appendSql(" with (updlock,holdlock,rowlock,nowait)");
            }
        }
    }

    @Override
    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    protected OffsetFetchClauseMode getOffsetFetchClauseMode(QueryPart queryPart) {
        boolean hasOffset;
        boolean hasLimit;
        DatabaseVersion version = this.getDialect().getVersion();
        if (queryPart.isRoot() && this.hasLimit()) {
            hasLimit = this.getLimit().getMaxRows() != null;
            hasOffset = this.getLimit().getFirstRow() != null;
        } else {
            hasLimit = queryPart.getFetchClauseExpression() != null;
            boolean bl = hasOffset = queryPart.getOffsetClauseExpression() != null;
        }
        if (queryPart instanceof QueryGroup) {
            if (hasOffset || hasLimit) {
                if (version.isBefore(11) || !this.isRowsOnlyFetchClauseType(queryPart)) {
                    return OffsetFetchClauseMode.EMULATED;
                }
                return OffsetFetchClauseMode.STANDARD;
            }
            return null;
        }
        if (!hasOffset) {
            return hasLimit ? OffsetFetchClauseMode.TOP_ONLY : null;
        }
        if (version.isBefore(11) || !this.isRowsOnlyFetchClauseType(queryPart)) {
            return OffsetFetchClauseMode.EMULATED;
        }
        if (!queryPart.hasSortSpecifications() && ((QuerySpec)queryPart).getSelectClause().isDistinct()) {
            return OffsetFetchClauseMode.EMULATED;
        }
        return OffsetFetchClauseMode.STANDARD;
    }

    @Override
    protected boolean supportsSimpleQueryGrouping() {
        return false;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && this.getOffsetFetchClauseMode(queryPart) == OffsetFetchClauseMode.EMULATED;
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        Predicate lateralPredicate = this.lateralPredicate;
        if (lateralPredicate != null) {
            this.lateralPredicate = null;
            this.addAdditionalWherePredicate(lateralPredicate);
        }
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, !this.isRowsOnlyFetchClauseType(queryGroup));
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, !this.isRowsOnlyFetchClauseType(querySpec));
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        if (this.lateralPredicate != null) {
            this.addAdditionalWherePredicate(this.lateralPredicate);
            this.lateralPredicate = null;
        }
        super.visitSelectClause(selectClause);
    }

    @Override
    protected boolean needsRowsToSkip() {
        return false;
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        QuerySpec querySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        OffsetFetchClauseMode offsetFetchClauseMode = this.getOffsetFetchClauseMode(querySpec);
        if (offsetFetchClauseMode == OffsetFetchClauseMode.TOP_ONLY) {
            this.renderTopClause(querySpec, true, true);
        } else if (offsetFetchClauseMode == OffsetFetchClauseMode.EMULATED) {
            this.renderTopClause(querySpec, this.isRowsOnlyFetchClauseType(querySpec), true);
        } else if (this.getQueryPartStack().depth() > 1 && querySpec.hasSortSpecifications() && this.getQueryPartStack().peek(1) instanceof QueryGroup) {
            this.appendSql("top 100 percent ");
        }
        super.visitSqlSelections(selectClause);
    }

    @Override
    protected void renderOrderBy(boolean addWhitespace, List<SortSpecification> sortSpecifications) {
        if (sortSpecifications != null && !sortSpecifications.isEmpty()) {
            super.renderOrderBy(addWhitespace, sortSpecifications);
        } else if (this.getClauseStack().getCurrent() == Clause.OVER) {
            if (addWhitespace) {
                this.appendSql(' ');
            }
            this.renderEmptyOrderBy();
        }
    }

    protected void renderEmptyOrderBy() {
        this.appendSql("order by (select 0)");
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        OffsetFetchClauseMode offsetFetchClauseMode;
        if (!this.isRowNumberingCurrentQueryPart() && (offsetFetchClauseMode = this.getOffsetFetchClauseMode(queryPart)) == OffsetFetchClauseMode.STANDARD) {
            FetchClauseType fetchClauseType;
            Expression fetchExpression;
            Expression offsetExpression;
            if (!queryPart.hasSortSpecifications()) {
                this.appendSql(' ');
                this.renderEmptyOrderBy();
            }
            if (queryPart.isRoot() && this.hasLimit()) {
                this.prepareLimitOffsetParameters();
                offsetExpression = this.getOffsetParameter();
                fetchExpression = this.getLimitParameter();
                fetchClauseType = FetchClauseType.ROWS_ONLY;
            } else {
                offsetExpression = queryPart.getOffsetClauseExpression();
                fetchExpression = queryPart.getFetchClauseExpression();
                fetchClauseType = queryPart.getFetchClauseType();
            }
            if (offsetExpression == null) {
                this.appendSql(" offset 0 rows");
            } else {
                this.renderOffset(offsetExpression, true);
            }
            if (fetchExpression != null) {
                this.renderFetch(fetchExpression, null, fetchClauseType);
            }
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode() == 2009) {
            switch (operator) {
                case EQUAL: 
                case NOT_DISTINCT_FROM: 
                case NOT_EQUAL: 
                case DISTINCT_FROM: {
                    this.appendSql("cast(");
                    lhs.accept(this);
                    this.appendSql(" as nvarchar(max))");
                    this.appendSql(operator.sqlText());
                    this.appendSql("cast(");
                    rhs.accept(this);
                    this.appendSql(" as nvarchar(max))");
                    return;
                }
            }
        }
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        arithmeticExpression.getLeftHandOperand().accept(this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept(this);
        this.appendSql(')');
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected void renderMergeStatement(OptionalTableUpdate optionalTableUpdate) {
        super.renderMergeStatement(optionalTableUpdate);
        this.appendSql(";");
    }

    static enum OffsetFetchClauseMode {
        STANDARD,
        TOP_ONLY,
        EMULATED;

    }
}

