/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;

public class StandardNamingStrategy
implements ImplicitDatabaseObjectNamingStrategy {
    public static final String STRATEGY_NAME = "standard";

    @Override
    public QualifiedName determineSequenceName(Identifier catalogName, Identifier schemaName, Map<?, ?> configValues, ServiceRegistry serviceRegistry) {
        String rootTableName = ConfigurationHelper.getString("target_table", configValues);
        String implicitName = StandardNamingStrategy.implicitSequenceName(rootTableName, configValues, serviceRegistry);
        if (implicitName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(implicitName);
        }
        return new QualifiedSequenceName(catalogName, schemaName, serviceRegistry.getService(JdbcEnvironment.class).getIdentifierHelper().toIdentifier(implicitName));
    }

    private static String implicitSequenceName(String rootTableName, Map<?, ?> configValues, ServiceRegistry serviceRegistry) {
        String explicitSuffix = ConfigurationHelper.getString("sequence_per_entity_suffix", configValues);
        String base = ConfigurationHelper.getString("implicit_name_base", configValues, rootTableName);
        if (StringHelper.isNotEmpty(explicitSuffix) && StringHelper.isNotEmpty(base)) {
            return Identifier.isQuoted(base) ? "`" + Identifier.unQuote(base) + explicitSuffix + "`" : base + explicitSuffix;
        }
        String annotationGeneratorName = ConfigurationHelper.getString("GENERATOR_NAME", configValues);
        if (StringHelper.isNotEmpty(annotationGeneratorName)) {
            return annotationGeneratorName;
        }
        if (StringHelper.isNotEmpty(base)) {
            return Identifier.isQuoted(base) ? "`" + Identifier.unQuote(base) + "_SEQ`" : base + "_SEQ";
        }
        throw new MappingException("Unable to determine implicit sequence name; target table - " + rootTableName);
    }

    @Override
    public QualifiedName determineTableName(Identifier catalogName, Identifier schemaName, Map<?, ?> configValues, ServiceRegistry serviceRegistry) {
        String tableName = StandardNamingStrategy.implicitTableName(configValues);
        if (tableName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(tableName);
        }
        return new QualifiedNameParser.NameParts(catalogName, schemaName, serviceRegistry.getService(JdbcEnvironment.class).getIdentifierHelper().toIdentifier(tableName));
    }

    private static String implicitTableName(Map<?, ?> configValues) {
        String generatorName = ConfigurationHelper.getString("GENERATOR_NAME", configValues);
        return StringHelper.isNotEmpty(generatorName) ? generatorName : "hibernate_sequences";
    }
}

