/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.Locale;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.internal.Preparable;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderSupport;
import org.hibernate.loader.ast.spi.EntityBatchLoader;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;

public class EntityBatchLoaderArrayParam<T>
extends SingleIdEntityLoaderSupport<T>
implements EntityBatchLoader<T>,
SqlArrayMultiKeyLoader,
Preparable {
    private final int domainBatchSize;
    private BasicEntityIdentifierMapping identifierMapping;
    private JdbcMapping arrayJdbcMapping;
    private JdbcParameter jdbcParameter;
    private SelectStatement sqlAst;
    private JdbcOperationQuerySelect jdbcSelectOperation;

    public EntityBatchLoaderArrayParam(int domainBatchSize, EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.domainBatchSize = domainBatchSize;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_DEBUG_ENABLED) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching enabled for `%s` (entity) using ARRAY strategy : %s", (Object)entityDescriptor.getEntityName(), (Object)domainBatchSize);
        }
    }

    @Override
    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    @Override
    public final T load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_DEBUG_ENABLED) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching entity `%s#%s`", (Object)this.getLoadable().getEntityName(), pkValue);
        }
        Object[] ids = this.resolveIdsToInitialize(pkValue, session);
        this.initializeEntities(ids, pkValue, entityInstance, lockOptions, readOnly, session);
        EntityKey entityKey = session.generateEntityKey(pkValue, this.getLoadable().getEntityPersister());
        return (T)session.getPersistenceContext().getEntity(entityKey);
    }

    protected Object[] resolveIdsToInitialize(Object pkValue, SharedSessionContractImplementor session) {
        Object[] idsToLoad = (Object[])Array.newInstance(this.identifierMapping.getJavaType().getJavaTypeClass(), this.domainBatchSize);
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableEntityIds(this.domainBatchSize, (index, value) -> {
            idsToLoad[index] = value;
        }, pkValue, this.getLoadable());
        return idsToLoad;
    }

    private void initializeEntities(Object[] idsToInitialize, Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        LoaderHelper.loadByArrayParameter(idsToInitialize, this.sqlAst, this.jdbcSelectOperation, this.jdbcParameter, this.arrayJdbcMapping, pkValue, entityInstance, lockOptions, readOnly, session);
        for (int i = 0; i < idsToInitialize.length; ++i) {
            Object id = idsToInitialize[i];
            if (id == null) continue;
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, this.getLoadable(), session);
        }
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(pkValue, null, lockOptions, readOnly, session);
    }

    @Override
    public void prepare() {
        this.identifierMapping = (BasicEntityIdentifierMapping)this.getLoadable().getIdentifierMapping();
        Class<?> arrayClass = Array.newInstance(this.identifierMapping.getJavaType().getJavaTypeClass(), 0).getClass();
        BasicTypeRegistry basicTypeRegistry = this.sessionFactory.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<?> arrayBasicType = basicTypeRegistry.getRegisteredType(arrayClass);
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping(arrayBasicType, this.identifierMapping.getJdbcMapping(), arrayClass, this.sessionFactory);
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
        this.sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.identifierMapping, LoadQueryInfluencers.NONE, LockOptions.NONE, this.jdbcParameter, this.sessionFactory);
        this.jdbcSelectOperation = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    public String toString() {
        return String.format(Locale.ROOT, "EntityBatchLoaderArrayParam(%s [%s])", this.getLoadable().getEntityName(), this.domainBatchSize);
    }
}

