/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.property.access.internal.AbstractFieldSerialForm;
import org.hibernate.property.access.spi.SetterFieldImpl;

public class EnhancedSetterImpl
extends SetterFieldImpl {
    private static final int COMPOSITE_TRACKER_MASK = 1;
    private static final int COMPOSITE_OWNER = 2;
    private static final int PERSISTENT_ATTRIBUTE_INTERCEPTABLE_MASK = 4;
    private final String propertyName;
    private final int enhancementState;

    public EnhancedSetterImpl(Class<?> containerClass, String propertyName, Field field) {
        super(containerClass, propertyName, field);
        this.propertyName = propertyName;
        this.enhancementState = (CompositeOwner.class.isAssignableFrom(containerClass) ? 2 : 0) | (CompositeTracker.class.isAssignableFrom(field.getType()) ? 1 : 0) | (ManagedTypeHelper.isPersistentAttributeInterceptableType(containerClass) ? 4 : 0);
    }

    @Override
    public void set(Object target, Object value) {
        PersistentAttributeInterceptor interceptor;
        super.set(target, value);
        if ((this.enhancementState & 2) != 0 && ((this.enhancementState & 1) != 0 && value != null || ManagedTypeHelper.isCompositeTracker(value))) {
            ManagedTypeHelper.asCompositeTracker(value).$$_hibernate_setOwner(this.propertyName, ManagedTypeHelper.asCompositeOwner(target));
        }
        if ((this.enhancementState & 4) != 0 && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(target).$$_hibernate_getInterceptor()) instanceof BytecodeLazyAttributeInterceptor) {
            ((BytecodeLazyAttributeInterceptor)interceptor).attributeInitialized(this.propertyName);
        }
    }

    private Object writeReplace() {
        return new SerialForm(this.getContainerClass(), this.propertyName, this.getField());
    }

    private static class SerialForm
    extends AbstractFieldSerialForm
    implements Serializable {
        private final Class containerClass;
        private final String propertyName;

        private SerialForm(Class containerClass, String propertyName, Field field) {
            super(field);
            this.containerClass = containerClass;
            this.propertyName = propertyName;
        }

        private Object readResolve() {
            return new EnhancedSetterImpl(this.containerClass, this.propertyName, this.resolveField());
        }
    }
}

