/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.query.criteria.JpaWindow;
import org.hibernate.query.criteria.JpaWindowFrame;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.query.sqm.FrameMode;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;

@Incubating
public class SqmWindow
extends AbstractSqmNode
implements JpaWindow,
SqmVisitableNode {
    private final List<SqmExpression<?>> partitions;
    private final List<SqmSortSpecification> orderList;
    private FrameMode mode;
    private FrameKind startKind;
    private SqmExpression<?> startExpression;
    private FrameKind endKind;
    private SqmExpression<?> endExpression;
    private FrameExclusion exclusion;

    public SqmWindow(NodeBuilder nodeBuilder) {
        this(nodeBuilder, new ArrayList(), new ArrayList<SqmSortSpecification>(), FrameMode.RANGE, FrameKind.UNBOUNDED_PRECEDING, null, FrameKind.CURRENT_ROW, null, FrameExclusion.NO_OTHERS);
    }

    public SqmWindow(NodeBuilder nodeBuilder, List<SqmExpression<?>> partitions, List<SqmSortSpecification> orderList, FrameMode mode, FrameKind startKind, SqmExpression<?> startExpression, FrameKind endKind, SqmExpression<?> endExpression, FrameExclusion exclusion) {
        super(nodeBuilder);
        this.partitions = partitions;
        this.orderList = orderList;
        this.mode = mode;
        this.startKind = startKind;
        this.startExpression = startExpression;
        this.endKind = endKind;
        this.endExpression = endExpression;
        this.exclusion = exclusion;
    }

    public List<SqmExpression<?>> getPartitions() {
        return this.partitions;
    }

    public List<SqmSortSpecification> getOrderList() {
        return this.orderList;
    }

    public SqmExpression<?> getStartExpression() {
        return this.startExpression;
    }

    public SqmExpression<?> getEndExpression() {
        return this.endExpression;
    }

    public FrameMode getMode() {
        return this.mode;
    }

    public FrameKind getStartKind() {
        return this.startKind;
    }

    public FrameKind getEndKind() {
        return this.endKind;
    }

    public FrameExclusion getExclusion() {
        return this.exclusion;
    }

    @Override
    public JpaWindow frameRows(JpaWindowFrame startFrame, JpaWindowFrame endFrame) {
        return this.setFrames(FrameMode.ROWS, startFrame, endFrame);
    }

    @Override
    public JpaWindow frameRange(JpaWindowFrame startFrame, JpaWindowFrame endFrame) {
        return this.setFrames(FrameMode.RANGE, startFrame, endFrame);
    }

    @Override
    public JpaWindow frameGroups(JpaWindowFrame startFrame, JpaWindowFrame endFrame) {
        return this.setFrames(FrameMode.GROUPS, startFrame, endFrame);
    }

    private SqmWindow setFrames(FrameMode frameMode, JpaWindowFrame startFrame, JpaWindowFrame endFrame) {
        this.mode = frameMode;
        if (startFrame != null) {
            this.startKind = startFrame.getKind();
            this.startExpression = (SqmExpression)startFrame.getExpression();
        }
        if (endFrame != null) {
            this.endKind = endFrame.getKind();
            this.endExpression = (SqmExpression)endFrame.getExpression();
        }
        return this;
    }

    @Override
    public JpaWindow frameExclude(FrameExclusion frameExclusion) {
        this.exclusion = frameExclusion;
        return this;
    }

    @Override
    public JpaWindow partitionBy(Expression<?> ... expressions) {
        for (Expression<?> expression : expressions) {
            this.partitions.add((SqmExpression)expression);
        }
        return this;
    }

    @Override
    public JpaWindow orderBy(Order ... orders) {
        for (Order order : orders) {
            this.orderList.add((SqmSortSpecification)order);
        }
        return this;
    }

    @Override
    public SqmWindow copy(SqmCopyContext context) {
        SqmWindow existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList partitionsCopy = new ArrayList(this.partitions.size());
        for (SqmExpression<?> partition : this.partitions) {
            this.partitions.add((SqmExpression<?>)partition.copy(context));
        }
        ArrayList<SqmSortSpecification> orderListCopy = new ArrayList<SqmSortSpecification>(this.orderList.size());
        for (SqmSortSpecification sortSpecification : this.orderList) {
            this.orderList.add(sortSpecification.copy(context));
        }
        return context.registerCopy(this, new SqmWindow(this.nodeBuilder(), partitionsCopy, (List<SqmSortSpecification>)orderListCopy, this.mode, this.startKind, (SqmExpression<?>)(this.startExpression == null ? null : this.startExpression.copy(context)), this.endKind, (SqmExpression<?>)(this.endExpression == null ? null : this.endExpression.copy(context)), this.exclusion));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitWindow(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        int i;
        boolean needsWhitespace = false;
        if (!this.partitions.isEmpty()) {
            needsWhitespace = true;
            sb.append("partition by ");
            this.partitions.get(0).appendHqlString(sb);
            for (i = 1; i < this.partitions.size(); ++i) {
                sb.append(',');
                this.partitions.get(i).appendHqlString(sb);
            }
        }
        if (!this.orderList.isEmpty()) {
            if (needsWhitespace) {
                sb.append(' ');
            }
            needsWhitespace = true;
            sb.append("order by ");
            this.orderList.get(0).appendHqlString(sb);
            for (i = 1; i < this.orderList.size(); ++i) {
                sb.append(',');
                this.orderList.get(i).appendHqlString(sb);
            }
        }
        if (this.mode != FrameMode.RANGE || this.startKind != FrameKind.UNBOUNDED_PRECEDING || this.endKind != FrameKind.CURRENT_ROW || this.exclusion != FrameExclusion.NO_OTHERS) {
            if (needsWhitespace) {
                sb.append(' ');
            }
            switch (this.mode) {
                case GROUPS: {
                    sb.append("groups ");
                    break;
                }
                case RANGE: {
                    sb.append("range ");
                    break;
                }
                case ROWS: {
                    sb.append("rows ");
                }
            }
            if (this.endKind == FrameKind.CURRENT_ROW) {
                SqmWindow.renderFrameKind(sb, this.startKind, this.startExpression);
            } else {
                sb.append("between ");
                SqmWindow.renderFrameKind(sb, this.startKind, this.startExpression);
                sb.append(" and ");
                SqmWindow.renderFrameKind(sb, this.endKind, this.endExpression);
            }
            switch (this.exclusion) {
                case TIES: {
                    sb.append(" exclude ties");
                    break;
                }
                case CURRENT_ROW: {
                    sb.append(" exclude current row");
                    break;
                }
                case GROUP: {
                    sb.append(" exclude group");
                }
            }
        }
    }

    private static void renderFrameKind(StringBuilder sb, FrameKind kind, SqmExpression<?> expression) {
        switch (kind) {
            case CURRENT_ROW: {
                sb.append("current row");
                break;
            }
            case UNBOUNDED_PRECEDING: {
                sb.append("unbounded preceding");
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                sb.append("unbounded following");
                break;
            }
            case OFFSET_PRECEDING: {
                expression.appendHqlString(sb);
                sb.append(" preceding");
                break;
            }
            case OFFSET_FOLLOWING: {
                expression.appendHqlString(sb);
                sb.append(" following");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame kind: " + kind);
            }
        }
    }
}

