/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class TableGroupJoin
implements TableJoin,
DomainResultProducer {
    private final NavigablePath navigablePath;
    private final TableGroup joinedGroup;
    private SqlAstJoinType joinType;
    private Predicate predicate;

    public TableGroupJoin(NavigablePath navigablePath, SqlAstJoinType joinType, TableGroup joinedGroup) {
        this(navigablePath, joinType, joinedGroup, null);
    }

    public TableGroupJoin(NavigablePath navigablePath, SqlAstJoinType joinType, TableGroup joinedGroup, Predicate predicate) {
        assert (!joinedGroup.isLateral() || joinType == SqlAstJoinType.INNER || joinType == SqlAstJoinType.LEFT || joinType == SqlAstJoinType.CROSS) : "Lateral is only allowed with inner, left or cross joins";
        this.navigablePath = navigablePath;
        this.joinType = joinType;
        this.joinedGroup = joinedGroup;
        this.predicate = predicate;
    }

    @Override
    public SqlAstJoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(SqlAstJoinType joinType) {
        SqlTreeCreationLogger.LOGGER.debugf("Adjusting join-type for TableGroupJoin(%s) : %s -> %s", (Object)this.navigablePath, (Object)this.joinType, (Object)joinType);
        this.joinType = joinType;
    }

    public TableGroup getJoinedGroup() {
        return this.joinedGroup;
    }

    @Override
    public SqlAstNode getJoinedNode() {
        return this.joinedGroup;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    public void applyPredicate(Predicate predicate) {
        this.predicate = SqlAstTreeHelper.combinePredicates(this.predicate, predicate);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableGroupJoin(this);
    }

    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    public boolean isImplicit() {
        return !this.navigablePath.isAliased();
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.getJoinedGroup().createDomainResult(resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.getJoinedGroup().applySqlSelections(creationState);
    }
}

