/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IpPrefixAggregation
extends BucketAggregationBase
implements AggregationVariant {
    private final String field;
    private final int prefixLength;
    @Nullable
    private final Boolean isIpv6;
    @Nullable
    private final Boolean appendPrefixLength;
    @Nullable
    private final Boolean keyed;
    @Nullable
    private final Long minDocCount;
    public static final JsonpDeserializer<IpPrefixAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpPrefixAggregation::setupIpPrefixAggregationDeserializer);

    private IpPrefixAggregation(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.prefixLength = ApiTypeHelper.requireNonNull(builder.prefixLength, this, "prefixLength");
        this.isIpv6 = builder.isIpv6;
        this.appendPrefixLength = builder.appendPrefixLength;
        this.keyed = builder.keyed;
        this.minDocCount = builder.minDocCount;
    }

    public static IpPrefixAggregation of(Function<Builder, ObjectBuilder<IpPrefixAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.IpPrefix;
    }

    public final String field() {
        return this.field;
    }

    public final int prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public final Boolean isIpv6() {
        return this.isIpv6;
    }

    @Nullable
    public final Boolean appendPrefixLength() {
        return this.appendPrefixLength;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Nullable
    public final Long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("prefix_length");
        generator.write(this.prefixLength);
        if (this.isIpv6 != null) {
            generator.writeKey("is_ipv6");
            generator.write(this.isIpv6.booleanValue());
        }
        if (this.appendPrefixLength != null) {
            generator.writeKey("append_prefix_length");
            generator.write(this.appendPrefixLength.booleanValue());
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.longValue());
        }
    }

    protected static void setupIpPrefixAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::isIpv6, JsonpDeserializer.booleanDeserializer(), "is_ipv6");
        op.add(Builder::appendPrefixLength, JsonpDeserializer.booleanDeserializer(), "append_prefix_length");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
        op.add(Builder::minDocCount, JsonpDeserializer.longDeserializer(), "min_doc_count");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IpPrefixAggregation> {
        private String field;
        private Integer prefixLength;
        @Nullable
        private Boolean isIpv6;
        @Nullable
        private Boolean appendPrefixLength;
        @Nullable
        private Boolean keyed;
        @Nullable
        private Long minDocCount;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder prefixLength(int value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder isIpv6(@Nullable Boolean value) {
            this.isIpv6 = value;
            return this;
        }

        public final Builder appendPrefixLength(@Nullable Boolean value) {
            this.appendPrefixLength = value;
            return this;
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        public final Builder minDocCount(@Nullable Long value) {
            this.minDocCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpPrefixAggregation build() {
            this._checkSingleUse();
            return new IpPrefixAggregation(this);
        }
    }
}

