/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.ChannelOption;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.Collections;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.udp.UdpServer;
import reactor.netty.udp.UdpServerConfig;

final class UdpServerBind
extends UdpServer {
    static final UdpServerBind INSTANCE = new UdpServerBind();
    final UdpServerConfig config;
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;

    UdpServerBind() {
        this.config = new UdpServerConfig(Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> new InetSocketAddress(NetUtil.LOCALHOST, DEFAULT_PORT));
    }

    UdpServerBind(UdpServerConfig config) {
        this.config = config;
    }

    @Override
    public Mono<? extends Connection> bind() {
        UdpServerConfig conf = this.configuration();
        ConnectionObserver observer = this.config.defaultConnectionObserver().then(this.config.connectionObserver());
        Mono mono = ConnectionProvider.newConnection().acquire(conf, observer, null, null);
        if (conf.doOnBind() != null) {
            mono = mono.doOnSubscribe(s -> conf.doOnBind().accept(conf));
        }
        return mono;
    }

    @Override
    public UdpServerConfig configuration() {
        return this.config;
    }

    @Override
    protected UdpServer duplicate() {
        return new UdpServerBind(new UdpServerConfig(this.config));
    }
}

