/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.TDB2;
import org.apache.jena.tdb2.assembler.VocabTDB2;

public class DatasetAssemblerTDB
extends DatasetAssembler {
    public Dataset createDataset(Assembler a, Resource root, Mode mode) {
        TDB2.init();
        return DatasetAssemblerTDB.make(root);
    }

    static Dataset make(Resource root) {
        if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabTDB2.pLocation)) {
            throw new AssemblerException(root, "No location given");
        }
        String dir = GraphUtils.getStringValue((Resource)root, (Property)VocabTDB2.pLocation);
        Location loc = Location.create((String)dir);
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(loc);
        if (root.hasProperty(VocabTDB2.pUnionDefaultGraph)) {
            Node b = root.getProperty(VocabTDB2.pUnionDefaultGraph).getObject().asNode();
            NodeValue nv = NodeValue.makeNode((Node)b);
            if (nv.isBoolean()) {
                dsg.getContext().set(TDB2.symUnionDefaultGraph, nv.getBoolean());
            } else {
                Log.warn(DatasetAssemblerTDB.class, (String)("Failed to recognize value for union graph setting (ignored): " + b));
            }
        }
        AssemblerUtils.setContext((Resource)root, (Context)dsg.getContext());
        return DatasetFactory.wrap((DatasetGraph)dsg);
    }

    static {
        JenaSystem.init();
    }
}

