/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.configuration;

import org.jobrunr.configuration.JobRunrConfiguration;
import org.jobrunr.server.BackgroundJobServer;

public class JobRunr {
    private static JobRunrConfiguration jobRunrConfiguration;

    private JobRunr() {
    }

    public static JobRunrConfiguration configure() {
        jobRunrConfiguration = new JobRunrConfiguration();
        Runtime.getRuntime().addShutdownHook(new Thread(JobRunr::destroy, "extShutdownHook"));
        return jobRunrConfiguration;
    }

    public static JobRunrConfiguration destroy() {
        if (jobRunrConfiguration != null) {
            if (JobRunr.jobRunrConfiguration.backgroundJobServer != null) {
                JobRunr.jobRunrConfiguration.backgroundJobServer.stop();
            }
            if (JobRunr.jobRunrConfiguration.dashboardWebServer != null) {
                JobRunr.jobRunrConfiguration.dashboardWebServer.stop();
            }
            if (JobRunr.jobRunrConfiguration.storageProvider != null) {
                JobRunr.jobRunrConfiguration.storageProvider.close();
            }
            if (JobRunr.jobRunrConfiguration.microMeterIntegration != null) {
                JobRunr.jobRunrConfiguration.microMeterIntegration.close();
            }
        }
        return jobRunrConfiguration;
    }

    public static BackgroundJobServer getBackgroundJobServer() {
        if (jobRunrConfiguration == null) {
            throw new IllegalStateException("You don't seem to use the Fluent API. This method is only available if you are using the Fluent API to configure JobRunr");
        }
        if (JobRunr.jobRunrConfiguration.backgroundJobServer == null) {
            throw new IllegalStateException("The background job server is not configured. Are you perhaps only running the JobScheduler or the Dashboard on this server instance?");
        }
        return JobRunr.jobRunrConfiguration.backgroundJobServer;
    }
}

