/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.configuration;

import io.micrometer.core.instrument.MeterRegistry;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.metrics.BackgroundJobServerMetricsBinder;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.metrics.StorageProviderMetricsBinder;

public class JobRunrMicroMeterIntegration
implements AutoCloseable {
    private final MeterRegistry meterRegistry;
    private StorageProviderMetricsBinder storageProviderMetricsBinder;
    private BackgroundJobServerMetricsBinder backgroundJobServerMetricsBinder;

    public JobRunrMicroMeterIntegration(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void initialize(StorageProvider storageProvider, BackgroundJobServer backgroundJobServer) {
        this.storageProviderMetricsBinder = new StorageProviderMetricsBinder(storageProvider, this.meterRegistry);
        if (backgroundJobServer != null) {
            this.backgroundJobServerMetricsBinder = new BackgroundJobServerMetricsBinder(backgroundJobServer, this.meterRegistry);
        }
    }

    @Override
    public void close() {
        this.storageProviderMetricsBinder.close();
        if (this.backgroundJobServerMetricsBinder != null) {
            this.backgroundJobServerMetricsBinder.close();
        }
    }
}

