/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jobrunr.dashboard.server.http.RestHttpHandler;
import org.jobrunr.dashboard.server.http.handlers.HttpRequestHandler;
import org.jobrunr.dashboard.ui.model.RecurringJobUIModel;
import org.jobrunr.dashboard.ui.model.VersionUIModel;
import org.jobrunr.dashboard.ui.model.problems.ProblemsManager;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.ThreadSafeStorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;

public class JobRunrApiHandler
extends RestHttpHandler {
    private final StorageProvider storageProvider;
    private final boolean allowAnonymousDataUsage;
    private ProblemsManager problemsManager;
    private RecurringJobsResult recurringJobsResult;
    private VersionUIModel versionUIModel;

    public JobRunrApiHandler(StorageProvider storageProvider, JsonMapper jsonMapper, boolean allowAnonymousDataUsage) {
        super("/api", jsonMapper);
        this.storageProvider = storageProvider;
        this.allowAnonymousDataUsage = allowAnonymousDataUsage;
        this.get("/jobs", this.findJobByState());
        this.get("/jobs/:id", this.getJobById());
        this.delete("/jobs/:id", this.deleteJobById());
        this.post("/jobs/:id/requeue", this.requeueJobById());
        this.get("/problems", this.getProblems());
        this.delete("/problems/:type", this.deleteProblemByType());
        this.get("/recurring-jobs", this.getRecurringJobs());
        this.delete("/recurring-jobs/:id", this.deleteRecurringJob());
        this.post("/recurring-jobs/:id/trigger", this.triggerRecurringJob());
        this.get("/servers", this.getBackgroundJobServers());
        this.get("/version", this.getVersion());
        this.withExceptionMapping(JobNotFoundException.class, (exc, resp) -> resp.statusCode(404));
    }

    private HttpRequestHandler getJobById() {
        return (request, response) -> response.asJson(this.storageProvider.getJobById(request.param(":id", UUID.class)));
    }

    private HttpRequestHandler deleteJobById() {
        return (request, response) -> {
            Job job = this.storageProvider.getJobById(request.param(":id", UUID.class));
            job.delete("Job deleted via Dashboard");
            this.storageProvider.save(job);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler requeueJobById() {
        return (request, response) -> {
            Job job = this.storageProvider.getJobById(request.param(":id", UUID.class));
            job.enqueue();
            this.storageProvider.save(job);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler findJobByState() {
        return (request, response) -> response.asJson(this.storageProvider.getJobPage(request.queryParam("state", StateName.class, StateName.ENQUEUED), request.fromQueryParams(PageRequest.class)));
    }

    private HttpRequestHandler getProblems() {
        return (request, response) -> response.asJson(this.problemsManager().getProblems());
    }

    private HttpRequestHandler deleteProblemByType() {
        return (request, response) -> {
            this.problemsManager().dismissProblemOfType(request.param(":type", String.class));
            response.statusCode(204);
        };
    }

    private HttpRequestHandler getRecurringJobs() {
        return (request, response) -> {
            PageRequest pageRequest = request.fromQueryParams(PageRequest.class);
            RecurringJobsResult recurringJobs = this.recurringJobResults();
            List recurringJobUIModels = recurringJobs.stream().skip(pageRequest.getOffset()).limit(pageRequest.getLimit()).map(RecurringJobUIModel::new).collect(Collectors.toList());
            Page result = new Page(recurringJobs.size(), recurringJobUIModels, pageRequest);
            response.asJson(result);
        };
    }

    private HttpRequestHandler deleteRecurringJob() {
        return (request, response) -> {
            this.storageProvider.deleteRecurringJob(request.param(":id"));
            response.statusCode(204);
        };
    }

    private HttpRequestHandler triggerRecurringJob() {
        return (request, response) -> {
            RecurringJob recurringJob = this.recurringJobResults().stream().filter(rj -> request.param(":id").equals(rj.getId())).findFirst().orElseThrow(() -> new JobNotFoundException(request.param(":id")));
            Job job = recurringJob.toEnqueuedJob();
            this.storageProvider.save(job);
            response.statusCode(204);
        };
    }

    private HttpRequestHandler getBackgroundJobServers() {
        return (request, response) -> response.asJson(this.storageProvider.getBackgroundJobServers());
    }

    private HttpRequestHandler getVersion() {
        return (request, response) -> response.asJson(this.getVersionUIModel());
    }

    private VersionUIModel getVersionUIModel() {
        if (this.versionUIModel != null) {
            return this.versionUIModel;
        }
        if (this.allowAnonymousDataUsage) {
            JobRunrMetadata metadata = this.storageProvider.getMetadata("id", "cluster");
            if (metadata != null) {
                String storageProviderType = this.storageProvider instanceof ThreadSafeStorageProvider ? ((ThreadSafeStorageProvider)this.storageProvider).getStorageProvider().getClass().getSimpleName() : this.storageProvider.getClass().getSimpleName();
                this.versionUIModel = VersionUIModel.withAnonymousDataUsage(metadata.getValue(), storageProviderType);
                return this.versionUIModel;
            }
            return VersionUIModel.withoutAnonymousDataUsage();
        }
        this.versionUIModel = VersionUIModel.withoutAnonymousDataUsage();
        return this.versionUIModel;
    }

    private ProblemsManager problemsManager() {
        if (this.problemsManager == null) {
            this.problemsManager = new ProblemsManager(this.storageProvider);
        }
        return this.problemsManager;
    }

    private RecurringJobsResult recurringJobResults() {
        if (this.recurringJobsResult == null || this.storageProvider.recurringJobsUpdated(this.recurringJobsResult.getLastModifiedHash())) {
            this.recurringJobsResult = this.storageProvider.getRecurringJobs();
        }
        return this.recurringJobsResult;
    }
}

